/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;

public class GraphUtil {
    public static Vector<CFAEdge> makeEdgePath(Vector<CFANode> nodes) {
        Vector<CFAEdge> edges = new Vector<CFAEdge>();
        int len = nodes.size();
        for (int i = 0; i < len - 1; ++i) {
            CFANode N = nodes.get(i);
            CFANode M = nodes.get(i + 1);
            CFAEdge E = N.getEdgeTo(M);
            edges.add(E);
        }
        return edges;
    }

    public static Vector<CFAEdge> makeEdgeLoop(List<CFANode> nodes, LogManager logger) {
        Vector<CFAEdge> edges = new Vector<CFAEdge>();
        GraphUtil.writeAllSuccessors(nodes, logger);
        CFANode loopHead = null;
        for (CFANode N : nodes) {
            if (!N.isLoopStart()) continue;
            loopHead = N;
            break;
        }
        if (loopHead == null) {
            return null;
        }
        logger.log(Level.ALL, new Object[]{"Loop head is: ", loopHead});
        CFANode current = loopHead;
        block1: do {
            for (CFANode N : nodes) {
                if (!current.hasEdgeTo(N)) continue;
                logger.log(Level.ALL, new Object[]{"Found next node in loop: ", N});
                CFAEdge e = current.getEdgeTo(N);
                edges.add(e);
                current = N;
                nodes.remove(N);
                continue block1;
            }
        } while (current != loopHead);
        if (current.hasEdgeTo(loopHead)) {
            CFAEdge e = current.getEdgeTo(loopHead);
            edges.add(e);
        }
        return edges;
    }

    private static void writeAllSuccessors(List<CFANode> nodes, LogManager logger) {
        logger.log(Level.ALL, new Object[]{"Computing successors of all nodes."});
        for (CFANode n : nodes) {
            logger.log(Level.ALL, new Object[]{"Successors of ", n});
            int e = n.getNumLeavingEdges();
            Vector<CFANode> list = new Vector<CFANode>(e);
            for (int i = 0; i < e; ++i) {
                CFAEdge edge = n.getLeavingEdge(i);
                CFANode s = edge.getSuccessor();
                list.add(s);
            }
            logger.log(Level.ALL, new Object[]{list});
        }
    }

    public static Vector<CFANode> dfs(CFANode start, CFANode target, boolean reverse, boolean interprocedural) {
        Vector<CFANode> path = new Vector<CFANode>();
        HashSet<CFANode> seen = new HashSet<CFANode>();
        HashMap<CFANode, CFANode> links = new HashMap<CFANode, CFANode>();
        ArrayDeque<CFANode> toProcess = new ArrayDeque<CFANode>();
        toProcess.push(start);
        while (!toProcess.isEmpty()) {
            CFANode s;
            CFANode s2;
            CFAEdge e;
            CFANode n = (CFANode)toProcess.pop();
            if (n == target) {
                Vector<CFANode> back = new Vector<CFANode>();
                back.add(n);
                while (n != start && links.containsKey(n)) {
                    n = (CFANode)links.get(n);
                    back.add(n);
                }
                for (int i = back.size() - 1; i >= 0; --i) {
                    path.add((CFANode)back.get(i));
                }
                break;
            }
            seen.add(n);
            if (reverse) {
                CFANode s3;
                for (int i = 0; i < n.getNumEnteringEdges(); ++i) {
                    e = n.getEnteringEdge(i);
                    if (!interprocedural && (e instanceof FunctionCallEdge || e instanceof FunctionReturnEdge) || seen.contains(s2 = e.getPredecessor())) continue;
                    toProcess.push(s2);
                    links.put(s2, n);
                }
                if (n.getEnteringSummaryEdge() == null || seen.contains(s3 = n.getEnteringSummaryEdge().getPredecessor())) continue;
                toProcess.push(s3);
                links.put(s3, n);
                continue;
            }
            for (int i = 0; i < n.getNumLeavingEdges(); ++i) {
                e = n.getLeavingEdge(i);
                if (!interprocedural && (e instanceof FunctionCallEdge || e instanceof FunctionReturnEdge) || seen.contains(s2 = e.getSuccessor())) continue;
                toProcess.push(s2);
                links.put(s2, n);
            }
            if (n.getLeavingSummaryEdge() == null || seen.contains(s = n.getLeavingSummaryEdge().getSuccessor())) continue;
            toProcess.push(s);
            links.put(s, n);
        }
        return path;
    }
}

