/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.interfaces.GeneralVariable;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;

public class LinearInequality {
    private Vector<List<Coeff>> rows = new Vector();
    private Vector<InfixReln> relns = new Vector();
    private Vector<Coeff> rhs = new Vector();
    private final VariableManager vmgr;

    public LinearInequality(VariableManager vmgr) {
        this.vmgr = vmgr;
    }

    public int getNumIneqs() {
        return this.rows.size();
    }

    public int getNumVars() {
        return this.vmgr.getNumVars();
    }

    public Coeff getCoeff(int i, int j) {
        Coeff a = null;
        try {
            a = this.rows.get(i).get(j);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(e.getMessage());
        }
        return a;
    }

    public InfixReln getReln(int i) {
        InfixReln a = null;
        try {
            a = this.relns.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(e.getMessage());
        }
        return a;
    }

    public Coeff getRHSCoeff(int i) {
        Coeff a = null;
        try {
            a = this.rhs.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(e.getMessage());
        }
        return a;
    }

    public void addIneq(List<Coeff> coeffs, InfixReln r, Coeff ub) {
        this.rows.add(coeffs);
        this.relns.add(r);
        this.rhs.add(ub);
    }

    public void setRows(Vector<List<Coeff>> rows) {
        this.rows = rows;
    }

    public Vector<List<Coeff>> getRows() {
        return this.rows;
    }

    public void setRelns(Vector<InfixReln> relns) {
        this.relns = relns;
    }

    public Vector<InfixReln> getRelns() {
        return this.relns;
    }

    public void setRHS(Vector<Coeff> rhs) {
        this.rhs = rhs;
    }

    public Vector<Coeff> getRHS() {
        return this.rhs;
    }

    public Vector<Integer> findStrict() {
        Vector<Integer> strict = new Vector<Integer>();
        for (int i = 0; i < this.relns.size(); ++i) {
            InfixReln R = this.relns.get(i);
            if (!R.equals((Object)InfixReln.LT)) continue;
            strict.add(i);
        }
        return strict;
    }

    public LinearInequality combine(LinearInequality B) {
        int i;
        int i2;
        Vector<List<Coeff>> rows = new Vector<List<Coeff>>();
        Vector<InfixReln> relns = new Vector<InfixReln>();
        Vector<Coeff> rhs = new Vector<Coeff>();
        for (int i3 = 0; i3 < this.rows.size(); ++i3) {
            rows.add(this.rows.get(i3));
        }
        Vector<List<Coeff>> rowsB = B.getRows();
        for (i2 = 0; i2 < rowsB.size(); ++i2) {
            rows.add(rowsB.get(i2));
        }
        for (i2 = 0; i2 < this.relns.size(); ++i2) {
            relns.add(this.relns.get(i2));
        }
        Vector<InfixReln> relnsB = B.getRelns();
        for (i = 0; i < relnsB.size(); ++i) {
            relns.add(relnsB.get(i));
        }
        for (i = 0; i < this.rhs.size(); ++i) {
            rhs.add(this.rhs.get(i));
        }
        Vector<Coeff> rhsB = B.getRHS();
        for (int i4 = 0; i4 < rhsB.size(); ++i4) {
            rhs.add(rhsB.get(i4));
        }
        LinearInequality AB = new LinearInequality(this.vmgr);
        AB.setRows(rows);
        AB.setRelns(relns);
        AB.setRHS(rhs);
        return AB;
    }

    public void append(LinearInequality B) {
        this.rows.addAll(B.rows);
        this.relns.addAll(B.relns);
        this.rhs.addAll(B.rhs);
    }

    public String toString() {
        Coeff C;
        String s = "Matrix:\n";
        for (int i = 0; i < this.rows.size(); ++i) {
            List<Coeff> row = this.rows.get(i);
            for (int j = 0; j < row.size(); ++j) {
                C = row.get(j);
                s = s + " " + C.toString();
            }
            s = s + "\n";
        }
        s = s + "Variables:\n";
        Iterator<GeneralVariable> vars = this.vmgr.iterator();
        while (vars.hasNext()) {
            GeneralVariable V = vars.next();
            s = s + " " + ((Object)V).toString();
        }
        s = s + "\nrelations and RHS:\n";
        for (int i = 0; i < this.rhs.size(); ++i) {
            InfixReln R = this.relns.get(i);
            C = this.rhs.get(i);
            s = s + " " + R.toString() + " " + C.toString();
        }
        s = s + "\n";
        return s;
    }
}

