/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;

public class Rational {
    private final int num;
    private final int denom;
    private final boolean infty;

    public Rational(int n, int d) {
        if (d == 0) {
            this.infty = true;
            this.num = 0;
            this.denom = 0;
        } else {
            this.infty = false;
            if (d < 0) {
                this.num = -n;
                this.denom = -d;
            } else {
                this.num = n;
                this.denom = d;
            }
        }
    }

    public Rational copy() {
        return new Rational(this.num, this.denom);
    }

    public Rational makeNegative() {
        return new Rational(-this.num, this.denom);
    }

    public Rational makeReciprocal() {
        return new Rational(this.denom, this.num);
    }

    public static Rational makeUnity() {
        return new Rational(1, 1);
    }

    public static Rational makeZero() {
        return new Rational(0, 1);
    }

    public boolean equals(Rational r) {
        boolean ans = false;
        if (!this.isInfinite() && !r.isInfinite()) {
            ans = this.div(r).isUnity();
        }
        return ans;
    }

    public boolean isInfinite() {
        return this.infty;
    }

    public boolean isIntegral() {
        return !this.isInfinite() && this.num % this.denom == 0;
    }

    public boolean isZero() {
        return !this.isInfinite() && this.num == 0;
    }

    public boolean isUnity() {
        return !this.isInfinite() && this.num == this.denom;
    }

    public boolean isPositive() {
        return !this.isInfinite() && (this.denom > 0 && this.num > 0 || this.denom < 0 && this.num < 0);
    }

    public int getHeight() {
        int a = Math.abs(this.num);
        int b = Math.abs(this.denom);
        return Math.max(a, b);
    }

    public int getNumerator() {
        return this.num;
    }

    public int getDenominator() {
        return this.denom;
    }

    public Integer makeInteger() {
        Integer z = null;
        if (this.isIntegral()) {
            z = new Integer(this.num / this.denom);
        }
        return z;
    }

    public String toString() {
        String s = null;
        if (this.isIntegral()) {
            s = this.makeInteger().toString();
        } else {
            String a = Integer.toString(this.num);
            String b = Integer.toString(this.denom);
            s = a + "/" + b;
        }
        return s;
    }

    public Rational operate(String op, Rational other) {
        Rational r = null;
        if (op.equals("+")) {
            r = this.plus(other);
        } else if (op.equals("-")) {
            r = this.minus(other);
        } else if (op.equals("*")) {
            r = this.times(other);
        } else if (op.equals("/")) {
            r = this.div(other);
        }
        return r;
    }

    public Rational leastTerms() {
        int g = Polynomial.gcd(this.num, this.denom);
        int n = this.num / g;
        int d = this.denom / g;
        return new Rational(n, d);
    }

    public Rational times(Rational other) {
        int n = this.num * other.num;
        int d = this.denom * other.denom;
        return new Rational(n, d).leastTerms();
    }

    public Rational div(Rational other) {
        int a = other.num;
        int b = other.denom;
        int n = this.num * b;
        int d = this.denom * a;
        return new Rational(n, d).leastTerms();
    }

    public Rational plus(Rational other) {
        int a = this.num;
        int b = this.denom;
        int c = other.num;
        int d = other.denom;
        int p = a * d + b * c;
        int q = b * d;
        return new Rational(p, q).leastTerms();
    }

    public Rational minus(Rational other) {
        int a = this.num;
        int b = this.denom;
        int c = other.num;
        int d = other.denom;
        int p = a * d - b * c;
        int q = b * d;
        return new Rational(p, q).leastTerms();
    }
}

