/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants;

import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;

public class TFtester {
    public static void main(String[] args) {
        TemplateFormulaManager tfm = new TemplateFormulaManager();
        Formula a1 = tfm.makeVariable("a", 1);
        Formula a2 = tfm.makeVariable("a", 2);
        Formula b1 = tfm.makeVariable("b", 1);
        Formula b2 = tfm.makeVariable("b", 2);
        Formula c1 = tfm.makeVariable("c", 1);
        Formula c2 = tfm.makeVariable("c", 2);
        Formula d1 = tfm.makeVariable("d", 1);
        Formula d2 = tfm.makeVariable("d", 2);
        Formula A = tfm.makeGeq(a1, a2);
        Formula B = tfm.makeGt(b1, b2);
        Formula C = tfm.makeLeq(c1, c2);
        Formula D = tfm.makeLt(d1, d2);
        Formula P = tfm.makeOr(A, B);
        Formula Q = tfm.makeOr(C, D);
        Formula R = tfm.makeNot(Q);
        TemplateBoolean F = (TemplateBoolean)tfm.makeAnd(P, R);
        TFtester.printS("R:");
        TFtester.printTF(R);
        TFtester.printS("F:");
        TFtester.printTF(F);
        F.flatten();
        TFtester.printS("F:");
        TFtester.printTF(F);
        TemplateBoolean G = F.makeCNF();
        TemplateBoolean H = F.makeDNF();
        TFtester.printS("CNF:");
        TFtester.printTF(G);
        TFtester.printS("DNF:");
        TFtester.printTF(H);
        TemplateBoolean Gs = F.makeSCNF();
        TemplateBoolean Hs = F.makeSDNF();
        TFtester.printS("Strong CNF:");
        TFtester.printTF(Gs);
        TFtester.printS("Strong DNF:");
        TFtester.printTF(Hs);
        TemplateBoolean M = F;
        TemplateBoolean N = (TemplateBoolean)tfm.makeNot(M);
        TFtester.printS("N:");
        TFtester.printTF(N);
        TemplateBoolean K = M.logicNegate();
        TFtester.printS("N's argument negated:");
        TFtester.printTF(K);
        TemplateBoolean L = N.absorbNegations();
        TFtester.printS("N negation absorbed:");
        TFtester.printTF(L);
    }

    private static void printS(String s) {
        System.out.println(s);
    }

    private static void printTF(Formula f) {
        System.out.println(f.toString());
    }
}

