/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Vector;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;

public class Assumption {
    private final RationalFunction func;
    private final AssumptionType atype;

    public Assumption(Polynomial f, AssumptionType a) {
        Pair<RationalFunction, AssumptionType> p = this.simplify(f, a);
        this.func = (RationalFunction)p.getFirst();
        this.atype = (AssumptionType)((Object)p.getSecond());
    }

    public Assumption(RationalFunction f, AssumptionType a) {
        if (f.isPolynomial()) {
            Pair<RationalFunction, AssumptionType> p = this.simplify(f.getNumerator(), a);
            f = (RationalFunction)p.getFirst();
            a = (AssumptionType)((Object)p.getSecond());
        }
        f.simplify();
        this.func = f;
        this.atype = a;
    }

    public Assumption not() {
        AssumptionType b = this.atype.not();
        return new Assumption(this.func, b);
    }

    public Assumption strengthen(Assumption b) {
        if (RationalFunction.subtract(this.func, b.func).isZero()) {
            AssumptionType t = AssumptionType.conjoin(this.atype, b.atype);
            return new Assumption(b.func, t);
        }
        if (RationalFunction.add(this.func, b.func).isZero()) {
            AssumptionType t = AssumptionType.conjoin(this.atype.flip(), b.atype);
            return new Assumption(b.func, t);
        }
        return null;
    }

    public AssumptionRelation matchAgainst(Assumption other) {
        AssumptionType ot = null;
        if (RationalFunction.subtract(this.func, other.func).isZero()) {
            ot = other.atype;
        } else if (RationalFunction.add(this.func, other.func).isZero()) {
            ot = other.atype.flip();
        }
        if (ot == null) {
            return AssumptionRelation.DOESNOTCOMPARETO;
        }
        AssumptionType tt = this.atype;
        if (tt == ot) {
            return AssumptionRelation.ISSAMEAS;
        }
        AssumptionType ct = AssumptionType.conjoin(tt, ot);
        if (ct == AssumptionType.FALSE) {
            return AssumptionRelation.CONTRADICTS;
        }
        if (ct == tt) {
            return AssumptionRelation.STRENGTHENS;
        }
        if (ct == ot) {
            return AssumptionRelation.WEAKENS;
        }
        return AssumptionRelation.REFINES;
    }

    private Pair<RationalFunction, AssumptionType> simplify(Polynomial f, AssumptionType a) {
        int u = (f = f.cancelRationalContent()).getUnitContent();
        if (u != 0) {
            int c = f.getIntegerContent();
            int d = c == 0 ? 1 : c;
            d = u * d;
            Rational r = new Rational(1, d);
            f = Polynomial.multiply(f, new Polynomial(r));
            if (u < 0) {
                a = a.flip();
            }
        }
        RationalFunction g = new RationalFunction(f);
        return Pair.of((Object)g, (Object)((Object)a));
    }

    public RationalFunction getRationalFunction() {
        return this.func;
    }

    public AssumptionType getAssumptionType() {
        return this.atype;
    }

    public Polynomial getNumerator() {
        return this.func.getNumerator();
    }

    public boolean equals(Object o) {
        boolean ans = false;
        if (o instanceof Assumption) {
            Assumption a = (Assumption)o;
            String s1 = this.toString();
            String s2 = a.toString();
            ans = s1.equals(s2);
        }
        return ans;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        if (this.atype == AssumptionType.TRUE || this.atype == AssumptionType.FALSE) {
            return this.atype.toString();
        }
        if (this.func.isPolynomial()) {
            return this.func.toString() + this.atype.toString();
        }
        Polynomial num = this.func.getNumerator();
        Polynomial denom = this.func.getDenominator();
        if (this.atype == AssumptionType.ZERO || this.atype == AssumptionType.NONZERO) {
            return num.toString() + this.atype.toString();
        }
        String s = "((" + denom.toString() + " > 0 and " + num.toString() + this.atype.toString() + ")";
        s = s + " or (" + denom.toString() + " < 0 and " + num.toString() + this.atype.flip().toString() + "))";
        return s;
    }

    public static enum AssumptionType {
        TRUE("0 = 0"),
        NONZERO(" <> 0"),
        NONPOSITIVE(" <= 0"),
        NEGATIVE(" < 0"),
        NONNEGATIVE(" >= 0"),
        POSITIVE(" > 0"),
        ZERO(" = 0"),
        FALSE("0 <> 0");

        private final String text;
        private static final Vector<AssumptionType> codes;

        public int getCode() {
            return codes.indexOf((Object)this);
        }

        private AssumptionType(String t) {
            this.text = t;
        }

        public AssumptionType not() {
            int n = codes.indexOf((Object)this);
            return codes.get(7 - n);
        }

        public static AssumptionType conjoin(AssumptionType a, AssumptionType b) {
            int na = codes.indexOf((Object)a);
            int nb = codes.indexOf((Object)b);
            int nc = na & nb;
            return codes.get(nc);
        }

        public AssumptionType flip() {
            AssumptionType a;
            switch (this) {
                case POSITIVE: {
                    a = NEGATIVE;
                    break;
                }
                case NEGATIVE: {
                    a = POSITIVE;
                    break;
                }
                case NONNEGATIVE: {
                    a = NONPOSITIVE;
                    break;
                }
                case NONPOSITIVE: {
                    a = NONNEGATIVE;
                    break;
                }
                default: {
                    a = this;
                }
            }
            return a;
        }

        public String toString() {
            return this.text;
        }

        static {
            codes = new Vector(8);
            codes.add(FALSE);
            codes.add(ZERO);
            codes.add(POSITIVE);
            codes.add(NONNEGATIVE);
            codes.add(NEGATIVE);
            codes.add(NONPOSITIVE);
            codes.add(NONZERO);
            codes.add(TRUE);
        }
    }

    public static enum AssumptionRelation {
        CONTRADICTS(5),
        ISSAMEAS(4),
        WEAKENS(3),
        REFINES(2),
        STRENGTHENS(1),
        DOESNOTCOMPARETO(0);

        private final int num;

        private AssumptionRelation(int n2) {
            this.num = n2;
        }

        public int getNum() {
            return this.num;
        }
    }
}

