/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionStack;
import org.sosy_lab.cpachecker.util.invariants.balancer.BadAssumptionsException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Substitution;
import org.sosy_lab.cpachecker.util.invariants.balancer.SubstitutionManager;

public class AssumptionManager {
    private LogManager logger;
    private Deque<Matrix> currentMatrixQueue;
    private Matrix currentMatrix;
    private AssumptionStack stack;
    private AssumptionSet currentAssumptionSet;

    public AssumptionManager(List<Matrix> ml, LogManager lm) {
        this.logger = lm;
        this.makeMatrixQueueCopy(ml);
        this.stack = new AssumptionStack();
        this.currentAssumptionSet = new AssumptionSet();
    }

    Matrix nextMatrix() {
        this.currentMatrix = this.currentMatrixQueue.pollFirst();
        return this.currentMatrix;
    }

    void addPossiblyUnnecessaryAssumption(Assumption a) throws BadAssumptionsException {
        Assumption.AssumptionRelation rel = this.matchAgainst(a);
        switch (rel) {
            case CONTRADICTS: {
                this.logger.log(Level.ALL, new Object[]{"Tried to add contradictory assumption!", a});
                throw new BadAssumptionsException();
            }
            case WEAKENS: 
            case ISSAMEAS: {
                this.logger.log(Level.ALL, new Object[]{"Assumption", a, "already implied by existing set. We leave the set unchanged."});
                return;
            }
        }
        this.logger.log(Level.ALL, new Object[]{"Adding new possibly unnecessary assumption, ", a});
        this.stack.addNewFrame(this.currentAssumptionSet, this.allCurrentMatrices(), a);
        this.currentAssumptionSet.add(a);
        this.logger.log(Level.ALL, new Object[]{"Current assumption set is now:\n", this.currentAssumptionSet});
        this.zeroSubsCurrent(a);
    }

    private List<Matrix> allCurrentMatrices() {
        Vector<Matrix> ml = new Vector<Matrix>(this.currentMatrixQueue.size() + 1);
        if (this.currentMatrix != null) {
            ml.add(this.currentMatrix);
        }
        ml.addAll(this.currentMatrixQueue);
        return ml;
    }

    void addNecessaryAssumption(Assumption a) throws BadAssumptionsException {
        AssumptionSet as = new AssumptionSet();
        as.add(a);
        this.addNecessaryAssumptions(as);
    }

    public void addNecessaryAssumptions(AssumptionSet na) throws BadAssumptionsException {
        this.logger.log(Level.ALL, new Object[]{"Adding necessary assumptions:", na});
        boolean consistent = this.currentAssumptionSet.addAll(na);
        if (!consistent) {
            this.logger.log(Level.ALL, new Object[]{"There was a contradiction!"});
            throw new BadAssumptionsException();
        }
        this.logger.log(Level.ALL, new Object[]{"There was no immediate contradiction.", "Assumption set is now:\n", this.currentAssumptionSet, "\nWe now apply substitutions if possible."});
        this.zeroSubsCurrent(na);
    }

    public Assumption.AssumptionRelation matchAgainst(Assumption a) {
        return this.currentAssumptionSet.matchAgainst(a);
    }

    public boolean nextBranch() {
        Boolean result = null;
        while (result == null) {
            try {
                result = this.nextFrame();
            }
            catch (BadAssumptionsException badAssumptionsException) {}
        }
        return result;
    }

    private boolean nextFrame() throws BadAssumptionsException {
        AssumptionStack.Frame f = this.stack.popFrame();
        if (f == null) {
            this.logger.log(Level.ALL, new Object[]{"The assumption manager has no more stack frames. We are out of options."});
            return false;
        }
        this.currentAssumptionSet = f.getAssumptionSet();
        this.currentMatrixQueue = new ArrayDeque<Matrix>(f.getMatrices());
        this.currentMatrix = null;
        this.logger.log(Level.ALL, new Object[]{"Restoring assumption set to:\n", this.currentAssumptionSet});
        this.logger.log(Level.ALL, new Object[]{"Restoring matrix queue to:\n", this.currentMatrixQueue});
        Assumption a = f.getAssumption();
        this.logger.log(Level.ALL, new Object[]{"We now apply assumption", a, "whose negation we applied last time we were at this juncture."});
        this.addNecessaryAssumption(a);
        return true;
    }

    public void makeMatrixQueueCopy(Collection<Matrix> c) {
        this.currentMatrixQueue = new ArrayDeque<Matrix>();
        for (Matrix m : c) {
            this.currentMatrixQueue.add(m.copy());
        }
    }

    public AssumptionSet getCurrentAssumptionSet() {
        return this.currentAssumptionSet;
    }

    public void setCurrentAssumptionSet(AssumptionSet a) {
        this.currentAssumptionSet = a;
    }

    void zeroSubsCurrent(Assumption a) {
        AssumptionSet as = new AssumptionSet();
        as.add(a);
        this.zeroSubsCurrent(as);
    }

    public void zeroSubsCurrent(AssumptionSet aset) {
        List<Matrix> ml = this.allCurrentMatrices();
        Vector<Substitution> subs = new Vector<Substitution>();
        for (Assumption a : aset) {
            Polynomial num;
            Substitution s;
            if (a.getAssumptionType() != Assumption.AssumptionType.ZERO || (s = (num = a.getNumerator()).linearIsolateFirst()) == null) continue;
            subs.add(s);
        }
        if (subs.size() == 0) {
            return;
        }
        for (Matrix m : ml) {
            Vector<Substitution> ss = new Vector<Substitution>(subs.size());
            for (Substitution s : subs) {
                ss.add(s.copy());
            }
            SubstitutionManager sman = new SubstitutionManager(ss, this.logger);
            this.logger.log(Level.ALL, new Object[]{"Applying substitutions to matrix:", "\n" + m.toString()});
            sman.applyAll(m);
            this.logger.log(Level.ALL, new Object[]{"Matrix is now:", "\n" + m.toString()});
        }
    }
}

