/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;

public class AssumptionSet
implements Iterable<Assumption> {
    private final Vector<Assumption> aset = new Vector();

    public AssumptionSet() {
    }

    public AssumptionSet(Collection<Assumption> ca) {
        for (Assumption a : ca) {
            this.add(a);
        }
    }

    public AssumptionSet(AssumptionSet as) {
        for (Assumption a : as) {
            this.aset.add(a);
        }
    }

    @Override
    public Iterator<Assumption> iterator() {
        return this.aset.iterator();
    }

    public int size() {
        return this.aset.size();
    }

    public String toString() {
        return this.aset.toString();
    }

    public String writeQEformula() {
        String phi = "";
        for (Assumption a : this.aset) {
            phi = phi + " and " + a.toString();
        }
        if (phi.length() > 0) {
            phi = phi.substring(5);
        }
        phi = "rlex(" + phi + ")";
        return phi;
    }

    public boolean add(Assumption a) {
        for (int i = 0; i < this.aset.size(); ++i) {
            Assumption b = this.aset.get(i);
            Assumption c = a.strengthen(b);
            if (c == null) continue;
            this.aset.set(i, c);
            return c.getAssumptionType() != Assumption.AssumptionType.FALSE;
        }
        this.aset.add(a);
        return a.getAssumptionType() != Assumption.AssumptionType.FALSE;
    }

    public boolean add(Assumption a, boolean writeArgs) {
        System.out.println("Set was:" + this.toString());
        System.out.println("Adding:" + a.toString());
        for (int i = 0; i < this.aset.size(); ++i) {
            Assumption b = this.aset.get(i);
            System.out.println("Strengthening" + b + "by" + a);
            Assumption c = a.strengthen(b);
            if (c != null) {
                System.out.println("Got" + c);
                continue;
            }
            System.out.println("Got null");
        }
        boolean bl = this.add(a);
        System.out.println("Set is now:" + this.toString());
        return bl;
    }

    public boolean addAll(Collection<Assumption> ca) {
        boolean result = true;
        for (Assumption a : ca) {
            result &= this.add(a);
        }
        return result;
    }

    public boolean addAll(AssumptionSet a) {
        return this.addAll(a.aset);
    }

    public boolean contains(Assumption a) {
        return this.aset.contains(a);
    }

    public boolean isSubsetOf(AssumptionSet that) {
        boolean subset = true;
        for (Assumption a : this.aset) {
            if (that.contains(a)) continue;
            subset = false;
            break;
        }
        return subset;
    }

    public boolean equals(AssumptionSet that) {
        return this.isSubsetOf(that) && that.isSubsetOf(this);
    }

    public Assumption.AssumptionRelation matchAgainst(Assumption a) {
        Assumption.AssumptionRelation max = Assumption.AssumptionRelation.DOESNOTCOMPARETO;
        for (Assumption b : this.aset) {
            Assumption.AssumptionRelation rel = a.matchAgainst(b);
            if (rel.getNum() <= max.getNum()) continue;
            max = rel;
        }
        return max;
    }

    public Assumption.AssumptionType query(RationalFunction f) {
        Assumption.AssumptionType at = Assumption.AssumptionType.TRUE;
        Assumption a = new Assumption(f, at);
        for (Assumption b : this.aset) {
            Assumption c = b.strengthen(a);
            if (c == null) continue;
            RationalFunction g = b.getRationalFunction();
            if (g.isZero()) {
                return Assumption.AssumptionType.ZERO;
            }
            RationalFunction q = RationalFunction.divide(f, g);
            if (!q.isConstant()) {
                return Assumption.AssumptionType.TRUE;
            }
            at = b.getAssumptionType();
            if (q.isPositive()) continue;
            at = at.flip();
        }
        return at;
    }
}

