/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;

public class AssumptionStack {
    private Stack<Frame> frames = new Stack();

    void addNewFrame(AssumptionSet as, List<Matrix> ml, Assumption a) {
        as = new AssumptionSet(as);
        ml = this.copyMatrices(ml);
        a = a.not();
        Frame f = new Frame(as, ml, a);
        this.frames.add(f);
    }

    Frame popFrame() {
        if (this.frames.empty()) {
            return null;
        }
        return this.frames.pop();
    }

    private List<Matrix> copyMatrices(List<Matrix> ml) {
        Vector<Matrix> n = new Vector<Matrix>(ml.size());
        for (Matrix m : ml) {
            n.add(m.copy());
        }
        return n;
    }

    public class Frame {
        private List<Matrix> matrices;
        private AssumptionSet aset;
        private Assumption a;

        public Frame(AssumptionSet as, List<Matrix> ml, Assumption an) {
            this.aset = as;
            this.matrices = ml;
            this.a = an;
        }

        public List<Matrix> getMatrices() {
            return this.matrices;
        }

        public AssumptionSet getAssumptionSet() {
            return this.aset;
        }

        public Assumption getAssumption() {
            return this.a;
        }
    }
}

