/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.invariants.Farkas;
import org.sosy_lab.cpachecker.util.invariants.LinearInequality;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Balancer;
import org.sosy_lab.cpachecker.util.invariants.balancer.BasicFormulaMatriciser;
import org.sosy_lab.cpachecker.util.invariants.balancer.FormulaMatriciser;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixSolver;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixSolvingFailedException;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateMap;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateNetwork;
import org.sosy_lab.cpachecker.util.invariants.balancer.Transition;
import org.sosy_lab.cpachecker.util.invariants.balancer.UIFAxiom;
import org.sosy_lab.cpachecker.util.invariants.balancer.UIFAxiomSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.balancer.interfaces.MatrixI;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.redlog.EliminationAnswer;
import org.sosy_lab.cpachecker.util.invariants.redlog.EliminationHandler;
import org.sosy_lab.cpachecker.util.invariants.redlog.RedlogInterface;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateDisjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateLinearizer;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class BasicBalancer
implements Balancer {
    private UIFAxiomStrategy strategy = UIFAxiomStrategy.DONOTUSEAXIOMS;
    private FormulaMatriciser formMat = new BasicFormulaMatriciser();
    private Map<String, Variable> paramVars = null;
    private LogManager logger;
    private final RedlogInterface RLI;
    final Timer redlog = new Timer();

    public BasicBalancer(LogManager lm) {
        this.logger = lm;
        this.RLI = new RedlogInterface(this.logger);
    }

    public void setAxiomStrategy(UIFAxiomStrategy s) {
        this.strategy = s;
    }

    @Override
    public boolean balance(TemplateNetwork tnet) throws RefinementFailedException {
        int[] methods = new int[]{1};
        boolean succeed = false;
        for (int i = 0; i < methods.length; ++i) {
            int method = methods[i];
            switch (method) {
                case 0: {
                    succeed = this.balanceWithRREF(tnet);
                    break;
                }
                case 1: {
                    succeed = this.balanceWithQEonly(tnet);
                }
            }
            if (succeed) break;
        }
        return succeed;
    }

    public boolean balanceWithRREF(TemplateNetwork tnet) throws RefinementFailedException {
        this.logger.log(Level.FINEST, new Object[]{"Attempting to balance template network with RREF heuristic."});
        Set<String> params = tnet.writeAllParameters(VariableWriteMode.REDLOG);
        this.paramVars = this.makeParamVars(params);
        AssumptionSet aset = new AssumptionSet();
        for (Transition t : tnet.getTransitions()) {
            AssumptionSet as = this.getRREFassumptions(t, tnet);
            aset.addAll(as);
            tnet.setAssumptions(aset);
        }
        HashMap<String, Rational> map = null;
        boolean succeed = false;
        if (aset.size() == 0) {
            map = new HashMap<String, Rational>();
        } else {
            String phi = this.writeRREFassumptionQEformula(aset);
            this.logger.log(Level.ALL, new Object[]{"QE formula for all RREF assumptions:\n", phi});
            this.redlog.start();
            map = this.getParameterValuesFromRedlog(phi, params);
            this.redlog.stop();
            this.logger.log(Level.ALL, new Object[]{"Redlog took", this.redlog.getSumTime(), "milliseconds."});
        }
        if (map == null) {
            this.logger.log(Level.FINEST, new Object[]{"Redlog could not find values for all parameters."});
        } else {
            this.fillInZeros(map, params);
            succeed = tnet.evaluate(map);
            if (!succeed) {
                this.logger.log(Level.FINEST, new Object[]{"Redlog appears to have completed, although not all parameters received values. Check for 'infinity' values."});
                this.logger.log(Level.ALL, new Object[]{"Templates after attempted evaluation:\n", tnet.dumpTemplates()});
            }
        }
        return succeed;
    }

    private Map<String, Variable> makeParamVars(Set<String> params) {
        HashMap<String, Variable> paramVars = new HashMap<String, Variable>();
        for (String p : params) {
            Variable v = new Variable(p);
            paramVars.put(p, v);
        }
        return paramVars;
    }

    private AssumptionSet getRREFassumptions(Transition t, TemplateNetwork tnet) throws RefinementFailedException {
        this.processSingleTransition(t, tnet, true);
        AssumptionSet aset = t.getRREFassumptions();
        this.logger.log(Level.ALL, new Object[]{"Assumptions:\n", aset});
        return aset;
    }

    private String writeRREFassumptionQEformula(AssumptionSet aset) {
        String phi = "";
        for (Assumption a : aset) {
            phi = phi + " and " + a.toString();
        }
        if (phi.length() > 0) {
            phi = phi.substring(5);
        }
        phi = "rlex(" + phi + ")";
        return phi;
    }

    public boolean balanceWithQEonly(TemplateNetwork tnet) throws RefinementFailedException {
        this.logger.log(Level.FINEST, new Object[]{"Attempting to balance template network with QE only."});
        Vector<Transition> transitions = tnet.getTransitions();
        for (Transition t : transitions) {
            this.processSingleTransition(t, tnet, false);
        }
        String Phi = "";
        HashSet<String> params = new HashSet<String>();
        for (Transition t : transitions) {
            Phi = Phi + " and " + t.getEliminationFormula();
            params.addAll(t.writeAllParameters(VariableWriteMode.REDLOG));
        }
        Phi = Phi + " and " + this.writeNonzeroParameterClause(tnet);
        Phi = "rlex(" + Phi.substring(5) + ")";
        this.logger.log(Level.ALL, new Object[]{"Combined formula for all transitions:\n", Phi});
        boolean succeed = false;
        this.redlog.start();
        HashMap<String, Rational> map = this.getParameterValuesFromRedlog(Phi, params);
        this.redlog.stop();
        this.logger.log(Level.ALL, new Object[]{"Redlog took", this.redlog.getSumTime(), "milliseconds."});
        if (map == null) {
            this.logger.log(Level.FINEST, new Object[]{"Redlog could not find values for all parameters."});
        } else {
            this.fillInZeros(map, params);
            succeed = tnet.evaluate(map);
            if (!succeed) {
                this.logger.log(Level.FINEST, new Object[]{"Redlog appears to have completed, although not all parameters received values. Check for 'infinity' values."});
                this.logger.log(Level.ALL, new Object[]{"Templates after attempted evaluation:\n", tnet.dumpTemplates()});
            }
        }
        return succeed;
    }

    private void processSingleTransition(Transition t, TemplateNetwork tnet, boolean useRREF) throws RefinementFailedException {
        TemplateMap tmap = tnet.getTemplateMap();
        TemplateFormula t1 = tmap.getTemplate(t.getStart()).getTemplateFormula();
        TemplateFormula p = t.getConstraint();
        TemplateFormula t2 = tmap.getTemplate(t.getEnd()).getTemplateFormula();
        if (t2 == t1) {
            t2 = t1.copy();
        }
        this.logger.log(Level.ALL, new Object[]{"\nInitial template:\n", t1, "\nPath formula:\n", p, "\nFinal template:\n", t2});
        HashMap<String, Integer> indices = p.getMaxIndices();
        t1.preindex(indices);
        t2.postindex(indices);
        this.logger.log(Level.ALL, new Object[]{"\nPreindexed initial template:\n", t1, "\nPostindexed final template:\n", t2});
        AliasingMap amap = new AliasingMap("v");
        t1.alias(amap);
        p.alias(amap);
        t2.alias(amap);
        this.logger.log(Level.ALL, new Object[]{"\nAliased formulas:\nInitial template:\n", t1, "\nPath formula:\n", p, "\nFinal template:\n", t2});
        Purification pur = new Purification("u");
        t1.purify(pur);
        p.purify(pur);
        t2.purify(pur);
        this.logger.log(Level.ALL, new Object[]{"\nPurified formulas:\nInitial template:\n", t1, "\nPath formula:\n", p, "\nFinal template:\n", t2});
        this.logger.log(Level.ALL, new Object[]{"\nPurification definitions:\n", pur});
        TemplateBoolean antB = TemplateConjunction.conjoin((TemplateBoolean)t1, (TemplateBoolean)p);
        TemplateDisjunction antD = (TemplateDisjunction)antB.makeSDNF();
        this.logger.log(Level.ALL, new Object[]{"\nSDNF of antecedent:\n", antD});
        int n = amap.size();
        int m = pur.size();
        TemplateVariableManager vmgr = new TemplateVariableManager(n, m);
        this.logger.log(Level.ALL, new Object[]{"Variable manager:\n", vmgr});
        switch (this.strategy) {
            case DONOTUSEAXIOMS: {
                if (useRREF) {
                    this.findSingleTransitionRREFassumptionsWithoutUIFAxioms(t, antD, t2, vmgr, tnet);
                    break;
                }
                this.findSingleTransitionFormulaWithoutUIFAxioms(t, antD, t2, vmgr);
                break;
            }
            case USEAXIOMS: {
                if (m >= 2) {
                    this.findSingleTransitionFormulaWithUIFAxioms(t, antD, t2, vmgr, pur);
                    break;
                }
                if (useRREF) {
                    this.findSingleTransitionRREFassumptionsWithoutUIFAxioms(t, antD, t2, vmgr, tnet);
                    break;
                }
                this.findSingleTransitionFormulaWithoutUIFAxioms(t, antD, t2, vmgr);
            }
        }
        t1.unpurify();
        t1.unalias();
        t1.unindex();
        t2.unpurify();
        t2.unalias();
        t2.unindex();
        p.unalias();
        p.unpurify();
    }

    private void findSingleTransitionRREFassumptionsWithoutUIFAxioms(Transition t, TemplateDisjunction ant, TemplateFormula t2, VariableManager vmgr, TemplateNetwork tnet) {
        AssumptionSet aset = this.consecRREF(ant, t2, vmgr, tnet);
        t.setRREFassumptions(aset);
    }

    private void findSingleTransitionFormulaWithoutUIFAxioms(Transition t, TemplateDisjunction ant, TemplateFormula t2, VariableManager vmgr) {
        String Phi = this.consecQE(ant, t2, vmgr);
        t.setEliminationFormula(Phi);
    }

    private void findSingleTransitionFormulaWithUIFAxioms(Transition t, TemplateDisjunction ant, TemplateFormula t2, VariableManager vmgr, Purification pur) throws RefinementFailedException {
        TemplateFormula[] tfs = new TemplateFormula[]{ant, t2};
        UIFAxiomSet A = new UIFAxiomSet(pur, tfs);
        String Phi = null;
        while (Phi == null && A.hasMore()) {
            Vector<UIFAxiom> U = A.getNext();
            this.logger.log(Level.ALL, new Object[]{"UIF Axiom Set:\n", U});
            Phi = this.consecQE(ant, t2, U, vmgr);
            Set<String> params = t.writeAllParameters(VariableWriteMode.REDLOG);
            params.addAll(this.getParameters(U, VariableWriteMode.REDLOG));
            String Psi = Phi + " and " + this.writeNonzeroParameterClause(t);
            Psi = "rlex(" + Psi + ")";
            this.logger.log(Level.ALL, new Object[]{"Quantified transition formula:\n", Psi});
            HashMap<String, Rational> map = this.getParameterValuesFromRedlog(Psi, params);
            if (map == null) {
                Phi = null;
                continue;
            }
            t.setEliminationFormula(Phi);
        }
        if (Phi == null) {
            this.logger.log(Level.FINEST, new Object[]{"No combination of UIFAxioms worked for transition."});
            this.logger.log(Level.ALL, new Object[]{"Formula:\n", t.getEliminationFormula()});
        }
    }

    private HashMap<String, Rational> getParameterValuesFromRedlog(String phi, Set<String> params) {
        HashMap<String, Rational> map = null;
        try {
            EliminationAnswer EA = this.RLI.rlqea(phi);
            if (EA != null) {
                if (!EA.getTruthValue()) {
                    this.logger.log(Level.ALL, new Object[]{"Redlog says formula is unsatisfiable."});
                } else {
                    EliminationHandler EH = new EliminationHandler(EA);
                    map = EH.getParameterValues(params);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, new Object[]{"Failed to read a result from Redlog.", e});
        }
        return map;
    }

    private void fillInZeros(Map<String, Rational> map, Set<String> params) {
        Set<String> dom = map.keySet();
        Rational r = Rational.makeZero();
        for (String p : params) {
            if (dom.contains(p)) continue;
            map.put(p, r);
        }
    }

    private String writeNonzeroParameterClause(TemplateNetwork tnet) {
        String zeta = "";
        Vector<TemplateBoolean> clauses = tnet.getAllNonzeroParameterClauses();
        TemplateConjunction conj = new TemplateConjunction(clauses);
        zeta = conj.toString(VariableWriteMode.REDLOG);
        return zeta;
    }

    private String writeNonzeroParameterClause(Transition t) {
        String zeta = "";
        Vector<TemplateBoolean> clauses = t.getAllNonzeroParameterClauses();
        TemplateConjunction conj = new TemplateConjunction(clauses);
        zeta = conj.toString(VariableWriteMode.REDLOG);
        return zeta;
    }

    private List<String> getParameters(Vector<UIFAxiom> U, VariableWriteMode vwm) {
        TemplateFormula[] F = new TemplateFormula[]{};
        return this.getParameters(F, U, vwm);
    }

    private List<String> getParameters(TemplateFormula[] F, Vector<UIFAxiom> U, VariableWriteMode vwm) {
        Vector<String> params = new Vector<String>();
        for (TemplateFormula f : F) {
            params.addAll(f.getAllParameters(vwm));
        }
        for (UIFAxiom A : U) {
            params.addAll(A.getAllParameters(vwm));
        }
        return params;
    }

    private TemplateVariableManager getVariableManager(TemplateFormula P, TemplateFormula R, TemplateFormula Q, Vector<UIFAxiom> U) {
        TemplateVariableManager V = P.getVariableManager();
        V.merge(Q.getVariableManager());
        V.merge(R.getVariableManager());
        for (UIFAxiom A : U) {
            V.merge(A.getVariableManager());
        }
        return V;
    }

    @Deprecated
    public String consecQE(TemplateFormula P, TemplateFormula R, TemplateFormula Q, Vector<UIFAxiom> U) {
        TemplateVariableManager vmgr = this.getVariableManager(P, R, Q, U);
        return this.consecQE(P, R, Q, U, vmgr);
    }

    @Deprecated
    public String consecQE(TemplateFormula P, TemplateFormula R, TemplateFormula Q, VariableManager vmgr) {
        Vector<UIFAxiom> U = new Vector<UIFAxiom>();
        return this.consecQE(P, R, Q, U, vmgr);
    }

    public AssumptionSet consecRREF(TemplateDisjunction ant, TemplateFormula t2, VariableManager vmgr, TemplateNetwork tnet) {
        Vector<UIFAxiom> U = new Vector<UIFAxiom>();
        return this.consecRREF(ant, t2, U, vmgr, tnet);
    }

    public String consecQE(TemplateDisjunction ant, TemplateFormula t2, VariableManager vmgr) {
        Vector<UIFAxiom> U = new Vector<UIFAxiom>();
        return this.consecQE(ant, t2, U, vmgr);
    }

    @Deprecated
    public String consecQE(TemplateFormula Pt, TemplateFormula Rt, TemplateFormula Qt, Vector<UIFAxiom> U, VariableManager vmgr) {
        String Phi;
        LinearInequality concl;
        LinearInequality P = TemplateLinearizer.linearize(Pt, vmgr);
        LinearInequality R = TemplateLinearizer.linearize(Rt, vmgr);
        LinearInequality Q = TemplateLinearizer.linearize(Qt, vmgr);
        String Psi = "";
        LinearInequality prem = P.combine(R);
        for (int i = 0; i < U.size(); ++i) {
            UIFAxiom A = U.get(i);
            concl = TemplateLinearizer.linearize(A.getAntecedent(), vmgr);
            Phi = Farkas.makeRedlogFormula(prem, concl);
            Psi = Psi + " and " + Phi;
            prem.append(TemplateLinearizer.linearize(A.getConsequent(), vmgr));
        }
        concl = Q;
        this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:\n", prem, "\nConclusions:\n", concl});
        Phi = Farkas.makeRedlogFormula(prem, concl);
        Psi = Psi + " and " + Phi;
        assert (Psi.length() >= 5);
        Psi = Psi.substring(5);
        this.logger.log(Level.ALL, new Object[]{"Consecution formula for Redlog:\n", Psi});
        return Psi;
    }

    public String consecQE(TemplateDisjunction ant, TemplateFormula t2, Vector<UIFAxiom> U, VariableManager vmgr) {
        Vector<LinearInequality> linearAntParts = new Vector<LinearInequality>(ant.getNumDisjuncts());
        Vector<TemplateBoolean> disjuncts = ant.getDisjuncts();
        for (TemplateBoolean d : disjuncts) {
            LinearInequality li = TemplateLinearizer.linearize(d, vmgr);
            linearAntParts.add(li);
        }
        LinearInequality Q = TemplateLinearizer.linearize(t2, vmgr);
        String Psi = "";
        for (LinearInequality prem : linearAntParts) {
            String Phi;
            LinearInequality concl;
            for (int i = 0; i < U.size(); ++i) {
                UIFAxiom A = U.get(i);
                concl = TemplateLinearizer.linearize(A.getAntecedent(), vmgr);
                this.logger.log(Level.ALL, new Object[]{"UIFAxiom:\n", A});
                this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:\n", prem, "\nConclusions:\n", concl});
                Phi = Farkas.makeRedlogFormulaUsingPremiseStrength(prem, concl);
                Psi = Psi + " and " + Phi;
                prem.append(TemplateLinearizer.linearize(A.getConsequent(), vmgr));
            }
            concl = Q;
            this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:\n", prem, "\nConclusions:\n", concl});
            Phi = Farkas.makeRedlogFormulaUsingPremiseStrength(prem, concl);
            Psi = Psi + " and " + Phi;
        }
        assert (Psi.length() >= 5);
        Psi = Psi.substring(5);
        this.logger.log(Level.ALL, new Object[]{"Consecution formula for Redlog:\n", Psi});
        return Psi;
    }

    public AssumptionSet consecRREF(TemplateDisjunction ant, TemplateFormula t2, Vector<UIFAxiom> U, VariableManager vmgr, TemplateNetwork tnet) {
        AssumptionSet aset = new AssumptionSet();
        Vector<MatrixI> matrixAntParts = new Vector<MatrixI>(ant.getNumDisjuncts());
        Vector<TemplateBoolean> disjuncts = ant.getDisjuncts();
        for (TemplateBoolean d : disjuncts) {
            boolean prependTrue = true;
            MatrixI m = this.formMat.buildMatrix(d, vmgr, this.paramVars, prependTrue);
            matrixAntParts.add(m);
        }
        boolean prependTrue = false;
        MatrixI Q = this.formMat.buildMatrix(t2, vmgr, this.paramVars, prependTrue);
        for (MatrixI prem : matrixAntParts) {
            MatrixI concl;
            for (int i = 0; i < U.size(); ++i) {
                prependTrue = false;
                UIFAxiom A = U.get(i);
                concl = this.formMat.buildMatrix(A.getAntecedent(), vmgr, this.paramVars, prependTrue);
                this.logger.log(Level.ALL, new Object[]{"UIFAxiom:\n", A});
                this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:", "\n" + prem.toString(), "\nConclusions:", "\n" + concl.toString()});
                aset.addAll(this.applyRREFheuristic(prem, concl, tnet));
                prem = prem.concat(this.formMat.buildMatrix(A.getConsequent(), vmgr, this.paramVars, prependTrue));
            }
            concl = Q;
            this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:", "\n" + prem.toString(), "\nConclusions:", "\n" + concl.toString()});
            aset.addAll(this.applyRREFheuristic(prem, concl, tnet));
        }
        return aset;
    }

    private AssumptionSet applyRREFheuristic(MatrixI prem, MatrixI concl, TemplateNetwork tnet) {
        Set<AssumptionSet> asetset;
        MatrixI aug = prem.augment(concl);
        Matrix au = null;
        try {
            au = (Matrix)aug;
        }
        catch (ClassCastException e) {
            return this.applyRREFheuristicOLD(prem, concl);
        }
        this.logger.log(Level.ALL, new Object[]{"Augmented Matrix:", "\n" + au.toString()});
        MatrixSolver ms = new MatrixSolver(au, this.logger);
        Timer msTimer = new Timer();
        msTimer.start();
        try {
            asetset = ms.solve(tnet.getAssumptions());
            msTimer.stop();
            this.logger.log(Level.ALL, new Object[]{"MatrixSolver took", msTimer.getSumTime(), "milliseconds."});
        }
        catch (MatrixSolvingFailedException e) {
            msTimer.stop();
            this.logger.log(Level.ALL, new Object[]{e.getReason()});
            this.logger.log(Level.ALL, new Object[]{"MatrixSolver took", msTimer.getSumTime(), "milliseconds."});
            return new AssumptionSet();
        }
        if (asetset.size() == 0) {
            return new AssumptionSet();
        }
        return asetset.iterator().next();
    }

    private AssumptionSet applyRREFheuristicOLD(MatrixI prem, MatrixI concl) {
        MatrixI aug = prem.augment(concl);
        this.logger.log(Level.ALL, new Object[]{"Augmented Matrix:", "\n" + aug.toString()});
        AssumptionSet aset = aug.putInRREF(this.logger);
        MatrixI E = aug.getElemMatProd();
        this.logger.log(Level.ALL, new Object[]{"RREF:", "\n" + aug.toString()});
        this.logger.log(Level.ALL, new Object[]{"Matrix representing row operations performed:", "\n" + E.toString()});
        aset.addAll(aug.getAlmostZeroRowAssumptions());
        return aset;
    }

    public static enum UIFAxiomStrategy {
        USEAXIOMS("use axioms"),
        DONOTUSEAXIOMS("do not use axioms");

        private String strat = "";

        private UIFAxiomStrategy(String s) {
            this.strat = s;
        }

        public String toString() {
            return this.strat;
        }
    }
}

