/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.balancer.FormulaMatriciser;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.balancer.interfaces.MatrixI;
import org.sosy_lab.cpachecker.util.invariants.interfaces.Constraint;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class BasicFormulaMatriciser
extends FormulaMatriciser {
    @Override
    public Matrix buildMatrix(TemplateFormula t, VariableManager vmgr, Map<String, Variable> paramVars, boolean prependTrue) {
        if (t.isTrue()) {
            return BasicFormulaMatriciser.booleanMatrix(vmgr, true);
        }
        if (t.isFalse()) {
            return BasicFormulaMatriciser.booleanMatrix(vmgr, false);
        }
        Vector<TemplateConstraint> constraints = t.getConstraints();
        if (constraints.size() < 1) {
            System.err.println("Tried to build matrix on no constraints.");
            return null;
        }
        Vector<Matrix> cols = new Vector<Matrix>();
        if (prependTrue) {
            cols.add(BasicFormulaMatriciser.booleanMatrix(vmgr, true));
        }
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint cons = (Constraint)constraints.get(i);
            InfixReln reln = cons.getInfixReln();
            List<Coeff> coeffs = cons.getNormalFormCoeffs(vmgr, VariableWriteMode.REDLOG);
            Coeff rhs = reln == InfixReln.LT ? cons.getNormalFormConstantMinusOne(VariableWriteMode.REDLOG) : cons.getNormalFormConstant(VariableWriteMode.REDLOG);
            coeffs.add(rhs.negative());
            List<RationalFunction> rfs = BasicFormulaMatriciser.makeRationalFunctions(coeffs, paramVars);
            cols.add(new Matrix(rfs));
            if (reln != InfixReln.EQUAL) continue;
            coeffs = BasicFormulaMatriciser.negative(coeffs);
            rfs = BasicFormulaMatriciser.makeRationalFunctions(coeffs, paramVars);
            cols.add(new Matrix(rfs));
        }
        Matrix a = (Matrix)cols.get(0);
        for (int i = 1; i < cols.size(); ++i) {
            a = a.concat((MatrixI)cols.get(i));
        }
        return a;
    }

    private static Matrix booleanMatrix(VariableManager vmgr, boolean trueStatement) {
        int n = vmgr.getNumVars();
        Vector<RationalFunction> rfs = new Vector<RationalFunction>(Collections.nCopies(n, new RationalFunction(0)));
        RationalFunction constant = trueStatement ? new RationalFunction(-1) : new RationalFunction(1);
        rfs.add(constant);
        return new Matrix(rfs);
    }
}

