/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.balancer.FormulaMatriciser;
import org.sosy_lab.cpachecker.util.invariants.balancer.IRMatrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.interfaces.Constraint;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class IRFormulaMatriciser
extends FormulaMatriciser {
    @Override
    public IRMatrix buildMatrix(TemplateFormula t, VariableManager vmgr, Map<String, Variable> paramVars, boolean prependTrue) {
        if (t.isTrue()) {
            return IRFormulaMatriciser.booleanIRMatrix(vmgr, true);
        }
        if (t.isFalse()) {
            return IRFormulaMatriciser.booleanIRMatrix(vmgr, false);
        }
        Vector<TemplateConstraint> constraints = t.getConstraints();
        if (constraints.size() < 1) {
            System.err.println("Tried to build matrix on no constraints.");
            return null;
        }
        Vector<IRMatrix> cols = new Vector<IRMatrix>();
        if (prependTrue) {
            cols.add(IRFormulaMatriciser.booleanIRMatrix(vmgr, true));
        }
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint cons = (Constraint)constraints.get(i);
            List<Coeff> coeffs = cons.getNormalFormCoeffs(vmgr, VariableWriteMode.REDLOG);
            Coeff rhs = cons.getNormalFormConstant(VariableWriteMode.REDLOG);
            List<RationalFunction> rfs = IRFormulaMatriciser.makeRationalFunctions(coeffs, paramVars);
            rfs.add(rhs.makeRationalFunction(paramVars));
            InfixReln reln = cons.getInfixReln();
            if (reln != InfixReln.EQUAL) {
                cols.add(new IRMatrix(rfs, reln));
                continue;
            }
            cols.add(new IRMatrix(rfs, InfixReln.LEQ));
            coeffs = IRFormulaMatriciser.negative(coeffs);
            rhs = rhs.negative();
            rfs = IRFormulaMatriciser.makeRationalFunctions(coeffs, paramVars);
            rfs.add(rhs.makeRationalFunction(paramVars));
            cols.add(new IRMatrix(rfs, InfixReln.LEQ));
        }
        IRMatrix a = (IRMatrix)cols.get(0);
        for (int i = 1; i < cols.size(); ++i) {
            a = IRMatrix.concat(a, (IRMatrix)cols.get(i));
        }
        return a;
    }

    private static IRMatrix booleanIRMatrix(VariableManager vmgr, boolean trueStatement) {
        int n = vmgr.getNumVars();
        List<RationalFunction> rfs = Collections.nCopies(n + 1, new RationalFunction(0));
        InfixReln reln = trueStatement ? InfixReln.LEQ : InfixReln.LT;
        return new IRMatrix(rfs, reln);
    }
}

