/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.List;
import java.util.Vector;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.interfaces.MatrixI;

public class IRMatrix
implements MatrixI {
    private final int rowNum;
    private final int colNum;
    private RationalFunction[][] entry;
    private final boolean hasInequalityRow = true;
    private InfixReln[] colIneq;
    private int numAugCols = 0;
    private InfixReln[] augIneq = new InfixReln[0];

    public IRMatrix(int m, int n) {
        this.rowNum = m;
        this.colNum = n;
        this.entry = new RationalFunction[m][n];
        this.zeroFill();
        this.colIneq = new InfixReln[n];
        this.leqFill();
    }

    public IRMatrix(List<RationalFunction> rfs, InfixReln reln) {
        int m = rfs.size();
        int n = 1;
        this.rowNum = m;
        this.colNum = n;
        this.entry = new RationalFunction[m][n];
        for (int i = 0; i < m; ++i) {
            this.entry[i][0] = rfs.get(i);
        }
        this.colIneq = new InfixReln[1];
        this.colIneq[0] = reln;
    }

    @Override
    public IRMatrix getElemMatProd() {
        return null;
    }

    public static IRMatrix concat(IRMatrix a, IRMatrix b) {
        int j;
        int m = a.rowNum;
        if (m != b.rowNum) {
            System.err.println("Tried to concatenate matrices with different numbers of rows.");
            return null;
        }
        int an = a.colNum;
        int bn = b.colNum;
        IRMatrix c = new IRMatrix(m, an + bn);
        for (int i = 0; i < m; ++i) {
            int j2;
            for (j2 = 0; j2 < an; ++j2) {
                c.entry[i][j2] = a.entry[i][j2];
            }
            for (j2 = 0; j2 < bn; ++j2) {
                c.entry[i][an + j2] = b.entry[i][j2];
            }
        }
        for (j = 0; j < an; ++j) {
            c.colIneq[j] = a.colIneq[j];
        }
        for (j = 0; j < bn; ++j) {
            c.colIneq[an + j] = b.colIneq[j];
        }
        return c;
    }

    @Override
    public IRMatrix concat(MatrixI b) {
        IRMatrix m = (IRMatrix)b;
        return IRMatrix.concat(this, m);
    }

    public static IRMatrix augment(IRMatrix a, IRMatrix b) {
        int bn;
        IRMatrix c = IRMatrix.concat(a, b);
        c.numAugCols = bn = b.colNum;
        c.augIneq = new InfixReln[bn];
        for (int j = 0; j < bn; ++j) {
            c.augIneq[j] = b.colIneq[j];
        }
        return c;
    }

    @Override
    public IRMatrix augment(MatrixI b) {
        IRMatrix m = (IRMatrix)b;
        return IRMatrix.augment(this, m);
    }

    @Override
    public void zeroFill() {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.colNum; ++j) {
                this.entry[i][j] = RationalFunction.makeZero();
            }
        }
    }

    public void leqFill() {
        for (int j = 0; j < this.colNum; ++j) {
            this.colIneq[j] = InfixReln.LEQ;
        }
    }

    public void setIneqRowIneq(int j, InfixReln reln) {
        this.augIneq[j] = reln;
    }

    @Override
    public RationalFunction get(int i, int j) {
        return this.entry[i][j];
    }

    @Override
    public void set(int i, int j, RationalFunction f) {
        this.entry[i][j] = f;
    }

    @Override
    public void swapRows(int i1, int i2) {
        for (int j = 0; j < this.colNum; ++j) {
            RationalFunction temp = this.entry[i1][j];
            this.entry[i1][j] = this.entry[i2][j];
            this.entry[i2][j] = temp;
        }
    }

    @Override
    public void multRow(int i, RationalFunction f) {
        for (int j = 0; j < this.colNum; ++j) {
            this.entry[i][j] = RationalFunction.multiply(this.entry[i][j], f);
        }
    }

    @Override
    public void addMultiple(int i1, int i2, RationalFunction f) {
        for (int j = 0; j < this.colNum; ++j) {
            RationalFunction sum;
            RationalFunction product = RationalFunction.multiply(f, this.entry[i2][j]);
            this.entry[i1][j] = sum = RationalFunction.add(this.entry[i1][j], product);
        }
    }

    private int[] makeIntArray(List<Integer> ilist) {
        int[] a = new int[ilist.size()];
        int k = 0;
        for (Integer i : ilist) {
            a[k] = i;
            ++k;
        }
        return a;
    }

    private boolean isAlmostZeroRow(int i) {
        boolean ans = true;
        for (int j = 0; j < this.colNum - this.numAugCols; ++j) {
            if (this.entry[i][j].isZero()) continue;
            ans = false;
            break;
        }
        return ans;
    }

    @Override
    public AssumptionSet getAlmostZeroRowAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        for (int i = 0; i < this.rowNum; ++i) {
            if (!this.isAlmostZeroRow(i)) continue;
            for (int j = 0; j < this.numAugCols; ++j) {
                RationalFunction f = this.entry[i][this.colNum - this.numAugCols + j];
                if (f.isZero()) continue;
                Assumption.AssumptionType atype = i == this.rowNum - 1 ? (this.augIneq[j] == InfixReln.LEQ ? Assumption.AssumptionType.NONNEGATIVE : Assumption.AssumptionType.POSITIVE) : Assumption.AssumptionType.ZERO;
                Assumption a = new Assumption(f, atype);
                aset.add(a);
            }
        }
        return aset;
    }

    @Override
    public AssumptionSet getDenomNonZeroAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        block0: for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.colNum; ++j) {
                Polynomial denom = this.entry[i][j].getDenominator();
                if (denom.isConstant()) {
                    if (!denom.isZero()) continue;
                    aset = new AssumptionSet();
                    aset.add(new Assumption(RationalFunction.makeZero(), Assumption.AssumptionType.NONZERO));
                    break block0;
                }
                aset.add(new Assumption(denom, Assumption.AssumptionType.NONZERO));
            }
        }
        return aset;
    }

    @Override
    public AssumptionSet putInRREF() {
        int[] pivot;
        int m = this.rowNum;
        int n = this.colNum;
        int i0 = 0;
        int j0 = 0;
        AssumptionSet assume = new AssumptionSet();
        int M = m;
        int N = n;
        --M;
        N -= this.numAugCols;
        while ((pivot = this.getNextPivot(i0, M, j0, N))[0] != -1) {
            int i1 = pivot[0];
            int j1 = pivot[1];
            if (i1 > i0) {
                this.swapRows(i1, i0);
                i1 = i0;
            }
            RationalFunction f = this.entry[i1][j1];
            RationalFunction fRecip = RationalFunction.makeReciprocal(f);
            this.multRow(i1, fRecip);
            if (!f.isConstant()) {
                Polynomial num = f.getNumerator();
                RationalFunction numOverUnity = new RationalFunction(num, new Polynomial(1));
                assume.add(new Assumption(numOverUnity, Assumption.AssumptionType.NONZERO));
            }
            for (int i = 0; i < m; ++i) {
                if (i == i1 || this.entry[i][j1].isZero()) continue;
                RationalFunction g = this.entry[i][j1];
                RationalFunction gneg = RationalFunction.makeNegative(g);
                this.addMultiple(i, i1, gneg);
            }
            i0 = i1 + 1;
            j0 = j1 + 1;
        }
        return assume;
    }

    @Override
    public AssumptionSet putInRREF(LogManager logger) {
        return null;
    }

    private int[] getNextPivot(int i0, int m, int j0, int n) {
        int[] pivot = new int[]{-1, -1};
        for (int j = j0; j < n; ++j) {
            int[] nonzero = this.findNonzeroEntriesInColumn(j, i0, m);
            if (nonzero.length <= 0) continue;
            pivot[0] = nonzero[0];
            pivot[1] = j;
            break;
        }
        return pivot;
    }

    private int[] findNonzeroEntriesInColumn(int j, int i0, int m) {
        Vector<Integer> rows = new Vector<Integer>();
        for (int i = i0; i < m; ++i) {
            if (this.entry[i][j].isZero()) continue;
            rows.add(new Integer(i));
        }
        return this.makeIntArray(rows);
    }

    public String toString() {
        String s = "";
        String left = "[ ";
        String right = " ]\n";
        String gap = "  ";
        for (int i = 0; i < this.rowNum; ++i) {
            int j;
            if (i == this.rowNum - 1) {
                s = s + left;
                for (j = 0; j < this.colNum; ++j) {
                    if (j > 0) {
                        s = s + gap;
                    }
                    if (j == this.colNum - this.numAugCols) {
                        s = s + "|" + gap;
                    }
                    s = s + "<";
                }
                s = s + right;
                s = s + left;
                for (j = 0; j < this.colNum; ++j) {
                    if (j > 0) {
                        s = s + gap;
                    }
                    if (j == this.colNum - this.numAugCols) {
                        s = s + "|" + gap;
                    }
                    s = this.colIneq[j].toString().equals("<=") ? s + "=" : s + " ";
                }
                s = s + right;
            }
            s = s + left;
            for (j = 0; j < this.colNum; ++j) {
                if (j > 0) {
                    s = s + gap;
                }
                if (j == this.colNum - this.numAugCols) {
                    s = s + "|" + gap;
                }
                s = s + this.entry[i][j].toString();
            }
            s = s + right;
        }
        return s;
    }
}

