/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.BadAssumptionsException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.Substitution;
import org.sosy_lab.cpachecker.util.invariants.balancer.interfaces.MatrixI;

public class Matrix
implements MatrixI {
    private int rowNum;
    private int colNum;
    private RationalFunction[][] entry;
    private int numAugCols = 0;
    private List<Integer> pivotRows = null;
    private Matrix elemMatProd = null;
    private int nextI0 = 0;
    private int nextJ0 = 0;
    private boolean haltOnVariableNumPivot = false;
    private boolean outOfPivots = false;
    private boolean verbose = false;
    private boolean useFreePivoting = true;

    public Matrix() {
    }

    public Matrix(int m, int n) {
        this.rowNum = m;
        this.colNum = n;
        this.entry = new RationalFunction[m][n];
        this.zeroFill();
    }

    public Matrix(List<RationalFunction> rfs) {
        int m = rfs.size();
        int n = 1;
        this.rowNum = m;
        this.colNum = n;
        this.entry = new RationalFunction[m][n];
        for (int i = 0; i < m; ++i) {
            this.entry[i][0] = rfs.get(i);
        }
    }

    public Matrix(RationalFunction[][] a) {
        int m = a.length;
        if (m == 0) {
            return;
        }
        int n = a[0].length;
        this.rowNum = m;
        this.colNum = n;
        this.entry = a;
    }

    public void setAugStart(int a) {
        this.numAugCols = this.colNum - a;
    }

    public Matrix copy() {
        RationalFunction[][] a = new RationalFunction[this.rowNum][this.colNum];
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.colNum; ++j) {
                a[i][j] = this.entry[i][j].copy();
            }
        }
        Matrix m = new Matrix(a);
        m.numAugCols = this.numAugCols;
        m.haltOnVariableNumPivot = this.haltOnVariableNumPivot;
        m.nextI0 = this.nextI0;
        m.nextJ0 = this.nextJ0;
        m.useFreePivoting = this.useFreePivoting;
        m.outOfPivots = this.outOfPivots;
        m.verbose = this.verbose;
        m.pivotRows = new Vector<Integer>(this.pivotRows.size());
        for (Integer i : this.pivotRows) {
            m.pivotRows.add(new Integer(i));
        }
        return m;
    }

    public RationalFunction[][] getEntries() {
        return this.entry;
    }

    public int getNumPivotRows() {
        return this.pivotRows.size();
    }

    public void setHaltOnVarNumPivot(boolean b) {
        this.haltOnVariableNumPivot = b;
    }

    public boolean isOutOfPivots() {
        return this.outOfPivots;
    }

    public static Matrix makeIdentity(int n) {
        Matrix id = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            id.entry[i][i] = RationalFunction.makeUnity();
        }
        return id;
    }

    public void setVerbosity(boolean b) {
        this.verbose = b;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public int getNumAugCols() {
        return this.numAugCols;
    }

    public boolean isPivotRow(int i) {
        return this.pivotRows != null && this.pivotRows.contains(i);
    }

    public RationalFunction getEntry(int i, int j) {
        return this.entry[i][j];
    }

    public void setEntry(int i, int j, RationalFunction f) {
        this.entry[i][j] = f;
    }

    @Override
    public Matrix getElemMatProd() {
        return this.elemMatProd;
    }

    public static Matrix concat(Matrix a, Matrix b) {
        int m = a.rowNum;
        if (m != b.rowNum) {
            System.err.println("Tried to concatenate matrices with different numbers of rows.");
            return null;
        }
        int an = a.colNum;
        int bn = b.colNum;
        Matrix c = new Matrix(m, an + bn);
        for (int i = 0; i < m; ++i) {
            int j;
            for (j = 0; j < an; ++j) {
                c.entry[i][j] = a.entry[i][j];
            }
            for (j = 0; j < bn; ++j) {
                c.entry[i][an + j] = b.entry[i][j];
            }
        }
        return c;
    }

    @Override
    public Matrix concat(MatrixI b) {
        Matrix m = (Matrix)b;
        return Matrix.concat(this, m);
    }

    public static Matrix augment(Matrix a, Matrix b) {
        int bn;
        Matrix c = Matrix.concat(a, b);
        c.numAugCols = bn = b.colNum;
        return c;
    }

    @Override
    public Matrix augment(MatrixI b) {
        Matrix m = (Matrix)b;
        return Matrix.augment(this, m);
    }

    @Override
    public void zeroFill() {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.colNum; ++j) {
                this.entry[i][j] = RationalFunction.makeZero();
            }
        }
    }

    @Override
    public RationalFunction get(int i, int j) {
        return this.entry[i][j];
    }

    @Override
    public void set(int i, int j, RationalFunction f) {
        this.entry[i][j] = f;
    }

    @Override
    public void swapRows(int i1, int i2) {
        for (int j = 0; j < this.colNum; ++j) {
            RationalFunction temp = this.entry[i1][j];
            this.entry[i1][j] = this.entry[i2][j];
            this.entry[i2][j] = temp;
        }
    }

    public void swapCols(int j1, int j2) {
        for (int i = 0; i < this.rowNum; ++i) {
            RationalFunction temp = this.entry[i][j1];
            this.entry[i][j1] = this.entry[i][j2];
            this.entry[i][j2] = temp;
        }
    }

    @Override
    public void multRow(int i, RationalFunction f) {
        for (int j = 0; j < this.colNum; ++j) {
            this.entry[i][j] = RationalFunction.multiply(this.entry[i][j], f);
        }
    }

    @Override
    public void addMultiple(int i1, int i2, RationalFunction f) {
        for (int j = 0; j < this.colNum; ++j) {
            RationalFunction sum;
            RationalFunction product = RationalFunction.multiply(f, this.entry[i2][j]);
            this.entry[i1][j] = sum = RationalFunction.add(this.entry[i1][j], product);
        }
    }

    private int[] makeIntArray(List<Integer> ilist) {
        int[] a = new int[ilist.size()];
        int k = 0;
        for (Integer i : ilist) {
            a[k] = i;
            ++k;
        }
        return a;
    }

    private boolean isAlmostZeroRow(int i) {
        boolean ans = true;
        for (int j = 0; j < this.colNum - this.numAugCols; ++j) {
            if (this.entry[i][j].isZero()) continue;
            ans = false;
            break;
        }
        return ans;
    }

    @Override
    public AssumptionSet getAlmostZeroRowAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        for (int i = 0; i < this.rowNum; ++i) {
            if (!this.isAlmostZeroRow(i)) continue;
            for (int j = 0; j < this.numAugCols; ++j) {
                RationalFunction f = this.entry[i][this.colNum - this.numAugCols + j];
                if (f.isZero()) continue;
                aset.add(new Assumption(f, Assumption.AssumptionType.ZERO));
            }
        }
        return aset;
    }

    @Override
    public AssumptionSet getDenomNonZeroAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        block0: for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.colNum; ++j) {
                Polynomial denom = this.entry[i][j].getDenominator();
                if (denom.isConstant()) {
                    if (!denom.isZero()) continue;
                    aset = new AssumptionSet();
                    aset.add(new Assumption(RationalFunction.makeZero(), Assumption.AssumptionType.NONZERO));
                    break block0;
                }
                aset.add(new Assumption(denom, Assumption.AssumptionType.NONZERO));
            }
        }
        return aset;
    }

    @Override
    public AssumptionSet putInRREF() {
        LogManager lm = null;
        return this.putInRREF(lm);
    }

    @Override
    public AssumptionSet putInRREF(LogManager logger) {
        int m = this.rowNum;
        int n = this.colNum;
        int i0 = this.nextI0;
        int j0 = this.nextJ0;
        this.pivotRows = new Vector<Integer>();
        AssumptionSet aset = new AssumptionSet();
        int M = m;
        int N = n;
        N -= this.numAugCols;
        Matrix E = Matrix.makeIdentity(M);
        while (true) {
            int[] pivot;
            if ((pivot = this.useFreePivoting ? this.getNextPivotFree(i0, M, j0, N) : this.getNextPivot(i0, M, j0, N))[0] == -1) break;
            int i1 = pivot[0];
            int j1 = pivot[1];
            if (this.haltOnVariableNumPivot && !this.entry[i1][j1].getNumerator().isConstant()) {
                this.nextI0 = i0;
                this.nextJ0 = j0;
                return aset;
            }
            if (i1 > i0) {
                this.swapRows(i1, i0);
                E.swapRows(i1, i0);
                if (this.verbose && logger != null) {
                    logger.log(Level.ALL, new Object[]{"Swapped rows", i1, "and", i0});
                    logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                    logger.log(Level.ALL, new Object[]{"E:", "\n" + E.toString()});
                }
                i1 = i0;
            }
            if (j1 > j0) {
                this.swapCols(j1, j0);
                if (this.verbose && logger != null) {
                    logger.log(Level.ALL, new Object[]{"Swapped columns", j1, "and", j0});
                    logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                }
                j1 = j0;
            }
            this.pivotRows.add(i1);
            RationalFunction f = this.entry[i1][j1];
            if (!f.isUnity()) {
                RationalFunction fRecip = RationalFunction.makeReciprocal(f);
                this.multRow(i1, fRecip);
                E.multRow(i1, fRecip);
                if (this.verbose && logger != null) {
                    logger.log(Level.ALL, new Object[]{"Multiplied row", i1, "by", fRecip});
                    logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                    logger.log(Level.ALL, new Object[]{"E:", "\n" + E.toString()});
                }
            }
            if (!f.getNumerator().isConstant()) {
                Assumption a = new Assumption(f.getNumerator(), Assumption.AssumptionType.NONZERO);
                aset.add(a);
            }
            for (int i = 0; i < m; ++i) {
                if (i == i1 || this.entry[i][j1].isZero()) continue;
                RationalFunction g = this.entry[i][j1];
                RationalFunction gneg = RationalFunction.makeNegative(g);
                this.addMultiple(i, i1, gneg);
                E.addMultiple(i, i1, gneg);
                if (!this.verbose || logger == null) continue;
                logger.log(Level.ALL, new Object[]{"Added", gneg, "times row", i1, "to row", i});
                logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                logger.log(Level.ALL, new Object[]{"E:", "\n" + E.toString()});
            }
            i0 = i1 + 1;
            j0 = j1 + 1;
        }
        this.outOfPivots = true;
        this.nextI0 = i0;
        this.nextJ0 = j0;
        this.elemMatProd = E;
        return aset;
    }

    public void putInRREF(AssumptionManager amgr, LogManager logger) throws BadAssumptionsException {
        logger.log(Level.ALL, new Object[]{"Setting matrix to verbose mode, for completion of RREF."});
        this.verbose = true;
        int m = this.rowNum;
        int n = this.colNum;
        int i0 = this.nextI0;
        int j0 = this.nextJ0;
        if (i0 == 0 && j0 == 0) {
            this.pivotRows = new Vector<Integer>();
        }
        int M = m;
        int N = n;
        N -= this.numAugCols;
        Matrix E = Matrix.makeIdentity(M);
        while (true) {
            RationalFunction f;
            int[] pivot;
            if ((pivot = this.getNextVarNumPivot(i0, M, j0, N, amgr, logger))[0] == -1) {
                this.outOfPivots = true;
                AssumptionSet azr = this.getAlmostZeroRowAssumptions();
                logger.log(Level.ALL, new Object[]{"Found the following assumptions for almost-zero rows:\n", azr});
                if (azr.size() <= 0) break;
                logger.log(Level.ALL, new Object[]{"Adding almost-zero row assumptions."});
                amgr.addNecessaryAssumptions(azr);
                break;
            }
            int i1 = pivot[0];
            int j1 = pivot[1];
            if (this.haltOnVariableNumPivot && !this.entry[i1][j1].getNumerator().isConstant()) {
                this.nextI0 = i0;
                this.nextJ0 = j0;
            }
            if (!(f = this.entry[i1][j1]).getNumerator().isConstant()) {
                Assumption a = new Assumption(f.getNumerator(), Assumption.AssumptionType.NONZERO);
                amgr.addPossiblyUnnecessaryAssumption(a);
            }
            if (i1 > i0) {
                this.swapRows(i1, i0);
                E.swapRows(i1, i0);
                if (this.verbose) {
                    logger.log(Level.ALL, new Object[]{"Swapped rows", i1, "and", i0});
                    logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                }
                i1 = i0;
            }
            this.pivotRows.add(i1);
            if (j1 > j0) {
                this.swapCols(j1, j0);
                if (this.verbose) {
                    logger.log(Level.ALL, new Object[]{"Swapped columns", j1, "and", j0});
                    logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                }
                j1 = j0;
            }
            if (!f.isUnity()) {
                RationalFunction fRecip = RationalFunction.makeReciprocal(f);
                this.multRow(i1, fRecip);
                E.multRow(i1, fRecip);
                if (this.verbose) {
                    logger.log(Level.ALL, new Object[]{"Multiplied row", i1, "by", fRecip});
                    logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
                }
            }
            for (int i = 0; i < m; ++i) {
                if (i == i1 || this.entry[i][j1].isZero()) continue;
                RationalFunction g = this.entry[i][j1];
                RationalFunction gneg = RationalFunction.makeNegative(g);
                this.addMultiple(i, i1, gneg);
                E.addMultiple(i, i1, gneg);
                if (!this.verbose) continue;
                logger.log(Level.ALL, new Object[]{"Added", gneg, "times row", i1, "to row", i});
                logger.log(Level.ALL, new Object[]{"Matrix:", "\n" + this.toString()});
            }
            i0 = i1 + 1;
            j0 = j1 + 1;
            this.nextI0 = i0;
            this.nextJ0 = j0;
        }
        this.elemMatProd = E;
    }

    @Deprecated
    private int[] getNextPivot(int i0, int m, int j0, int n) {
        int[] pivot = new int[]{-1, -1};
        for (int j = j0; j < n; ++j) {
            int[] nonzero = this.findNonzeroEntriesInColumn(j, i0, m);
            if (nonzero.length <= 0) continue;
            pivot[0] = nonzero[0];
            pivot[1] = j;
            break;
        }
        return pivot;
    }

    private int[] getNextPivotFree(int i0, int m, int j0, int n) {
        int[] pivot = new int[]{-1, -1};
        Vector<SortablePivotEntry> spes = new Vector<SortablePivotEntry>();
        for (int j = j0; j < n; ++j) {
            for (int i = i0; i < m; ++i) {
                spes.add(new SortablePivotEntry(i, j, this.entry[i][j]));
            }
        }
        if (spes.size() == 0) {
            return pivot;
        }
        Collections.sort(spes);
        SortablePivotEntry best = (SortablePivotEntry)spes.get(0);
        if (best.getFunction().isZero()) {
            return pivot;
        }
        pivot = best.getRowCol();
        return pivot;
    }

    private int[] getNextVarNumPivot(int i0, int m, int j0, int n, AssumptionManager amgr, LogManager logger) throws BadAssumptionsException {
        PointedAssumption a;
        int[] pivot = new int[]{-1, -1};
        if (i0 >= m || j0 >= n) {
            return pivot;
        }
        logger.log(Level.ALL, new Object[]{"Selecting next variable-numerator pivot,", "for submatrix starting at", i0, ",", j0, "in matrix:", "\n" + this});
        Vector<PointedAssumption> nz = new Vector<PointedAssumption>();
        for (int j = j0; j < n; ++j) {
            for (int i = i0; i < m; ++i) {
                Polynomial p = this.entry[i][j].getNumerator();
                if (p.isZero()) continue;
                if (p.isConstant()) {
                    pivot[0] = i;
                    pivot[1] = j;
                    return pivot;
                }
                assert (!p.isConstant());
                Assumption assumption = new Assumption(p, Assumption.AssumptionType.NONZERO);
                nz.add(new PointedAssumption(i, j, assumption));
            }
        }
        if (nz.size() == 0) {
            logger.log(Level.ALL, new Object[]{"All remaining entries are zero."});
            return pivot;
        }
        logger.log(Level.ALL, new Object[]{"Found potential assumptions:\n", nz});
        Vector<PointedAssumption> implied = new Vector<PointedAssumption>();
        Vector<PointedAssumption> noncontra = new Vector<PointedAssumption>();
        block6: for (PointedAssumption pointedAssumption : nz) {
            Assumption.AssumptionRelation rel = amgr.matchAgainst(pointedAssumption.getAssumption());
            switch (rel) {
                case ISSAMEAS: 
                case WEAKENS: {
                    implied.add(pointedAssumption);
                    continue block6;
                }
                case CONTRADICTS: {
                    continue block6;
                }
            }
            noncontra.add(pointedAssumption);
        }
        logger.log(Level.ALL, new Object[]{"The following are implied by the assumptions we have already made:\n", implied});
        logger.log(Level.ALL, new Object[]{"The following are not implied by those already made, but are at least non-contradictory:\n", noncontra});
        if (implied.size() == 0 && noncontra.size() == 0) {
            logger.log(Level.ALL, new Object[]{"Every potential pivot results in a contradictory assumption!"});
            throw new BadAssumptionsException();
        }
        if (implied.size() > 0) {
            a = (PointedAssumption)implied.get(0);
            logger.log(Level.ALL, new Object[]{"We choose an assumption implied by those already in force:\n", a});
            return a.getPoint();
        }
        a = (PointedAssumption)noncontra.get(0);
        logger.log(Level.ALL, new Object[]{"We choose an assumption not immediately contradictory with those in force:\n", a});
        return a.getPoint();
    }

    private int[] findNonzeroEntriesInColumn(int j, int i0, int m) {
        Vector<Integer> rows = new Vector<Integer>();
        for (int i = i0; i < m; ++i) {
            if (this.entry[i][j].isZero()) continue;
            rows.add(new Integer(i));
        }
        return this.makeIntArray(rows);
    }

    public String toString() {
        String left = "[ ";
        String right = " ]\n";
        String gap = "  ";
        int maxLen = 150;
        int maxrownumchars = Integer.toString(this.rowNum - 1).length();
        maxLen -= maxrownumchars;
        int[] widths = new int[this.colNum];
        for (int j = 0; j < this.colNum; ++j) {
            int w = 0;
            for (int i = 0; i < this.rowNum; ++i) {
                int l = this.entry[i][j].toString().length();
                if (l <= w) continue;
                w = l;
            }
            widths[j] = w;
        }
        String[] pre = new String[this.colNum];
        int c = 0;
        for (int j = 0; j < this.colNum; ++j) {
            int w = widths[j];
            String prefix = "";
            if (c > 0) {
                prefix = prefix + gap;
            }
            if (j == this.colNum - this.numAugCols) {
                prefix = prefix + "|" + gap;
            }
            w += prefix.length();
            if (c == 0) {
                c = w;
                pre[j] = prefix;
                continue;
            }
            if (c + w <= maxLen) {
                c += w;
                pre[j] = prefix;
                continue;
            }
            c = w;
            pre[j] = "\n" + prefix.substring(gap.length());
        }
        char sp = " ".charAt(0);
        char[] sps = new char[maxLen];
        for (int k = 0; k < maxLen; ++k) {
            sps[k] = sp;
        }
        String spaces = new String(sps);
        String s = "";
        for (int i = 0; i < this.rowNum; ++i) {
            String rn = Integer.toString(i);
            s = s + spaces.substring(0, maxrownumchars - rn.length()) + rn + " ";
            s = s + left;
            for (int j = 0; j < this.colNum; ++j) {
                String e = this.entry[i][j].toString();
                if (widths[j] < maxLen) {
                    int W = widths[j] - e.length();
                    s = s + pre[j] + spaces.substring(0, W) + e;
                    continue;
                }
                s = s + pre[j] + e;
            }
            s = s + right;
        }
        return s;
    }

    public void applySubstitution(Substitution subs) {
        for (int i = 0; i < this.rowNum; ++i) {
            for (int j = 0; j < this.colNum; ++j) {
                RationalFunction f = this.entry[i][j];
                this.entry[i][j] = RationalFunction.applySubstitution(subs, f);
            }
        }
    }

    private class SortablePivotEntry
    implements Comparable<SortablePivotEntry> {
        private final int kind;
        private final int height;
        private final int sign;
        private final RationalFunction func;
        private final int i0;
        private final int j0;

        public SortablePivotEntry(int i, int j, RationalFunction f) {
            this.i0 = i;
            this.j0 = j;
            this.func = f;
            if (f.isZero()) {
                this.kind = 10;
                this.height = 0;
                this.sign = 0;
            } else if (!f.isConstant()) {
                if (f.getNumerator().isConstant()) {
                    this.kind = 1;
                    Rational r = f.getNumerator().getConstant();
                    this.height = r.getHeight();
                    this.sign = r.isPositive() ? 1 : 2;
                } else {
                    this.kind = 5;
                    this.height = f.getTermHeight();
                    this.sign = 0;
                }
            } else {
                this.kind = 0;
                Rational r = f.getConstant();
                this.height = r.getHeight();
                this.sign = r.isPositive() ? 1 : 2;
            }
        }

        @Override
        public int compareTo(SortablePivotEntry other) {
            if (this.kind != other.kind) {
                return this.kind - other.kind;
            }
            if (this.height != other.height) {
                return this.height - other.height;
            }
            return this.sign - other.sign;
        }

        public int[] getRowCol() {
            int[] rc = new int[]{this.i0, this.j0};
            return rc;
        }

        public RationalFunction getFunction() {
            return this.func;
        }
    }

    private class PointedAssumption {
        private final int i;
        private final int j;
        private final Assumption a;

        public PointedAssumption(int i, int j, Assumption a) {
            this.i = i;
            this.j = j;
            this.a = a;
        }

        public Assumption getAssumption() {
            return this.a;
        }

        public int[] getPoint() {
            int[] pt = new int[]{this.i, this.j};
            return pt;
        }

        public String toString() {
            return this.a.toString();
        }
    }
}

