/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Timer;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.BadAssumptionsException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Balancer;
import org.sosy_lab.cpachecker.util.invariants.balancer.BasicFormulaMatriciser;
import org.sosy_lab.cpachecker.util.invariants.balancer.FormulaMatriciser;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateMap;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateNetwork;
import org.sosy_lab.cpachecker.util.invariants.balancer.Transition;
import org.sosy_lab.cpachecker.util.invariants.balancer.UIFAxiom;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh3.PivotRowHandler;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.redlog.EliminationAnswer;
import org.sosy_lab.cpachecker.util.invariants.redlog.EliminationHandler;
import org.sosy_lab.cpachecker.util.invariants.redlog.RedlogInterface;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateDisjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class MatrixBalancer
implements Balancer {
    private final LogManager logger;
    private final RedlogInterface RLI;
    private final FormulaMatriciser formMat = new BasicFormulaMatriciser();
    private TemplateNetwork tnet;
    private Map<String, Variable> paramVars = null;
    private List<Matrix> matrices;
    final Timer redlog = new Timer();
    private boolean redlogReturnedTrue = false;

    public MatrixBalancer(LogManager lm) {
        this.logger = lm;
        this.RLI = new RedlogInterface(this.logger);
    }

    public boolean redlogSaidTrue() {
        return this.redlogReturnedTrue;
    }

    @Override
    public boolean balance(TemplateNetwork tn) throws RefinementFailedException {
        this.logger.log(Level.FINEST, new Object[]{"Attempting to balance template network with RREF heuristic."});
        boolean succeed = false;
        this.tnet = tn;
        this.paramVars = this.makeParamVars();
        Vector<Matrix> mats = new Vector<Matrix>();
        for (Transition t : this.tnet.getTransitions()) {
            mats.addAll(this.getMatricesForTransition(t));
        }
        this.matrices = mats;
        this.logger.log(Level.ALL, new Object[]{"Transformed network transitions into matrices."});
        this.logMatrices();
        this.innocuousRREF();
        this.logger.log(Level.ALL, new Object[]{"Put matrices in partial RREF, stopping when all potential pivots had variable numerator."});
        this.logMatrices();
        Map<String, Rational> solution = this.solve();
        if (solution == null) {
            this.logger.log(Level.FINEST, new Object[]{"MatrixBalancer could not find any solution."});
            succeed = false;
        } else {
            this.fillInZeros(solution, this.paramVars.keySet());
            succeed = this.tnet.evaluate(solution);
            if (!succeed) {
                this.logger.log(Level.FINEST, new Object[]{"Redlog appears to have completed, although not all parameters received values. Check for 'infinity' values."});
                this.logger.log(Level.ALL, new Object[]{"Templates after attempted evaluation:\n", this.tnet.dumpTemplates()});
            }
        }
        return succeed;
    }

    private Map<String, Rational> solve() {
        HashMap<String, Rational> values = null;
        AssumptionManager amgr = new AssumptionManager(this.matrices, this.logger);
        boolean tryAgain = true;
        while (tryAgain) {
            try {
                Matrix m = amgr.nextMatrix();
                while (m != null) {
                    this.logger.log(Level.ALL, new Object[]{"Working on matrix:", "\n" + m.toString()});
                    m.putInRREF(amgr, this.logger);
                    PivotRowHandler prh = new PivotRowHandler(m, amgr, this, this.logger);
                    prh.solve();
                    m = amgr.nextMatrix();
                }
                AssumptionSet aset = amgr.getCurrentAssumptionSet();
                values = this.tryAssumptionSet(aset);
                if (values == null) {
                    throw new BadAssumptionsException();
                }
                break;
            }
            catch (BadAssumptionsException e) {
                tryAgain = amgr.nextBranch();
            }
        }
        return values;
    }

    private void innocuousRREF() {
        for (Matrix m : this.matrices) {
            m.setHaltOnVarNumPivot(true);
            m.putInRREF(this.logger);
            m.setHaltOnVarNumPivot(false);
        }
    }

    private void logMatrices() {
        this.logger.log(Level.ALL, new Object[]{"Matrices:"});
        for (Matrix m : this.matrices) {
            this.logger.log(Level.ALL, new Object[]{"\n" + m.toString()});
        }
    }

    private Map<String, Variable> makeParamVars() {
        Set<String> params = this.tnet.writeAllParameters(VariableWriteMode.REDLOG);
        HashMap<String, Variable> paramVars = new HashMap<String, Variable>();
        for (String p : params) {
            Variable v = new Variable(p);
            paramVars.put(p, v);
        }
        return paramVars;
    }

    private void fillInZeros(Map<String, Rational> map, Set<String> params) {
        Set<String> dom = map.keySet();
        Rational r = Rational.makeZero();
        for (String p : params) {
            if (dom.contains(p)) continue;
            map.put(p, r);
        }
    }

    public HashMap<String, Rational> tryAssumptionSet(AssumptionSet aset) {
        this.logger.log(Level.ALL, new Object[]{"Asking Redlog to find values for the parameters, assuming:\n", aset});
        HashMap<String, Rational> map = null;
        if (aset.size() == 0) {
            map = new HashMap<String, Rational>();
        } else {
            String phi = aset.writeQEformula();
            this.logger.log(Level.ALL, new Object[]{"QE formula for all RREF assumptions:\n", phi});
            this.redlog.start();
            map = this.getParameterValuesFromRedlog(phi, this.paramVars.keySet());
            this.redlog.stop();
            this.logger.log(Level.ALL, new Object[]{"Redlog took", this.redlog.getSumTime(), "milliseconds."});
        }
        if (map == null) {
            this.logger.log(Level.FINEST, new Object[]{"Redlog could not find values for all parameters."});
        }
        return map;
    }

    public boolean isSatisfiable(AssumptionSet aset) {
        HashMap<String, Rational> map = this.tryAssumptionSet(aset);
        return map != null || this.redlogReturnedTrue;
    }

    private HashMap<String, Rational> getParameterValuesFromRedlog(String phi, Set<String> params) {
        HashMap<String, Rational> map = null;
        this.redlogReturnedTrue = false;
        try {
            EliminationAnswer EA = this.RLI.rlqea(phi);
            if (EA != null) {
                if (!EA.getTruthValue()) {
                    this.logger.log(Level.ALL, new Object[]{"Redlog says formula is unsatisfiable."});
                } else {
                    if (EA.getTruthValue()) {
                        this.redlogReturnedTrue = true;
                    }
                    EliminationHandler EH = new EliminationHandler(EA);
                    map = EH.getParameterValues(params);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, new Object[]{"Failed to read a result from Redlog.", e});
        }
        return map;
    }

    private List<Matrix> getMatricesForTransition(Transition t) {
        TemplateMap tmap = this.tnet.getTemplateMap();
        TemplateFormula t1 = tmap.getTemplate(t.getStart()).getTemplateFormula();
        TemplateFormula p = t.getConstraint();
        TemplateFormula t2 = tmap.getTemplate(t.getEnd()).getTemplateFormula();
        if (t2 == t1) {
            t2 = t1.copy();
        }
        this.logger.log(Level.ALL, new Object[]{"\nInitial template:\n", t1, "\nPath formula:\n", p, "\nFinal template:\n", t2});
        HashMap<String, Integer> indices = p.getMaxIndices();
        t1.preindex(indices);
        t2.postindex(indices);
        this.logger.log(Level.ALL, new Object[]{"\nPreindexed initial template:\n", t1, "\nPostindexed final template:\n", t2});
        AliasingMap amap = new AliasingMap("v");
        t1.alias(amap);
        p.alias(amap);
        t2.alias(amap);
        this.logger.log(Level.ALL, new Object[]{"\nAliased formulas:\nInitial template:\n", t1, "\nPath formula:\n", p, "\nFinal template:\n", t2});
        Purification pur = new Purification("u");
        t1.purify(pur);
        p.purify(pur);
        t2.purify(pur);
        this.logger.log(Level.ALL, new Object[]{"\nPurified formulas:\nInitial template:\n", t1, "\nPath formula:\n", p, "\nFinal template:\n", t2});
        this.logger.log(Level.ALL, new Object[]{"\nPurification definitions:\n", pur});
        TemplateBoolean antB = TemplateConjunction.conjoin((TemplateBoolean)t1, (TemplateBoolean)p);
        TemplateDisjunction antD = (TemplateDisjunction)antB.makeSDNF();
        this.logger.log(Level.ALL, new Object[]{"\nSDNF of antecedent:\n", antD});
        int n = amap.size();
        int m = pur.size();
        TemplateVariableManager vmgr = new TemplateVariableManager(n, m);
        this.logger.log(Level.ALL, new Object[]{"Variable manager:\n", vmgr});
        List<Matrix> matrices = this.consec(antD, t2, vmgr);
        t1.unpurify();
        t1.unalias();
        t1.unindex();
        t2.unpurify();
        t2.unalias();
        t2.unindex();
        p.unalias();
        p.unpurify();
        return matrices;
    }

    private List<Matrix> consec(TemplateDisjunction ant, TemplateFormula t2, VariableManager vmgr) {
        Vector<UIFAxiom> U = new Vector<UIFAxiom>();
        return this.consec(ant, t2, U, vmgr);
    }

    private List<Matrix> consec(TemplateDisjunction ant, TemplateFormula t2, Vector<UIFAxiom> U, VariableManager vmgr) {
        Vector<Matrix> matrices = new Vector<Matrix>();
        Vector<Matrix> matrixAntParts = new Vector<Matrix>(ant.getNumDisjuncts());
        Vector<TemplateBoolean> disjuncts = ant.getDisjuncts();
        for (TemplateBoolean d : disjuncts) {
            boolean prependTrue = true;
            Matrix m = (Matrix)this.formMat.buildMatrix(d, vmgr, this.paramVars, prependTrue);
            matrixAntParts.add(m);
        }
        boolean prependTrue = false;
        Matrix Q = (Matrix)this.formMat.buildMatrix(t2, vmgr, this.paramVars, prependTrue);
        for (Matrix prem : matrixAntParts) {
            Matrix concl;
            for (int i = 0; i < U.size(); ++i) {
                prependTrue = false;
                UIFAxiom A = U.get(i);
                concl = (Matrix)this.formMat.buildMatrix(A.getAntecedent(), vmgr, this.paramVars, prependTrue);
                this.logger.log(Level.ALL, new Object[]{"UIFAxiom:\n", A});
                this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:", "\n" + prem.toString(), "\nConclusions:", "\n" + concl.toString()});
                matrices.add(Matrix.augment(prem, concl));
                prem = prem.concat(this.formMat.buildMatrix(A.getConsequent(), vmgr, this.paramVars, prependTrue));
            }
            concl = Q;
            this.logger.log(Level.ALL, new Object[]{"Linearized premises and conclusions:\nPremises:", "\n" + prem.toString(), "\nConclusions:", "\n" + concl.toString()});
            matrices.add(Matrix.augment(prem, concl));
        }
        return matrices;
    }
}

