/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixSolvingFailedException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Substitution;
import org.sosy_lab.cpachecker.util.invariants.balancer.SubstitutionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRowHandler;

public class MatrixSolver {
    private LogManager logger;
    private Matrix matrix;

    public MatrixSolver(Matrix mx, LogManager lm) {
        this.logger = lm;
        this.matrix = mx;
    }

    public Set<AssumptionSet> solve() throws MatrixSolvingFailedException {
        return this.solve(new AssumptionSet());
    }

    public Set<AssumptionSet> solve(AssumptionSet init) throws MatrixSolvingFailedException {
        AssumptionSet azrZeros;
        AssumptionSet rrefnonzeros;
        ZeroPolynomialManager zeroPolyMan = new ZeroPolynomialManager();
        AssumptionSet zeros = zeroPolyMan.next();
        Set<AssumptionSet> pivotAssumptionSets = null;
        while (true) {
            Matrix mat = this.matrix.copy();
            this.logger.log(Level.ALL, new Object[]{"Basic matrix is:", "\n" + mat.toString()});
            this.zeroSubs(mat, init);
            this.zeroSubs(mat, zeros);
            this.logger.log(Level.ALL, new Object[]{"Using assumptions", zeros.toString() + ",", "get matrix:", "\n" + mat.toString()});
            rrefnonzeros = mat.putInRREF(this.logger);
            this.logger.log(Level.ALL, new Object[]{"RREF:", "\n" + mat.toString()});
            this.logger.log(Level.ALL, new Object[]{"Assumptions made during RREF process:", "\n" + rrefnonzeros.toString()});
            azrZeros = mat.getAlmostZeroRowAssumptions();
            this.logger.log(Level.ALL, new Object[]{"Assumptions from almost-zero rows:", "\n" + azrZeros.toString()});
            PivotRowHandler prh = new PivotRowHandler(mat, this.logger);
            try {
                pivotAssumptionSets = prh.handlePivotRows();
            }
            catch (MatrixSolvingFailedException e) {
                this.logger.log(Level.ALL, new Object[]{e.toString()});
                if (e.getReason() != MatrixSolvingFailedException.Reason.BadNonzeroAssumptions) continue;
                this.logger.log(Level.ALL, new Object[]{"Nonzero assumptions were:", "\n" + rrefnonzeros.toString()});
                zeroPolyMan.extend(rrefnonzeros);
                this.logger.log(Level.ALL, new Object[]{zeroPolyMan});
                zeros = zeroPolyMan.next();
                this.logger.log(Level.ALL, new Object[]{"New set of zeros:\n", zeros});
                if (zeros.size() == 0) {
                    throw new MatrixSolvingFailedException(MatrixSolvingFailedException.Reason.BadTemplate);
                }
                this.logger.log(Level.ALL, new Object[]{"We therefore try again, assuming:", "\n" + zeros.toString()});
                continue;
            }
            break;
        }
        AssumptionSet base = new AssumptionSet();
        base.addAll(azrZeros);
        base.addAll(rrefnonzeros);
        base.addAll(zeros);
        for (AssumptionSet aset : pivotAssumptionSets) {
            aset.addAll(base);
        }
        return pivotAssumptionSets;
    }

    private void zeroSubs(Matrix mat, AssumptionSet zeros) {
        Vector<Substitution> subs = new Vector<Substitution>();
        for (Assumption a : zeros) {
            Polynomial num;
            Substitution s;
            if (a.getAssumptionType() != Assumption.AssumptionType.ZERO || (s = (num = a.getNumerator()).linearIsolateFirst()) == null) continue;
            subs.add(s);
        }
        if (subs.size() == 0) {
            return;
        }
        SubstitutionManager sman = new SubstitutionManager(subs, this.logger);
        sman.applyAll(mat);
    }

    private class ZeroPolynomialManager {
        private final Vector<List<Polynomial>> stack = new Vector();
        private final Vector<Integer> pointers = new Vector();

        public String toString() {
            return "ZeroPolynomialManager:\n  Stack:\n  " + this.stack.toString() + "\n  Pointers:\n  " + this.pointers.toString();
        }

        public void extend(AssumptionSet aset) {
            if (aset.size() == 0) {
                return;
            }
            Vector<Polynomial> polys = new Vector<Polynomial>(aset.size());
            for (Assumption a : aset) {
                polys.add(a.getNumerator());
            }
            this.stack.add(polys);
            this.pointers.add(new Integer(polys.size()));
        }

        public boolean hasNext() {
            return this.stack.size() > 0;
        }

        public AssumptionSet next() {
            AssumptionSet aset = new AssumptionSet();
            if (!this.hasNext()) {
                return aset;
            }
            this.advancePointers();
            for (int i = 0; i < this.stack.size(); ++i) {
                List<Polynomial> polys = this.stack.get(i);
                Integer ptr = this.pointers.get(i);
                Polynomial p = polys.get(ptr);
                aset.add(new Assumption(p, Assumption.AssumptionType.ZERO));
            }
            return aset;
        }

        private void advancePointers() {
            int n = this.pointers.size();
            if (n == 0) {
                return;
            }
            int topPtr = this.pointers.get(n - 1);
            if (topPtr > 0) {
                this.pointers.set(n - 1, new Integer(topPtr - 1));
            } else {
                this.stack.remove(n - 1);
                this.pointers.remove(n - 1);
                this.advancePointers();
            }
        }
    }
}

