/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.balancer.Term;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;

public class Monomial {
    private final boolean writeStars = true;
    private Map<Variable, Integer> vars = new HashMap<Variable, Integer>();

    public Monomial() {
        this.vars = new HashMap<Variable, Integer>();
    }

    public Monomial(Map<Variable, Integer> v) {
        this.vars = v;
    }

    public Monomial(Variable v) {
        this.vars = new HashMap<Variable, Integer>();
        this.vars.put(v, new Integer(1));
    }

    public Monomial copy() {
        HashMap<Variable, Integer> v = new HashMap<Variable, Integer>();
        for (Variable x : this.vars.keySet()) {
            Variable xp = new Variable(x.getName());
            Integer pow = new Integer(this.vars.get(x));
            v.put(xp, pow);
        }
        return new Monomial(v);
    }

    public int getDegree() {
        int d = 0;
        for (Integer e : this.vars.values()) {
            d += e.intValue();
        }
        return d;
    }

    public boolean divides(Term t) {
        return this.divides(t.getMonomial());
    }

    public boolean divides(Monomial m) {
        boolean answer = true;
        for (Variable v : this.vars.keySet()) {
            if (!m.vars.containsKey(v)) {
                answer = false;
                break;
            }
            Integer e = this.vars.get(v);
            Integer f = m.vars.get(v);
            if (f.compareTo(e) >= 0) continue;
            answer = false;
            break;
        }
        return answer;
    }

    public static Monomial divide(Monomial m, Monomial n) {
        Map<Variable, Integer> a = m.vars;
        Map<Variable, Integer> b = n.vars;
        HashMap<Variable, Integer> d = new HashMap<Variable, Integer>();
        for (Variable v : a.keySet()) {
            d.put(v, a.get(v));
        }
        for (Variable v : b.keySet()) {
            int ea = a.containsKey(v) ? a.get(v) : 0;
            d.put(v, new Integer(ea - b.get(v)));
        }
        return new Monomial(d);
    }

    public static Monomial gcd(Monomial ... ma) {
        Vector<Monomial> ml = new Vector<Monomial>(ma.length);
        for (Monomial m : ma) {
            ml.add(m);
        }
        return Monomial.gcd(ml);
    }

    public static Monomial gcd(List<Monomial> mlist) {
        int N = mlist.size();
        if (N == 0) {
            return new Monomial();
        }
        if (N == 1) {
            return mlist.get(0);
        }
        if (N > 2) {
            int L = N / 2;
            Monomial a = Monomial.gcd(mlist.subList(0, L));
            Monomial b = Monomial.gcd(mlist.subList(L, N));
            Monomial d = Monomial.gcd(a, b);
            return d;
        }
        Map<Variable, Integer> a = mlist.get((int)0).vars;
        Map<Variable, Integer> b = mlist.get((int)1).vars;
        HashMap<Variable, Integer> d = new HashMap<Variable, Integer>();
        for (Variable v : a.keySet()) {
            Integer eb;
            if (!b.containsKey(v)) continue;
            Integer ea = a.get(v);
            Integer min = ea.compareTo(eb = b.get(v)) < 0 ? ea : eb;
            d.put(v, min);
        }
        return new Monomial(d);
    }

    public static Monomial multiply(Monomial m1, Monomial m2) {
        Monomial m3 = new Monomial();
        for (Variable v : m1.vars.keySet()) {
            m3.vars.put(v, m1.vars.get(v));
        }
        for (Variable v : m2.vars.keySet()) {
            if (m3.vars.containsKey(v)) {
                int p1 = m3.vars.get(v);
                int p2 = m2.vars.get(v);
                m3.vars.put(v, new Integer(p1 + p2));
                continue;
            }
            m3.vars.put(v, m2.vars.get(v));
        }
        return m3;
    }

    public boolean isConstant() {
        if (this.vars.keySet().size() == 0) {
            return true;
        }
        Collection<Integer> exps = this.vars.values();
        for (Integer e : exps) {
            if (e == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isLinear() {
        if (this.vars.keySet().size() == 0) {
            return false;
        }
        Collection<Integer> exps = this.vars.values();
        int ones = 0;
        for (Integer e : exps) {
            if (e == 0 || !(e == 1 ? ++ones > 1 : e > 1)) continue;
            return false;
        }
        return ones == 1;
    }

    public Variable getLinearVariable() {
        if (this.isLinear()) {
            for (Variable u : this.vars.keySet()) {
                if (this.vars.get(u) != 1) continue;
                return u;
            }
        }
        return null;
    }

    public void setMonomial(Map<Variable, Integer> m) {
        this.vars = m;
    }

    public Map<Variable, Integer> getMonomial() {
        return this.vars;
    }

    public void setPower(Variable v, int n) {
        this.vars.put(v, new Integer(n));
    }

    public int getPower(Variable v) {
        int e = 0;
        if (this.vars.containsKey(v)) {
            e = this.vars.get(v);
        }
        return e;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean sortAlpha) {
        String s = "";
        Vector<Variable> varlist = new Vector<Variable>(this.vars.keySet());
        if (sortAlpha) {
            Collections.sort(varlist);
        }
        for (Variable v : varlist) {
            Integer pow = this.vars.get(v);
            int p = pow;
            if (p == 0) continue;
            String t = v.toString();
            if (p != 1) {
                t = "(" + t + "^" + pow.toString() + ")";
            }
            s = s + "*";
            s = s + t;
        }
        s = s.length() == 0 ? "1" : s.substring(1);
        return s;
    }
}

