/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.invariants.balancer.Location;
import org.sosy_lab.cpachecker.util.invariants.balancer.NetworkBuilder;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateMap;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateNetwork;
import org.sosy_lab.cpachecker.util.invariants.balancer.Transition;
import org.sosy_lab.cpachecker.util.invariants.choosers.TemplateChooser;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplatePathFormulaBuilder;

public class PathProgramNetworkBuilder
implements NetworkBuilder {
    private final Path cePath;
    private final LogManager logger;
    private final TemplatePathFormulaBuilder tpfb;
    private final SortedSet<CFANode> nodeSet;
    private final Collection<CFAUtils.Loop> loops;
    private TemplateChooser chooser;
    private TemplateNetwork basicTnet;

    public PathProgramNetworkBuilder(Path pPath, LogManager pLogger) throws RefinementFailedException {
        this.cePath = pPath;
        this.logger = pLogger;
        this.tpfb = new TemplatePathFormulaBuilder();
        this.basicTnet = this.buildNetworkWithoutTemplates();
        this.nodeSet = this.getNodeSet();
        this.loops = this.findLoops();
    }

    private Collection<CFAUtils.Loop> findLoops() {
        Collection<CFAUtils.Loop> loops;
        try {
            loops = CFAUtils.findLoops(this.nodeSet);
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, new Object[]{"While constructing path program, could not detect all loops."});
            loops = null;
        }
        return loops;
    }

    private SortedSet<CFANode> getNodeSet() {
        TreeSet<CFANode> nodes = new TreeSet<CFANode>();
        for (Pair pair : this.cePath) {
            ARTElement ae = (ARTElement)pair.getFirst();
            CFANode n = AbstractElements.extractLocation(ae);
            nodes.add(n);
        }
        return nodes;
    }

    private TemplateNetwork buildNetworkWithoutTemplates() {
        Vector<Transition> trans = new Vector<Transition>();
        TemplateMap tmap = new TemplateMap();
        int N = this.cePath.size() - 1;
        for (int i = 0; i < N; ++i) {
            Pair pair = (Pair)this.cePath.get(i);
            ARTElement ae1 = (ARTElement)pair.getFirst();
            CFAEdge edge = (CFAEdge)pair.getSecond();
            ARTElement ae2 = (ARTElement)((Pair)this.cePath.get(i + 1)).getFirst();
            TemplateFormula transitionFormula = (TemplateFormula)this.tpfb.buildPathFormula(edge).getFormula();
            CFANode node = AbstractElements.extractLocation(ae1);
            Location l1 = new Location(node);
            node = AbstractElements.extractLocation(ae2);
            Location l2 = new Location(node);
            Transition tran = new Transition(tmap, l1, transitionFormula, l2);
            trans.add(tran);
        }
        return new TemplateNetwork(tmap, trans);
    }

    @Override
    public TemplateNetwork nextNetwork() {
        return null;
    }
}

