/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Monomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Substitution;
import org.sosy_lab.cpachecker.util.invariants.balancer.Term;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;

public class Polynomial {
    private List<Term> terms = new Vector<Term>();

    public Polynomial() {
    }

    public Polynomial(List<Term> tlist) {
        this.terms = new Vector<Term>();
        for (Term t : tlist) {
            if (t.isZero()) continue;
            this.terms.add(t);
        }
    }

    public Polynomial(Term t) {
        this.terms = new Vector<Term>();
        this.terms.add(t);
    }

    public Polynomial(int n) {
        this.makeConstant(new Rational(n, 1));
    }

    public Polynomial(Rational r) {
        this.makeConstant(r);
    }

    public Polynomial(Variable v) {
        Term t = new Term(v);
        this.terms = new Vector<Term>();
        this.terms.add(t);
    }

    public Polynomial copy() {
        Vector<Term> ts = new Vector<Term>(this.terms.size());
        for (Term t : this.terms) {
            ts.add(t.copy());
        }
        return new Polynomial(ts);
    }

    private void makeConstant(Rational r) {
        Term t = new Term(r);
        this.terms = new Vector<Term>();
        this.terms.add(t);
    }

    public boolean equals(Polynomial that) {
        Map<String, Rational> m1 = this.getMonomToCoeffMap();
        Map<String, Rational> m2 = that.getMonomToCoeffMap();
        boolean answer = true;
        for (String s : m1.keySet()) {
            Rational c2;
            if (!m2.containsKey(s)) {
                answer = false;
                break;
            }
            Rational c1 = m1.get(s);
            if (c1.equals(c2 = m2.get(s))) continue;
            answer = false;
            break;
        }
        return answer;
    }

    public Map<String, Rational> getMonomToCoeffMap() {
        this.collect();
        HashMap<String, Rational> map = new HashMap<String, Rational>();
        for (Term t : this.terms) {
            String m = t.getMonomial().toString(true);
            Rational c = t.getCoeff();
            map.put(m, c);
        }
        return map;
    }

    public static Polynomial add(Polynomial f1, Polynomial f2) {
        List<Term> tlist = new Vector<Term>(f1.terms);
        tlist.addAll(f2.terms);
        tlist = Polynomial.collect(tlist);
        return new Polynomial(tlist);
    }

    public static Polynomial subtract(Polynomial f1, Polynomial f2) {
        List<Term> tlist = new Vector<Term>(f1.terms);
        Polynomial mf2 = Polynomial.makeNegative(f2);
        tlist.addAll(mf2.terms);
        tlist = Polynomial.collect(tlist);
        return new Polynomial(tlist);
    }

    public static Polynomial multiply(Polynomial f1, Polynomial f2) {
        List<Term> tlist = new Vector<Term>();
        for (Term a : f1.terms) {
            for (Term b : f2.terms) {
                Term c = Term.multiply(a, b);
                tlist.add(c);
            }
        }
        tlist = Polynomial.collect(tlist);
        return new Polynomial(tlist);
    }

    public static Polynomial power(Polynomial f, int e) {
        if (e < 0) {
            return null;
        }
        if (e == 0) {
            return Polynomial.makeUnity();
        }
        if (e == 1) {
            return f.copy();
        }
        if (e <= 100) {
            Polynomial g = Polynomial.power(f, e - 1);
            return Polynomial.multiply(f, g);
        }
        System.err.println("Tried to raise polynomial to power higher than 100.");
        return null;
    }

    public static Polynomial makeNegative(Polynomial f) {
        Vector<Term> tlist = new Vector<Term>(f.terms.size());
        for (Term t : f.terms) {
            Term u = Term.makeNegative(t);
            tlist.add(u);
        }
        return new Polynomial(tlist);
    }

    public static Polynomial makeZero() {
        return new Polynomial(Term.makeZero());
    }

    public static Polynomial makeUnity() {
        return new Polynomial(Term.makeUnity());
    }

    public static Polynomial applySubstitution(Substitution subs, Polynomial f) {
        Variable v = subs.getVar();
        Polynomial g = subs.getRHS();
        Polynomial h = Polynomial.makeZero();
        for (Term t : f.terms) {
            Polynomial q;
            int e = t.getPower(v);
            if (e == 0) {
                q = new Polynomial(t.copy());
                h = Polynomial.add(h, q);
                continue;
            }
            t = t.copy();
            t.setPower(v, 0);
            q = new Polynomial(t);
            Polynomial p = e == 1 ? g : Polynomial.power(g, e);
            p = Polynomial.multiply(p, q);
            h = Polynomial.add(h, p);
        }
        h.collect();
        return h;
    }

    public void collect() {
        this.terms = Polynomial.collect(this.terms);
    }

    public static List<Term> collect(List<Term> tlist) {
        HashMap<String, Term> gatheredTerms = new HashMap<String, Term>();
        boolean sortAlpha = true;
        for (Term t : tlist) {
            String monom = t.getMonomial().toString(sortAlpha);
            if (gatheredTerms.containsKey(monom)) {
                Rational current = ((Term)gatheredTerms.get(monom)).getCoeff();
                Rational augend = t.getCoeff();
                Rational sum = current.plus(augend);
                ((Term)gatheredTerms.get(monom)).setCoeff(sum);
                continue;
            }
            Term u = new Term();
            u.setCoeff(t.getCoeff());
            u.setMonomial(t.getMonomial());
            gatheredTerms.put(monom, u);
        }
        Vector<Term> collected = new Vector<Term>(gatheredTerms.values());
        return collected;
    }

    public boolean isZero() {
        if (this.terms.size() == 0) {
            return true;
        }
        this.terms = Polynomial.collect(this.terms);
        if (this.terms.size() > 1) {
            return false;
        }
        Term t = this.terms.get(0);
        return t.isZero();
    }

    public boolean isUnity() {
        if (this.terms.size() == 0) {
            return false;
        }
        this.terms = Polynomial.collect(this.terms);
        if (this.terms.size() > 1) {
            return false;
        }
        Term t = this.terms.get(0);
        return t.isUnity();
    }

    public boolean isPositive() {
        if (this.terms.size() == 0) {
            return false;
        }
        this.terms = Polynomial.collect(this.terms);
        if (this.terms.size() > 1) {
            return false;
        }
        Term t = this.terms.get(0);
        return t.isPositive();
    }

    public boolean isConstant() {
        if (this.terms.size() == 0) {
            return true;
        }
        this.terms = Polynomial.collect(this.terms);
        if (this.terms.size() > 1) {
            return false;
        }
        Term t = this.terms.get(0);
        return t.isConstant();
    }

    public Rational getConstant() {
        Rational r = null;
        if (this.isConstant()) {
            r = this.terms.get(0).getCoeff();
        }
        return r;
    }

    public List<Monomial> getMonomials() {
        this.collect();
        Vector<Monomial> mlist = new Vector<Monomial>();
        for (Term t : this.terms) {
            mlist.add(t.getMonomial());
        }
        return mlist;
    }

    public int getDegree() {
        this.collect();
        int d = 0;
        for (Term t : this.terms) {
            int e = t.getDegree();
            if (e <= d) continue;
            d = e;
        }
        return d;
    }

    public int getNumTerms() {
        this.collect();
        return this.terms.size();
    }

    public Monomial getMonomialContent() {
        return Monomial.gcd(this.getMonomials());
    }

    public int getUnitContent() {
        if (this.isZero()) {
            return 0;
        }
        int u = -1;
        for (Term t : this.terms) {
            if (!t.getCoeff().isPositive()) continue;
            u = 1;
            break;
        }
        return u;
    }

    public Rational getRationalContent() {
        List<Rational> coeffs = this.getCoeffs();
        Vector<Integer> denoms = new Vector<Integer>(coeffs.size());
        for (Rational r : coeffs) {
            denoms.add(r.getDenominator());
        }
        int d = Polynomial.gcd(denoms);
        int p = Polynomial.intProduct(denoms);
        int l = p / d;
        Polynomial lTimesThis = Polynomial.multiply(new Polynomial(l), this);
        int g = lTimesThis.getIntegerContent();
        Rational c = new Rational(g, l);
        return c;
    }

    public Polynomial cancelRationalContent() {
        Rational c = this.getRationalContent();
        if (c.isZero()) {
            return this.copy();
        }
        Rational r = c.makeReciprocal();
        Polynomial p = Polynomial.multiply(new Polynomial(r), this);
        return p;
    }

    public Rational rationalConstantQuotientOver(Polynomial that) {
        Polynomial q;
        Rational a = this.getRationalContent();
        Rational b = that.getRationalContent();
        Polynomial p = this.cancelRationalContent();
        if (Polynomial.subtract(p, q = that.cancelRationalContent()).isZero()) {
            return a.div(b);
        }
        if (Polynomial.add(p, q).isZero()) {
            return a.div(b).makeNegative();
        }
        return null;
    }

    public boolean isRationalConstantMultipleOf(Polynomial that) {
        Polynomial q;
        Polynomial p = this.cancelRationalContent();
        if (Polynomial.subtract(p, q = that.cancelRationalContent()).isZero()) {
            return true;
        }
        return Polynomial.add(p, q).isZero();
    }

    public List<Rational> getCoeffs() {
        this.collect();
        Vector<Rational> coeffs = new Vector<Rational>(this.terms.size());
        for (Term t : this.terms) {
            coeffs.add(t.getCoeff());
        }
        return coeffs;
    }

    public Integer getIntegerContent() {
        this.collect();
        Vector<Integer> coeffs = new Vector<Integer>(this.terms.size());
        for (Term t : this.terms) {
            Rational c = t.getCoeff();
            if (c.isIntegral()) {
                if (c.isZero()) continue;
                coeffs.add(t.getCoeff().makeInteger());
                continue;
            }
            return new Integer(1);
        }
        if (coeffs.size() == 0) {
            return new Integer(1);
        }
        Vector<Integer> absCoeffs = new Vector<Integer>(coeffs.size());
        for (Integer nI : coeffs) {
            int n = nI;
            if (n < 0) {
                n = -1 * n;
            }
            absCoeffs.add(new Integer(n));
        }
        Integer d = Polynomial.gcd(absCoeffs);
        return d;
    }

    public boolean factorOut(Monomial m) {
        boolean success = true;
        Vector<Term> results = new Vector<Term>(this.terms.size());
        for (Term t : this.terms) {
            if (m.divides(t)) {
                Term u = Term.divide(t, m);
                results.add(u);
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            this.terms = results;
        }
        return success;
    }

    public String toString() {
        if (this.terms.size() == 0) {
            return "0";
        }
        String s = "";
        for (Term t : this.terms) {
            s = s + " + " + t.toString();
        }
        s = s.substring(3);
        return s;
    }

    public static Integer intProduct(List<Integer> list) {
        int p = 1;
        for (Integer f : list) {
            p *= f.intValue();
        }
        return new Integer(p);
    }

    public static Integer gcd(Integer ... ma) {
        Vector<Integer> ml = new Vector<Integer>(ma.length);
        for (Integer m : ma) {
            ml.add(m);
        }
        return Polynomial.gcd(ml);
    }

    public static Integer gcd(List<Integer> mlist) {
        int N = mlist.size();
        if (N == 0) {
            return new Integer(1);
        }
        if (N == 1) {
            return mlist.get(0);
        }
        if (N > 2) {
            int L = N / 2;
            Integer a = Polynomial.gcd(mlist.subList(0, L));
            Integer b = Polynomial.gcd(mlist.subList(L, N));
            Integer d = Polynomial.gcd(a, b);
            return d;
        }
        Integer a = mlist.get(0);
        Integer b = mlist.get(1);
        return Polynomial.euclideanAlgorithm(a, b);
    }

    public static Integer euclideanAlgorithm(Integer aI, Integer bI) {
        int r;
        int b = aI;
        if (b * b < (r = bI.intValue()) * r) {
            int t = b;
            b = r;
            r = t;
        }
        while (r != 0) {
            int a = b;
            b = r;
            r = a % b;
        }
        return new Integer(b);
    }

    public Substitution linearIsolateFirst() {
        this.collect();
        Term lin = null;
        Vector<Term> others = new Vector<Term>(this.terms.size() - 1);
        for (Term t : this.terms) {
            if (lin == null && t.isLinear()) {
                lin = t.copy();
                continue;
            }
            others.add(t.copy());
        }
        if (lin == null) {
            return null;
        }
        Polynomial rhs = new Polynomial(others);
        Rational c = lin.getCoeff().makeNegative().makeReciprocal();
        rhs = Polynomial.multiply(new Polynomial(c), rhs);
        Variable v = lin.getLinearVariable();
        Substitution s = new Substitution(v, rhs);
        return s;
    }
}

