/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Monomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Substitution;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;

public class RationalFunction {
    private Polynomial num;
    private Polynomial denom;

    public RationalFunction(Polynomial n, Polynomial d) {
        this.num = n;
        this.denom = d;
        this.simplify();
    }

    public RationalFunction(Polynomial n) {
        this.num = n;
        this.denom = new Polynomial(1);
    }

    public RationalFunction(int n) {
        this.makeConstant(new Rational(n, 1));
    }

    public RationalFunction(String x) {
        Variable v = new Variable(x);
        this.num = new Polynomial(v);
        this.denom = new Polynomial(1);
    }

    public RationalFunction(Variable v) {
        this.num = new Polynomial(v);
        this.denom = new Polynomial(1);
    }

    public RationalFunction(Rational r) {
        this.makeConstant(r);
    }

    public RationalFunction copy() {
        return new RationalFunction(this.num.copy(), this.denom.copy());
    }

    public Polynomial getNumerator() {
        return this.num;
    }

    public Polynomial getDenominator() {
        return this.denom;
    }

    public static RationalFunction buildVar(String x) {
        Variable v = new Variable(x);
        RationalFunction f = new RationalFunction(v);
        return f;
    }

    private void makeConstant(Rational r) {
        this.num = new Polynomial(r);
        this.denom = new Polynomial(1);
    }

    public static RationalFunction makeZero() {
        return new RationalFunction(Polynomial.makeZero(), Polynomial.makeUnity());
    }

    public static RationalFunction makeUnity() {
        return new RationalFunction(Polynomial.makeUnity(), Polynomial.makeUnity());
    }

    public static RationalFunction add(RationalFunction f1, RationalFunction f2) {
        Polynomial n1 = f1.num;
        Polynomial d1 = f1.denom;
        Polynomial n2 = f2.num;
        Polynomial d2 = f2.denom;
        Polynomial n1d2 = Polynomial.multiply(n1, d2);
        Polynomial n2d1 = Polynomial.multiply(n2, d1);
        Polynomial a = Polynomial.add(n1d2, n2d1);
        Polynomial b = Polynomial.multiply(d1, d2);
        RationalFunction f = new RationalFunction(a, b);
        f.simplify();
        return f;
    }

    public static RationalFunction subtract(RationalFunction f1, RationalFunction f2) {
        Polynomial n1 = f1.num;
        Polynomial d1 = f1.denom;
        Polynomial n2 = f2.num;
        Polynomial d2 = f2.denom;
        Polynomial n1d2 = Polynomial.multiply(n1, d2);
        Polynomial n2d1 = Polynomial.multiply(n2, d1);
        Polynomial a = Polynomial.subtract(n1d2, n2d1);
        Polynomial b = Polynomial.multiply(d1, d2);
        RationalFunction f = new RationalFunction(a, b);
        f.simplify();
        return f;
    }

    public static RationalFunction multiply(RationalFunction f1, RationalFunction f2) {
        Polynomial n1 = f1.num;
        Polynomial d1 = f1.denom;
        Polynomial n2 = f2.num;
        Polynomial d2 = f2.denom;
        Polynomial a = Polynomial.multiply(n1, n2);
        Polynomial b = Polynomial.multiply(d1, d2);
        RationalFunction f = new RationalFunction(a, b);
        f.simplify();
        return f;
    }

    public static RationalFunction divide(RationalFunction f1, RationalFunction f2) {
        Polynomial n1 = f1.num;
        Polynomial d1 = f1.denom;
        Polynomial n2 = f2.num;
        Polynomial d2 = f2.denom;
        Polynomial a = Polynomial.multiply(n1, d2);
        Polynomial b = Polynomial.multiply(d1, n2);
        RationalFunction f = new RationalFunction(a, b);
        f.simplify();
        return f;
    }

    public static RationalFunction makeReciprocal(RationalFunction f) {
        return new RationalFunction(f.denom, f.num);
    }

    public static RationalFunction makeNegative(RationalFunction f) {
        Polynomial negnum = Polynomial.makeNegative(f.num);
        return new RationalFunction(negnum, f.denom);
    }

    public static RationalFunction applySubstitution(Substitution subs, RationalFunction f) {
        Polynomial n = Polynomial.applySubstitution(subs, f.num);
        Polynomial d = Polynomial.applySubstitution(subs, f.denom);
        RationalFunction g = new RationalFunction(n, d);
        g.simplify();
        return g;
    }

    public boolean isZero() {
        return this.num.isZero();
    }

    public boolean isUnity() {
        return this.num.equals(this.denom);
    }

    public boolean isPositive() {
        return this.isConstant() && this.num.isPositive();
    }

    public boolean isConstant() {
        return this.num.isConstant() && this.denom.isConstant();
    }

    public boolean isPolynomial() {
        return this.denom.isUnity();
    }

    public boolean isRationalConstantMultipleOf(RationalFunction that) {
        Polynomial s;
        Polynomial r;
        RationalFunction b;
        Polynomial q;
        Polynomial p = this.num.cancelRationalContent();
        RationalFunction a = new RationalFunction(p, q = this.denom.cancelRationalContent());
        if (RationalFunction.subtract(a, b = new RationalFunction(r = that.num.cancelRationalContent(), s = that.denom.cancelRationalContent())).isZero()) {
            return true;
        }
        return RationalFunction.add(a, b).isZero();
    }

    public int getTermHeight() {
        return Math.max(this.num.getNumTerms(), this.denom.getNumTerms());
    }

    public Rational getConstant() {
        Rational c = null;
        if (this.isConstant()) {
            Rational a = this.num.getConstant();
            Rational b = this.denom.getConstant();
            c = a.div(b);
        }
        return c;
    }

    public boolean equals(Object o) {
        boolean ans = false;
        if (o instanceof RationalFunction) {
            String s1 = this.toString();
            String s2 = o.toString();
            ans = s1.equals(s2);
        }
        return ans;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        String s = this.num.toString();
        if (!this.isPolynomial() && !this.isZero()) {
            s = "(" + s + ") / (" + this.denom.toString() + ")";
        }
        return s;
    }

    public void simplify() {
        Object c;
        Monomial md;
        Monomial mn;
        Monomial mc;
        Rational q = this.num.rationalConstantQuotientOver(this.denom);
        if (q != null) {
            this.num = new Polynomial(q);
            this.denom = new Polynomial(1);
        }
        if (!this.isPolynomial()) {
            Rational a = this.num.getRationalContent();
            Rational b = this.denom.getRationalContent();
            this.num = this.num.cancelRationalContent();
            this.denom = this.denom.cancelRationalContent();
            Rational c2 = a.div(b);
            int n = c2.getNumerator();
            int d = c2.getDenominator();
            this.num = Polynomial.multiply(new Polynomial(n), this.num);
            this.denom = Polynomial.multiply(new Polynomial(d), this.denom);
        }
        if (!(mc = Monomial.gcd(mn = this.num.getMonomialContent(), md = this.denom.getMonomialContent())).isConstant()) {
            this.num.factorOut(mc);
            this.denom.factorOut(mc);
        }
        Integer cnI = this.num.getIntegerContent();
        Integer cdI = this.denom.getIntegerContent();
        int cn = cnI;
        int cd = cdI;
        if (cn >= 2 && cd >= 2 && (Integer)(c = Polynomial.gcd(cnI, cdI)) > 1) {
            Rational d = new Rational(1, (Integer)c);
            Polynomial p = new Polynomial(d);
            this.num = Polynomial.multiply(p, this.num);
            this.denom = Polynomial.multiply(p, this.denom);
        }
        if (this.denom.isConstant() && !this.denom.isUnity()) {
            c = this.denom.getConstant();
            Polynomial cinv = new Polynomial(((Rational)c).makeReciprocal());
            this.num = Polynomial.multiply(cinv, this.num);
            this.denom = new Polynomial(1);
        }
        if (this.num.isZero()) {
            this.denom = Polynomial.makeUnity();
        } else if (this.num.equals(this.denom)) {
            this.num = Polynomial.makeUnity();
            this.denom = Polynomial.makeUnity();
        } else if (Polynomial.multiply(new Polynomial(-1), this.num).equals(this.denom)) {
            this.num = new Polynomial(-1);
            this.denom = Polynomial.makeUnity();
        }
    }
}

