/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFAEdge;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.cfa.objectmodel.c.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractElement;
import org.sosy_lab.cpachecker.cpa.art.ARTElement;
import org.sosy_lab.cpachecker.cpa.art.Path;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractElements;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.invariants.GraphUtil;
import org.sosy_lab.cpachecker.util.invariants.balancer.Location;
import org.sosy_lab.cpachecker.util.invariants.balancer.NetworkBuilder;
import org.sosy_lab.cpachecker.util.invariants.balancer.Template;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateMap;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateNetwork;
import org.sosy_lab.cpachecker.util.invariants.balancer.Transition;
import org.sosy_lab.cpachecker.util.invariants.choosers.SingleLoopTemplateChooser;
import org.sosy_lab.cpachecker.util.invariants.choosers.TemplateChooser;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplatePathFormulaBuilder;
import org.sosy_lab.cpachecker.util.predicates.PathFormula;

public class SingleLoopNetworkBuilder
implements NetworkBuilder {
    private final Path cePath;
    private final LogManager logger;
    private final TemplatePathFormulaBuilder tpfb;
    private final CFAUtils.Loop loop;
    private final CFANode root;
    private final CFANode loopHead;
    private final CFANode error;
    private final PathFormula entryFormula;
    private final PathFormula loopFormulaHead;
    private final PathFormula loopFormulaTail;
    private final PathFormula loopFormula;
    private final PathFormula exitFormulaHead;
    private final PathFormula exitFormulaTail;
    private final PathFormula exitFormula;
    private final TemplateChooser chooser;

    public SingleLoopNetworkBuilder(Path pPath, LogManager pLogger) throws RefinementFailedException {
        this.cePath = pPath;
        this.logger = pLogger;
        this.tpfb = new TemplatePathFormulaBuilder();
        this.loop = this.getSingleLoopOrDie();
        Iterable incomingEdges = Iterables.filter(this.loop.getIncomingEdges(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(FunctionReturnEdge.class)));
        if (Iterables.size((Iterable)incomingEdges) > 1) {
            this.logger.log(Level.FINEST, new Object[]{"Could not use invariant generation for proving program safety, loop has too many incoming edges", incomingEdges});
            throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, this.cePath);
        }
        if (this.loop.getLoopHeads().size() > 1) {
            this.logger.log(Level.FINEST, new Object[]{"Could not use invariant generation for proving program safety, loop has too many loop heads."});
            throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, this.cePath);
        }
        this.loopHead = (CFANode)Iterables.getOnlyElement(this.loop.getLoopHeads());
        assert (this.loopHead.equals(((CFAEdge)Iterables.getOnlyElement((Iterable)incomingEdges)).getSuccessor()));
        this.logger.log(Level.FINEST, new Object[]{"Constructing single loop network builder."});
        this.root = AbstractElements.extractLocation((AbstractElement)((Pair)this.cePath.getFirst()).getFirst());
        this.error = AbstractElements.extractLocation((AbstractElement)((Pair)this.cePath.getLast()).getFirst());
        this.entryFormula = this.buildEntryFormula(this.cePath, this.loopHead);
        List<PathFormula> loopFormulas = this.buildLoopFormulas(this.loop);
        this.loopFormula = loopFormulas.get(0);
        this.loopFormulaHead = loopFormulas.get(1);
        this.loopFormulaTail = loopFormulas.get(2);
        Pair<PathFormula, PathFormula> exitHeadAndTail = this.buildExitFormulaHeadAndTail(this.cePath, this.loopHead);
        this.exitFormulaHead = (PathFormula)exitHeadAndTail.getFirst();
        this.exitFormulaTail = (PathFormula)exitHeadAndTail.getSecond();
        this.exitFormula = this.buildExitFormula(this.cePath, this.loopHead);
        this.logger.log(Level.ALL, new Object[]{"\nEntry, loop, and exit formulas:\nEntry: ", this.entryFormula, "\nLoop: ", this.loopFormula, "\nExit: ", this.exitFormula});
        this.chooser = this.buildChooser(this.entryFormula, this.loopFormula, this.loopFormulaHead, this.loopFormulaTail, this.exitFormula, this.exitFormulaHead, this.exitFormulaTail);
    }

    private CFAUtils.Loop getSingleLoopOrDie() throws RefinementFailedException {
        TreeSet<CFANode> nodes = new TreeSet<CFANode>(this.getAllNodes());
        try {
            Collection<CFAUtils.Loop> loops = CFAUtils.findLoops(nodes);
            if (loops.size() > 1) {
                this.logger.log(Level.FINEST, new Object[]{"Could not use invariant generation for proving program safety, program has too many loops."});
                throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, this.cePath);
            }
            if (loops.isEmpty()) {
                this.logger.log(Level.FINEST, new Object[]{"Could not use invariant generation for proving program safety, program has no loops."});
                throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, this.cePath);
            }
            CFAUtils.Loop loop = (CFAUtils.Loop)Iterables.getOnlyElement(loops);
            return loop;
        }
        catch (ParserException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not analyze loop structure of program.");
            throw new RefinementFailedException(RefinementFailedException.Reason.InvariantRefinementFailed, this.cePath);
        }
    }

    private Set<CFANode> getAllNodes() {
        Pair rootPair = (Pair)this.cePath.getFirst();
        ARTElement ae = (ARTElement)rootPair.getFirst();
        CFANode root = AbstractElements.extractLocation(ae);
        CFATraversal.NodeCollectingCFAVisitor visitor = new CFATraversal.NodeCollectingCFAVisitor();
        CFATraversal.dfs().traverse(root, visitor);
        return visitor.getVisitedNodes();
    }

    private PathFormula buildEntryFormula(Path pPath, CFANode loopHead) {
        Vector<CFAEdge> edges = new Vector<CFAEdge>();
        for (Pair pair : pPath) {
            ARTElement ae = (ARTElement)pair.getFirst();
            CFAEdge edge = (CFAEdge)pair.getSecond();
            CFANode loc = AbstractElements.extractLocation(ae);
            if (loc == loopHead) break;
            edges.add(edge);
        }
        PathFormula entryFormula = this.tpfb.buildPathFormula(edges);
        return entryFormula;
    }

    private List<PathFormula> buildLoopFormulas(CFAUtils.Loop loop) {
        this.logger.log(Level.ALL, new Object[]{"Loop:\n", loop});
        Vector<CFANode> loopNodes = new Vector<CFANode>((Collection<CFANode>)loop.getLoopNodes());
        Vector<CFAEdge> loopEdges = GraphUtil.makeEdgeLoop(loopNodes, this.logger);
        this.logger.log(Level.ALL, new Object[]{"Sequence of edges in loop:\n", loopEdges});
        Vector<CFAEdge> loopHead = new Vector<CFAEdge>(1);
        loopHead.add(loopEdges.get(0));
        Vector<CFAEdge> loopTail = new Vector<CFAEdge>(loopEdges.size() - 1);
        loopTail.addAll(loopEdges);
        loopTail.remove(0);
        PathFormula loopFormula = this.tpfb.buildPathFormula(loopEdges);
        PathFormula loopFormulaHead = this.tpfb.buildPathFormula(loopHead);
        PathFormula loopFormulaTail = this.tpfb.buildPathFormula(loopTail);
        Vector<PathFormula> three = new Vector<PathFormula>(3);
        three.add(loopFormula);
        three.add(loopFormulaHead);
        three.add(loopFormulaTail);
        return three;
    }

    private PathFormula buildExitFormula(Path pPath, CFANode loopHead) {
        Vector<CFAEdge> edges = new Vector<CFAEdge>();
        boolean begun = false;
        int N = pPath.size() - 1;
        for (int i = 0; i < N; ++i) {
            Pair pair = (Pair)pPath.get(i);
            if (begun) {
                CFAEdge edge = (CFAEdge)pair.getSecond();
                edges.add(edge);
                continue;
            }
            ARTElement ae = (ARTElement)pair.getFirst();
            CFANode loc = AbstractElements.extractLocation(ae);
            if (loc != loopHead) continue;
            begun = true;
            CFAEdge edge = (CFAEdge)pair.getSecond();
            edges.add(edge);
        }
        PathFormula exitFormula = this.tpfb.buildPathFormula(edges);
        return exitFormula;
    }

    private Pair<PathFormula, PathFormula> buildExitFormulaHeadAndTail(Path pPath, CFANode loopHead) {
        CFAEdge headEdge = null;
        Vector<CFAEdge> tailEdges = new Vector<CFAEdge>();
        boolean begun = false;
        int N = pPath.size() - 1;
        for (int i = 0; i < N; ++i) {
            CFAEdge edge;
            Pair pair = (Pair)pPath.get(i);
            if (begun) {
                CFAEdge edge2 = (CFAEdge)pair.getSecond();
                tailEdges.add(edge2);
                continue;
            }
            ARTElement ae = (ARTElement)pair.getFirst();
            CFANode loc = AbstractElements.extractLocation(ae);
            if (loc != loopHead) continue;
            begun = true;
            headEdge = edge = (CFAEdge)pair.getSecond();
        }
        PathFormula headFormula = this.tpfb.buildPathFormula(headEdge);
        PathFormula tailFormula = this.tpfb.buildPathFormula(tailEdges);
        Pair exitFormulae = Pair.of((Object)headFormula, (Object)tailFormula);
        return exitFormulae;
    }

    private TemplateChooser buildChooser(PathFormula pEntryFormula, PathFormula pLoopFormula, PathFormula pLoopFormulaHead, PathFormula pLoopFormulaTail, PathFormula pExitFormula, PathFormula pExitHead, PathFormula pExitTail) {
        TemplateFormula entryFormula = (TemplateFormula)pEntryFormula.getFormula();
        TemplateFormula loopFormula = (TemplateFormula)pLoopFormula.getFormula();
        TemplateFormula loopFormulaHead = (TemplateFormula)pLoopFormulaHead.getFormula();
        TemplateFormula loopFormulaTail = (TemplateFormula)pLoopFormulaTail.getFormula();
        TemplateFormula exitFormula = (TemplateFormula)pExitFormula.getFormula();
        TemplateFormula exitFormulaHead = (TemplateFormula)pExitHead.getFormula();
        TemplateFormula exitFormulaTail = (TemplateFormula)pExitTail.getFormula();
        SingleLoopTemplateChooser chooser = new SingleLoopTemplateChooser(this.logger, entryFormula, loopFormula, loopFormulaHead, loopFormulaTail, exitFormula, exitFormulaHead, exitFormulaTail);
        return chooser;
    }

    private TemplateNetwork buildSimpleLoopNetwork(CFANode pRoot, CFANode pLoopHead, CFANode pError, Template pInvTemp, PathFormula pEntryFormula, PathFormula pLoopFormula, PathFormula pExitFormula) {
        Location root = new Location(pRoot);
        Location loopHead = new Location(pLoopHead);
        Location error = new Location(pError);
        TemplateMap tmap = new TemplateMap();
        tmap.put(root, Template.makeTrueTemplate());
        tmap.put(loopHead, pInvTemp);
        tmap.put(error, Template.makeFalseTemplate());
        TemplateFormula entryFormula = (TemplateFormula)pEntryFormula.getFormula();
        TemplateFormula loopFormula = (TemplateFormula)pLoopFormula.getFormula();
        TemplateFormula exitFormula = (TemplateFormula)pExitFormula.getFormula();
        Transition entryTrans = new Transition(tmap, root, entryFormula, loopHead);
        Transition loopTrans = new Transition(tmap, loopHead, loopFormula, loopHead);
        Transition exitTrans = new Transition(tmap, loopHead, exitFormula, error);
        TemplateNetwork tnet = new TemplateNetwork(tmap, entryTrans, loopTrans, exitTrans);
        return tnet;
    }

    @Override
    public TemplateNetwork nextNetwork() {
        Template invTemp = this.chooser.chooseNextTemplate();
        this.logger.log(Level.ALL, new Object[]{"\nChosen invariant template for loop head:\n", invTemp});
        System.out.println("Chosen invariant template for loop head:");
        System.out.println(invTemp);
        TemplateNetwork tnet = this.buildSimpleLoopNetwork(this.root, this.loopHead, this.error, invTemp, this.entryFormula, this.loopFormula, this.exitFormula);
        return tnet;
    }
}

