/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.HashSet;

public class SubsetGenerator {
    private int whole;
    private int part;
    private int choice;
    private boolean hasmore;
    private SubsetGenerator rest;

    public SubsetGenerator(int whole, int part) {
        this.build(whole, part, 0);
    }

    public SubsetGenerator(int whole, int part, int start) {
        this.build(whole, part, start);
    }

    private void build(int whole, int part, int start) {
        if (part > whole || start > whole - part) {
            throw new IllegalArgumentException("Must have part <= whole and start <= whole - part.");
        }
        this.whole = whole;
        this.part = part;
        this.choice = start;
        this.rest = part > 0 ? new SubsetGenerator(whole, part - 1, this.choice + 1) : null;
        this.hasmore = true;
    }

    public boolean hasMore() {
        return this.hasmore;
    }

    public HashSet<Integer> getNext() {
        HashSet<Object> R = null;
        if (this.part == 0) {
            R = new HashSet();
            this.hasmore = false;
        } else if (this.rest.hasMore()) {
            R = this.rest.getNext();
            R.add(new Integer(this.choice));
        } else if (this.choice < this.whole - this.part) {
            ++this.choice;
            this.rest = new SubsetGenerator(this.whole, this.part - 1, this.choice + 1);
            R = this.rest.getNext();
            R.add(new Integer(this.choice));
        }
        if (!(this.choice != this.whole - this.part || this.rest != null && this.rest.hasMore())) {
            this.hasmore = false;
        }
        return R;
    }

    public static void main(String[] args) {
        SubsetGenerator SG = new SubsetGenerator(5, 3);
        while (SG.hasMore()) {
            HashSet<Integer> S = SG.getNext();
            System.out.println(S);
        }
    }
}

