/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;

public class Substitution
implements Comparable<Substitution> {
    private final Variable var;
    private final Polynomial rhs;
    private final int degree;

    public Substitution(Variable v, Polynomial r) {
        this.var = v;
        this.rhs = r;
        this.degree = r.getDegree();
    }

    public Substitution copy() {
        Variable u = this.var.copy();
        Polynomial q = this.rhs.copy();
        return new Substitution(u, q);
    }

    public String toString() {
        String s = "";
        s = s + this.var.toString() + " <-- " + this.rhs.toString();
        return s;
    }

    @Override
    public int compareTo(Substitution other) {
        return this.degree - other.degree;
    }

    public Variable getVar() {
        return this.var;
    }

    public Polynomial getRHS() {
        return this.rhs;
    }

    public int getDegree() {
        return this.degree;
    }

    public Substitution applySubstitution(Substitution subs) {
        Polynomial newrhs = Polynomial.applySubstitution(subs, this.rhs);
        Polynomial newlhs = this.var == subs.getVar() ? subs.getRHS() : new Polynomial(this.var);
        Polynomial f = Polynomial.subtract(newlhs, newrhs);
        Substitution s = f.linearIsolateFirst();
        return s;
    }
}

