/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.Polynomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.Substitution;

public class SubstitutionManager {
    private final LogManager logger;
    private final Vector<Substitution> subList;

    public SubstitutionManager(Collection<Substitution> s, LogManager lm) {
        this.subList = new Vector<Substitution>(s);
        this.logger = lm;
    }

    public SubstitutionManager(AssumptionSet aset, LogManager lm) {
        this.logger = lm;
        this.subList = new Vector();
        for (Assumption a : aset) {
            Polynomial num;
            Substitution s;
            if (a.getAssumptionType() != Assumption.AssumptionType.ZERO || (s = (num = a.getNumerator()).linearIsolateFirst()) == null) continue;
            this.subList.add(s);
        }
    }

    public RationalFunction[][] applyAll(RationalFunction[][] rfs) {
        int m = rfs.length;
        if (m == 0) {
            return new RationalFunction[0][0];
        }
        int n = rfs[0].length;
        if (n == 0) {
            return new RationalFunction[0][0];
        }
        RationalFunction[][] subbed = new RationalFunction[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                subbed[i][j] = rfs[i][j];
            }
        }
        while (this.hasNext()) {
            Substitution subs = this.next();
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    subbed[i][j] = RationalFunction.applySubstitution(subs, subbed[i][j]);
                }
            }
        }
        return subbed;
    }

    public void applyAll(Matrix mat) {
        while (this.hasNext()) {
            Substitution subs = this.next();
            mat.applySubstitution(subs);
        }
    }

    public boolean hasNext() {
        return this.subList.size() > 0;
    }

    public Substitution next() {
        if (!this.hasNext()) {
            return null;
        }
        this.logger.log(Level.ALL, new Object[]{"Substitutions:\n", this.subList});
        Substitution s = this.subList.get(0);
        HashSet<Substitution> toRemove = new HashSet<Substitution>();
        toRemove.add(s);
        for (int i = 1; i < this.subList.size(); ++i) {
            Substitution t = this.subList.get(i);
            Substitution u = t.applySubstitution(s);
            if (u == null) {
                toRemove.add(t);
                continue;
            }
            this.subList.set(i, u);
        }
        this.subList.removeAll(toRemove);
        Collections.sort(this.subList);
        return s;
    }
}

