/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFalse;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTrue;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class Template {
    private final TemplateFormula templateFormula;
    private final TemplateBoolean nonzeroParameterClause;
    private final Set<TemplateVariable> allParameters;
    private final Set<TemplateVariable> allVariables;

    public Template(TemplateFormula tF) {
        this.templateFormula = tF;
        this.nonzeroParameterClause = new TemplateTrue();
        this.allParameters = tF.getAllParameters();
        this.allVariables = tF.getAllVariables();
    }

    public Template(TemplateFormula tF, TemplateFormula nzPC) {
        this.templateFormula = tF;
        this.nonzeroParameterClause = (TemplateBoolean)nzPC;
        this.allParameters = tF.getAllParameters();
        this.allVariables = tF.getAllVariables();
    }

    public static Template makeTrueTemplate() {
        TemplateTrue f = new TemplateTrue();
        Template t = new Template(f);
        return t;
    }

    public static Template makeFalseTemplate() {
        TemplateFalse f = new TemplateFalse();
        Template t = new Template(f);
        return t;
    }

    public TemplateFormula getTemplateFormula() {
        return this.templateFormula;
    }

    public TemplateBoolean getNonzeroParameterClause() {
        return this.nonzeroParameterClause;
    }

    public Set<TemplateVariable> getAllParmeters() {
        return this.allParameters;
    }

    public Set<String> writeAllParameters(VariableWriteMode vwm) {
        HashSet<String> params = new HashSet<String>();
        for (TemplateVariable p : this.allParameters) {
            params.add(p.toString(vwm));
        }
        return params;
    }

    public Set<TemplateVariable> getAllVariables() {
        return this.allVariables;
    }

    public Purification purify(Purification pur) {
        return this.templateFormula.purify(pur);
    }

    public boolean evaluate(Map<String, Rational> vals) {
        return this.templateFormula.evaluate(vals);
    }

    public String toString() {
        return this.templateFormula.toString();
    }
}

