/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Location;
import org.sosy_lab.cpachecker.util.invariants.balancer.Template;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class TemplateMap {
    private HashMap<Location, Template> map = new HashMap();

    public void put(Location L, Template T) {
        this.map.put(L, T);
    }

    public Template getTemplate(CFANode N) {
        Template T = null;
        for (Location L : this.map.keySet()) {
            if (L.getNode() != N) continue;
            T = this.map.get(L);
            break;
        }
        return T;
    }

    public Template getTemplate(Location L) {
        Template T = null;
        if (this.map.containsKey(L)) {
            T = this.map.get(L);
        }
        return T;
    }

    public Set<TemplateVariable> getAllVariables() {
        HashSet<TemplateVariable> vars = new HashSet<TemplateVariable>();
        Collection<Template> range = this.map.values();
        for (Template t : range) {
            vars.addAll(t.getAllVariables());
        }
        return vars;
    }

    public Purification purify(Purification pur) {
        Collection<Template> range = this.map.values();
        for (Template t : range) {
            pur = t.purify(pur);
        }
        return pur;
    }

    public boolean evaluate(Map<String, Rational> vals) {
        boolean ans = true;
        for (Template t : this.map.values()) {
            ans &= t.evaluate(vals);
        }
        return ans;
    }

    public String dumpTemplates() {
        String s = "";
        for (Location l : this.map.keySet()) {
            Template t = this.map.get(l);
            s = s + l.toString() + ": " + t.toString() + "\n";
        }
        return s;
    }

    public Vector<TemplateBoolean> getAllNonzeroParameterClauses() {
        Vector<TemplateBoolean> clauses = new Vector<TemplateBoolean>();
        for (Template t : this.map.values()) {
            clauses.add(t.getNonzeroParameterClause());
        }
        return clauses;
    }

    public Set<String> writeAllParameters(VariableWriteMode vwm) {
        HashSet<String> params = new HashSet<String>();
        for (Template t : this.map.values()) {
            params.addAll(t.writeAllParameters(vwm));
        }
        return params;
    }
}

