/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.cfa.objectmodel.CFANode;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Template;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateMap;
import org.sosy_lab.cpachecker.util.invariants.balancer.Transition;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class TemplateNetwork {
    private AssumptionSet currentAssumptions = new AssumptionSet();
    private Vector<Transition> trans;
    private TemplateMap tmap;

    public TemplateNetwork(TemplateMap tmap, Transition ... trans) {
        Vector<Transition> tvect = new Vector<Transition>();
        for (int i = 0; i < trans.length; ++i) {
            tvect.add(trans[i]);
        }
        this.build(tmap, tvect);
    }

    public TemplateNetwork(TemplateMap tmap, Vector<Transition> trans) {
        this.build(tmap, trans);
    }

    private void build(TemplateMap tmap, Vector<Transition> trans) {
        this.trans = trans;
        this.tmap = tmap;
    }

    public void setAssumptions(AssumptionSet aset) {
        this.currentAssumptions = aset;
    }

    public AssumptionSet getAssumptions() {
        return this.currentAssumptions;
    }

    public Vector<Transition> getTransitions() {
        return this.trans;
    }

    public TemplateMap getTemplateMap() {
        return this.tmap;
    }

    public Template getTemplate(CFANode n) {
        return this.tmap.getTemplate(n);
    }

    public boolean evaluate(Map<String, Rational> vals) {
        boolean ans = this.tmap.evaluate(vals);
        return ans;
    }

    public String dumpTemplates() {
        return this.tmap.dumpTemplates();
    }

    public Vector<TemplateBoolean> getAllNonzeroParameterClauses() {
        return this.tmap.getAllNonzeroParameterClauses();
    }

    public Set<String> writeAllParameters(VariableWriteMode vwm) {
        return this.tmap.writeAllParameters(vwm);
    }
}

