/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Monomial;
import org.sosy_lab.cpachecker.util.invariants.balancer.Variable;

public class Term {
    private Monomial monom = new Monomial();
    private Rational coeff = Rational.makeZero();

    public Term() {
        this.monom = new Monomial();
        this.coeff = Rational.makeZero();
    }

    public Term(Rational c, Monomial m) {
        this.coeff = c;
        this.monom = m;
    }

    public Term(int n) {
        this.makeConstant(new Rational(n, 1));
    }

    public Term(Rational r) {
        this.makeConstant(r);
    }

    public Term(Variable v) {
        this.monom = new Monomial(v);
        this.coeff = Rational.makeUnity();
    }

    public Term copy() {
        return new Term(this.coeff.copy(), this.monom.copy());
    }

    public static Term divide(Term t, Monomial m) {
        Term u = new Term();
        u.setMonomial(m);
        u.setCoeff(Rational.makeUnity());
        return Term.divide(t, u);
    }

    public static Term divide(Term t, Term u) {
        Rational ct = t.getCoeff();
        Rational cu = u.getCoeff();
        Monomial mt = t.getMonomial();
        Monomial mu = u.getMonomial();
        Rational cv = ct.div(cu);
        Monomial mv = Monomial.divide(mt, mu);
        Term v = new Term();
        v.setCoeff(cv);
        v.setMonomial(mv);
        return v;
    }

    private void makeConstant(Rational r) {
        this.monom = new Monomial();
        this.coeff = r;
    }

    public static Term multiply(Term t1, Term t2) {
        Rational c1 = t1.coeff;
        Rational c2 = t2.coeff;
        Monomial m1 = t1.monom;
        Monomial m2 = t2.monom;
        Term t = new Term();
        Rational c3 = c1.times(c2);
        Monomial m3 = Monomial.multiply(m1, m2);
        t.setCoeff(c3);
        t.setMonomial(m3);
        return t;
    }

    public static Term makeNegative(Term t) {
        Term u = new Term();
        u.setCoeff(t.getCoeff().makeNegative());
        u.setMonomial(t.getMonomial());
        return u;
    }

    public static Term makeZero() {
        Term t = new Term();
        t.setCoeff(Rational.makeZero());
        return t;
    }

    public static Term makeUnity() {
        Term t = new Term();
        t.setCoeff(Rational.makeUnity());
        return t;
    }

    public boolean isZero() {
        return this.coeff.isZero();
    }

    public boolean isUnity() {
        return this.isConstant() && this.coeff.isUnity();
    }

    public boolean isPositive() {
        return this.isConstant() && this.coeff.isPositive();
    }

    public boolean isConstant() {
        return this.monom.isConstant();
    }

    public boolean isLinear() {
        return this.monom.isLinear();
    }

    public Variable getLinearVariable() {
        return this.monom.getLinearVariable();
    }

    public void setCoeff(Rational r) {
        this.coeff = r;
    }

    public Rational getCoeff() {
        return this.coeff;
    }

    public void setMonomial(Monomial m) {
        this.monom = m;
    }

    public Monomial getMonomial() {
        return this.monom;
    }

    public int getDegree() {
        return this.monom.getDegree();
    }

    public void setPower(Variable v, int n) {
        this.monom.setPower(v, n);
    }

    public int getPower(Variable v) {
        return this.monom.getPower(v);
    }

    public String toString() {
        if (this.coeff.isZero()) {
            return "0";
        }
        boolean sortAlpha = true;
        String s = this.monom.toString(sortAlpha);
        if (s.equals("1")) {
            return this.coeff.toString();
        }
        if (this.coeff.isUnity()) {
            return s;
        }
        if (this.coeff.makeNegative().isUnity()) {
            return "-" + s;
        }
        return this.coeff.toString() + "*" + s;
    }
}

