/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Location;
import org.sosy_lab.cpachecker.util.invariants.balancer.Template;
import org.sosy_lab.cpachecker.util.invariants.balancer.TemplateMap;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class Transition {
    private final TemplateMap tmap;
    private final Location start;
    private final TemplateFormula constraint;
    private final Location end;
    private String eliminationFormula = null;
    private AssumptionSet rrefAssumptions = null;

    public Transition(TemplateMap tmap, Location s, TemplateFormula c, Location e) {
        this.tmap = tmap;
        this.start = s;
        this.constraint = c;
        this.end = e;
    }

    public Location getStart() {
        return this.start;
    }

    public TemplateFormula getConstraint() {
        return this.constraint;
    }

    public Location getEnd() {
        return this.end;
    }

    public AssumptionSet getRREFassumptions() {
        return this.rrefAssumptions;
    }

    public void setRREFassumptions(AssumptionSet aset) {
        this.rrefAssumptions = aset;
    }

    public String getEliminationFormula() {
        return this.eliminationFormula;
    }

    public void setEliminationFormula(String pEliminationFormula) {
        this.eliminationFormula = pEliminationFormula;
    }

    public boolean hasEliminationFormula() {
        return this.eliminationFormula != null;
    }

    public Set<String> writeAllParameters(VariableWriteMode vwm) {
        HashSet<String> params = new HashSet<String>();
        Template t = this.tmap.getTemplate(this.start);
        Set<TemplateVariable> pvars = t.getAllParmeters();
        t = this.tmap.getTemplate(this.end);
        pvars.addAll(t.getAllParmeters());
        for (TemplateVariable p : pvars) {
            params.add(p.toString(vwm));
        }
        return params;
    }

    public Vector<TemplateBoolean> getAllNonzeroParameterClauses() {
        Vector<TemplateBoolean> clauses = new Vector<TemplateBoolean>();
        Template t = this.tmap.getTemplate(this.start);
        clauses.add(t.getNonzeroParameterClause());
        t = this.tmap.getTemplate(this.end);
        clauses.add(t.getNonzeroParameterClause());
        return clauses;
    }
}

