/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Set;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSumList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class UIFAxiom {
    private TemplateConjunction antecedent;
    private TemplateConstraint consequent;

    public UIFAxiom(TemplateUIF F1, TemplateUIF F2) {
        this.construct(F1, F2);
    }

    public UIFAxiom(TemplateUIF U1, TemplateUIF U2, TemplateTerm T1, TemplateTerm T2) {
        TemplateSumList L1 = U1.getArgs();
        TemplateSumList L2 = U2.getArgs();
        this.antecedent = new TemplateConjunction(L1, L2);
        this.consequent = new TemplateConstraint(T1, InfixReln.EQUAL, T2);
    }

    public UIFAxiom(Purification pur, int i, int j) {
        TemplateUIF F1 = pur.getUIFByIndex(i);
        TemplateUIF F2 = pur.getUIFByIndex(j);
        this.construct(F1, F2);
    }

    private void construct(TemplateUIF F1, TemplateUIF F2) {
        F1 = F1.copy();
        F2 = F2.copy();
        TemplateSumList A1 = F1.getArgs();
        TemplateTerm U1 = F1.getPurifiedName();
        TemplateSumList A2 = F2.getArgs();
        TemplateTerm U2 = F2.getPurifiedName();
        this.antecedent = new TemplateConjunction(A1, A2);
        this.consequent = new TemplateConstraint(U1, InfixReln.EQUAL, U2);
    }

    public TemplateConjunction getAntecedent() {
        return this.antecedent;
    }

    public TemplateConstraint getConsequent() {
        return this.consequent;
    }

    public Set<String> getAllParameters(VariableWriteMode vwm) {
        return this.antecedent.getAllParameters(vwm);
    }

    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager vmgr = this.antecedent.getVariableManager();
        vmgr.merge(this.consequent.getVariableManager());
        return vmgr;
    }

    public String toString() {
        String s = "";
        s = s + this.antecedent.toString();
        s = s + " --> ";
        s = s + this.consequent.toString();
        return s;
    }
}

