/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.balancer.PermutationGenerator;
import org.sosy_lab.cpachecker.util.invariants.balancer.SubsetGenerator;
import org.sosy_lab.cpachecker.util.invariants.balancer.UIFAxiom;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class UIFAxiomSet {
    Vector<UIFAxiom> axioms;
    int maxk;
    int N;
    SubsetGenerator SG;
    PermutationGenerator PG;
    int k;
    Vector<UIFAxiom> axiomSubset;

    public UIFAxiomSet(Purification P, TemplateFormula[] F) {
        HashSet<String> allVars = new HashSet<String>();
        for (int i = 0; i < F.length; ++i) {
            allVars.addAll(this.getAllPurificationVariablesAsStrings(F[i], VariableWriteMode.PLAIN));
        }
        this.axioms = new Vector();
        Collection<String> funcs = P.getFunctionNames();
        for (String name : funcs) {
            Vector<TemplateUIF> UIFs = new Vector<TemplateUIF>();
            Set<String> varsForFunc = P.getVarsForFunction(name);
            for (String var : varsForFunc) {
                if (!allVars.contains(var)) continue;
                TemplateUIF U = P.getUIFByVarString(var);
                UIFs.add(U);
            }
            int m = UIFs.size();
            for (int i = 0; i < m - 1; ++i) {
                TemplateUIF U1 = (TemplateUIF)UIFs.get(i);
                for (int j = i + 1; j < m; ++j) {
                    TemplateUIF U2 = (TemplateUIF)UIFs.get(j);
                    UIFAxiom A = new UIFAxiom(U1, U2);
                    this.axioms.add(A);
                }
            }
        }
        this.N = this.axioms.size();
        if (this.N > 0) {
            this.k = 1;
            this.SG = new SubsetGenerator(this.N, this.k);
            this.PG = new PermutationGenerator(this.k);
            HashSet<Integer> index_subset = this.SG.getNext();
            this.axiomSubset = new Vector();
            for (Integer I : index_subset) {
                this.axiomSubset.add(this.axioms.get(I));
            }
            this.maxk = this.getMaxk(this.N);
        } else {
            System.out.println("error, axiom set of size 0:");
        }
    }

    private int getMaxk(int N) {
        int M = 1;
        if (N < 6 && 1 < N) {
            M = 2;
            if (N == 3) {
                M = 3;
            }
        }
        return M;
    }

    private Set<String> getAllPurificationVariablesAsStrings(TemplateFormula F, VariableWriteMode vwm) {
        Set<TemplateVariable> vars = F.getAllPurificationVariables();
        HashSet<String> str = new HashSet<String>();
        for (TemplateVariable v : vars) {
            str.add(v.toString(vwm));
        }
        return str;
    }

    public boolean hasMore() {
        return this.k < this.N && this.k < this.maxk || this.SG.hasMore() || this.PG.hasMore();
    }

    public Vector<UIFAxiom> getNext() {
        Vector<UIFAxiom> next = null;
        if (this.hasMore()) {
            if (!this.PG.hasMore()) {
                if (!this.SG.hasMore()) {
                    ++this.k;
                    assert (this.k <= this.N);
                    this.SG = new SubsetGenerator(this.N, this.k);
                }
                HashSet<Integer> index_subset = this.SG.getNext();
                this.axiomSubset = new Vector();
                for (Integer I : index_subset) {
                    this.axiomSubset.add(this.axioms.get(I));
                }
                this.PG = new PermutationGenerator(this.k);
            }
            int[] index_perm = this.PG.getNext();
            next = new Vector<UIFAxiom>();
            for (int i = 0; i < index_perm.length; ++i) {
                next.add(this.axiomSubset.get(index_perm[i]));
            }
        }
        return next;
    }
}

