/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRow2;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class ColumnChoiceFrame {
    private Map<PivotRow2, UsableColumn> choices;
    private List<PivotRow2> rows;
    private int ptr;
    private int limit;
    private List<ChallengeType> ctypes;

    public ColumnChoiceFrame(List<PivotRow2> r, ChallengeType c) {
        Vector<ChallengeType> ct = new Vector<ChallengeType>(r.size());
        for (int i = 0; i < r.size(); ++i) {
            ct.add(c);
        }
        this.construct(r, ct);
    }

    public ColumnChoiceFrame(List<PivotRow2> r, List<ChallengeType> c) {
        this.construct(r, c);
    }

    private void construct(List<PivotRow2> r, List<ChallengeType> c) {
        assert (r.size() == c.size());
        this.rows = r;
        this.ctypes = c;
        this.choices = new HashMap<PivotRow2, UsableColumn>();
        if (r.size() > 0) {
            PivotRow2 pr = r.get(0);
            ChallengeType ct = c.get(0);
            switch (ct) {
                case AUGCOLUMN: {
                    this.limit = pr.getTotalOptionCount();
                    break;
                }
                case FREECOLUMN: {
                    this.limit = pr.getFreeColOptionCount();
                }
            }
        }
        this.ptr = 0;
    }

    boolean isComplete() {
        return this.rows.size() == 0;
    }

    boolean hasNext() {
        return this.ptr < this.limit;
    }

    private void setChoices(Map<PivotRow2, UsableColumn> cm) {
        this.choices = cm;
    }

    private void makeRequests() {
        for (PivotRow2 pr : this.choices.keySet()) {
            UsableColumn uc = this.choices.get(pr);
            uc.makeRequest(pr);
        }
    }

    AssumptionSet getAssumptionSet() {
        this.makeRequests();
        AssumptionSet aset = new AssumptionSet();
        for (UsableColumn uc : this.choices.values()) {
            AssumptionSet a = uc.getRequestedAssumptions();
            aset.addAll(a);
            uc.clearRequests();
        }
        return aset;
    }

    ColumnChoiceFrame next() {
        if (this.isComplete() || !this.hasNext()) {
            return null;
        }
        PivotRow2 pr = this.rows.get(0);
        UsableColumn uc = this.ctypes.get(0) == ChallengeType.AUGCOLUMN ? pr.getGeneralOption(this.ptr) : pr.getFreeOption(this.ptr);
        HashMap<PivotRow2, UsableColumn> nextChoices = new HashMap<PivotRow2, UsableColumn>(this.choices);
        nextChoices.put(pr, uc);
        LinkedList<PivotRow2> nextRows = new LinkedList<PivotRow2>(this.rows);
        nextRows.removeFirst();
        LinkedList<ChallengeType> nextCtypes = new LinkedList<ChallengeType>(this.ctypes);
        nextCtypes.removeFirst();
        if (!this.choices.values().contains(uc)) {
            List<PivotRow2> challenged = uc.query();
            Vector<PivotRow2> discard = new Vector<PivotRow2>();
            for (PivotRow2 p : challenged) {
                UsableColumn u;
                if (!this.choices.keySet().contains(p) || (u = this.choices.get(p)).isAugCol()) continue;
                discard.add(p);
            }
            challenged.removeAll(discard);
            for (PivotRow2 p : challenged) {
                if (!nextRows.contains(p)) continue;
                int i = nextRows.indexOf(p);
                nextRows.remove(i);
                nextCtypes.remove(i);
            }
            nextRows.addAll(0, challenged);
            nextCtypes.addAll(0, Collections.nCopies(challenged.size(), ChallengeType.FREECOLUMN));
        }
        ColumnChoiceFrame nextCCF = new ColumnChoiceFrame(nextRows, nextCtypes);
        nextCCF.setChoices(nextChoices);
        ++this.ptr;
        return nextCCF;
    }

    public static enum ChallengeType {
        FREECOLUMN,
        AUGCOLUMN;

    }
}

