/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRow;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class OptionManager {
    private LogManager logger;
    private Map<Integer, UsableColumn> cols;
    private List<PivotRow> rows;
    private boolean initialized;

    public OptionManager(LogManager lm) {
        this.logger = lm;
        this.cols = new HashMap<Integer, UsableColumn>();
        this.rows = new Vector<PivotRow>();
        this.initialized = false;
    }

    private void initialize() {
        if (this.rows.size() >= 2) {
            for (int i = 1; i < this.rows.size(); ++i) {
                PivotRow pr1 = this.rows.get(i - 1);
                PivotRow pr2 = this.rows.get(i);
                pr1.setNextRow(pr2);
            }
        }
        this.initialized = true;
    }

    public int numRemainingRows() {
        return this.rows.size();
    }

    public AssumptionSet nextTry() {
        if (this.rows.size() == 0) {
            return null;
        }
        if (!this.initialized) {
            this.initialize();
        }
        for (UsableColumn u : this.cols.values()) {
            u.clearRequests();
        }
        boolean madeRequest = this.rows.get(0).makeNextRequest();
        if (!madeRequest) {
            return null;
        }
        return this.getRequestedAssumptions();
    }

    public void addUsableColumn(UsableColumn u, Integer j) {
        this.cols.put(j, u);
    }

    public UsableColumn getUsableColumn(Integer j) {
        return this.cols.get(j);
    }

    public void addPivotRow(PivotRow pr) {
        this.rows.add(pr);
    }

    private AssumptionSet getRequestedAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        for (UsableColumn u : this.cols.values()) {
            AssumptionSet a = u.getRequestedAssumptions();
            this.logger.log(Level.ALL, new Object[]{"Column", u.getColNum(), "produced assumption set", a});
            aset.addAll(a);
        }
        return aset;
    }

    private void discardRows(List<PivotRow> discard) {
        this.rows.removeAll(discard);
    }

    public AssumptionSet getSoleOptionRowsAssumptions() {
        Vector<PivotRow> discard = new Vector<PivotRow>();
        for (PivotRow pr : this.rows) {
            boolean madeRequest = pr.makeSoleRequest();
            if (!madeRequest) continue;
            discard.add(pr);
        }
        AssumptionSet aset = this.getRequestedAssumptions();
        this.discardRows(discard);
        return aset;
    }
}

