/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.ColumnChoiceFrame;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRow2;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRowHandler2;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class OptionManager2 {
    private LogManager logger;
    private PivotRowHandler2 prh;
    private Map<Integer, UsableColumn> cols;
    private List<PivotRow2> rows;

    public OptionManager2(PivotRowHandler2 p, LogManager lm) {
        this.prh = p;
        this.logger = lm;
        this.cols = new HashMap<Integer, UsableColumn>();
        this.rows = new Vector<PivotRow2>();
    }

    public int numRemainingRows() {
        return this.rows.size();
    }

    public void addUsableColumn(UsableColumn u, Integer j) {
        this.cols.put(j, u);
    }

    public UsableColumn getUsableColumn(Integer j) {
        return this.cols.get(j);
    }

    public void addPivotRow(PivotRow2 pr) {
        this.rows.add(pr);
    }

    AssumptionSet getRequestedAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        for (UsableColumn u : this.cols.values()) {
            AssumptionSet a = u.getRequestedAssumptions();
            this.logger.log(Level.ALL, new Object[]{"Column", u.getColNum(), "produced assumption set", a});
            aset.addAll(a);
        }
        return aset;
    }

    private void discardRows(List<PivotRow2> discard) {
        this.rows.removeAll(discard);
    }

    public AssumptionSet getSoleOptionRowsAssumptions() {
        Vector<PivotRow2> discard = new Vector<PivotRow2>();
        for (PivotRow2 pr : this.rows) {
            boolean madeRequest = pr.makeSoleRequest();
            if (!madeRequest) continue;
            discard.add(pr);
        }
        AssumptionSet aset = this.getRequestedAssumptions();
        this.discardRows(discard);
        return aset;
    }

    List<PivotRow2> getRowsLackingHeights() {
        Vector<PivotRow2> r = new Vector<PivotRow2>();
        for (PivotRow2 pr : this.rows) {
            int g = pr.getHeight();
            if (g >= 0) continue;
            r.add(pr);
        }
        return r;
    }

    public void assignHeights() {
        this.findRowsWith1s();
        int h = 0;
        for (boolean changed = this.assignRowHeights(h); changed && (changed &= this.assignColHeights(++h)); changed &= this.assignRowHeights(h)) {
        }
    }

    private boolean assignColHeights(int h) {
        boolean changed = false;
        for (UsableColumn u : this.cols.values()) {
            changed |= u.discoverHeight(h);
        }
        return changed;
    }

    private boolean assignRowHeights(int h) {
        boolean changed = false;
        for (PivotRow2 pr : this.rows) {
            changed |= pr.discoverHeight(h);
        }
        return changed;
    }

    private void findRowsWith1s() {
        for (Integer c : this.cols.keySet()) {
            if (c == -1) continue;
            List<Integer> rowNums = this.prh.getRowsWith1sInCol(c);
            Vector<PivotRow2> r = new Vector<PivotRow2>(rowNums.size());
            for (PivotRow2 pr : this.rows) {
                Integer i = new Integer(pr.getRowNum());
                if (!rowNums.contains(i)) continue;
                r.add(pr);
            }
            this.cols.get(c).setRowsWith1s(r);
        }
    }

    ColumnChoiceFrame buildChoiceFrame(List<Integer> rl, ColumnChoiceFrame.ChallengeType ct) {
        Vector<PivotRow2> prs = new Vector<PivotRow2>(rl.size());
        for (PivotRow2 pr : this.rows) {
            if (!rl.contains(pr.getRowNum())) continue;
            prs.add(pr);
        }
        Collections.sort(prs);
        ColumnChoiceFrame ccf = new ColumnChoiceFrame(prs, ct);
        return ccf;
    }
}

