/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRowHandler;

public class OptionTable {
    private int m = 0;
    private int c = 0;
    private int[][] table;
    private List<List<Integer>> usableColumns;
    private LogManager logger;
    private PivotRowHandler prh;
    private Matrix mat;
    private List<Integer> remainingRows;
    private List<Integer> CU;

    public OptionTable(PivotRowHandler p, Matrix mx, int[][] a, List<Integer> rr, List<Integer> cu, LogManager lm) {
        this.logger = lm;
        this.prh = p;
        this.mat = mx;
        this.remainingRows = rr;
        this.CU = cu;
        this.table = a;
        this.m = a.length;
        if (this.m > 0) {
            this.c = a[0].length;
        }
        this.usableColumns = this.computeUsableColumns();
    }

    public List<Integer> getRemainingRows() {
        return this.remainingRows;
    }

    public List<Integer> getSoleOptionRows() {
        Vector<Integer> sole = new Vector<Integer>();
        for (Integer i : this.remainingRows) {
            List<Integer> l = this.usableColumns.get(i);
            if (l.size() != 1) continue;
            sole.add(i);
        }
        return sole;
    }

    public AssumptionSet takeSoleOptions() {
        AssumptionSet aset = new AssumptionSet();
        List<Integer> rows = this.getSoleOptionRows();
        Vector<Integer> discard = new Vector<Integer>();
        for (Integer i0 : rows) {
            int j0 = this.usableColumns.get(i0).get(0);
            int code = this.table[i0][j0];
            switch (code) {
                case 2: {
                    AssumptionSet as = this.change2to7(i0, j0);
                    aset.addAll(as);
                    discard.add(i0);
                    this.logger.log(Level.ALL, new Object[]{"Dicarding row", i0, "and adding assumptions", as.toString() + ". Row has only this option in option table."});
                    break;
                }
                case 3: {
                    AssumptionSet as = this.change3to9(i0, j0);
                    aset.addAll(as);
                    discard.add(i0);
                    this.logger.log(Level.ALL, new Object[]{"Dicarding row", i0, "and adding assumptions", as.toString() + ". Row has only this option in option table."});
                    break;
                }
                case 4: {
                    AssumptionSet as = this.change4to8(i0);
                    aset.addAll(as);
                    discard.add(i0);
                    this.logger.log(Level.ALL, new Object[]{"Dicarding row", i0, "and adding assumptions", as.toString() + ". Row has only this option in option table."});
                    break;
                }
                case 6: {
                    AssumptionSet as = this.change6to7(i0, j0);
                    aset.addAll(as);
                    discard.add(i0);
                    this.logger.log(Level.ALL, new Object[]{"Dicarding row", i0, "and adding assumptions", as.toString() + ". Row has only this option in option table."});
                }
            }
        }
        this.remainingRows.removeAll(discard);
        return aset;
    }

    private AssumptionSet change2to7(int i, int j) {
        AssumptionSet aset = new AssumptionSet();
        this.table[i][j] = 7;
        aset.add(new Assumption(this.mat.getEntry(i, j), Assumption.AssumptionType.NEGATIVE));
        for (Integer k : this.remainingRows) {
            if (k == i || this.table[k][j] != 2) continue;
            this.table[k.intValue()][j] = 6;
            aset.add(new Assumption(this.mat.getEntry(k, j), Assumption.AssumptionType.NONPOSITIVE));
        }
        return aset;
    }

    private AssumptionSet change3to9(int i, int j) {
        AssumptionSet aset = new AssumptionSet();
        this.table[i][j] = 9;
        for (Integer k : this.remainingRows) {
            if (k == i || this.table[k][j] != 2) continue;
            this.table[k.intValue()][j] = 6;
            aset.add(new Assumption(this.mat.getEntry(k, j), Assumption.AssumptionType.NONPOSITIVE));
        }
        return aset;
    }

    private AssumptionSet change4to8(int i) {
        this.table[i][this.c - 1] = 8;
        return this.prh.ar2nonneg(i);
    }

    private AssumptionSet change6to7(int i, int j) {
        AssumptionSet aset = new AssumptionSet();
        this.table[i][j] = 7;
        aset.add(new Assumption(this.mat.getEntry(i, j), Assumption.AssumptionType.NEGATIVE));
        return aset;
    }

    private List<List<Integer>> computeUsableColumns() {
        Vector<List<Integer>> usable = new Vector<List<Integer>>(this.m);
        for (int i = 0; i < this.m; ++i) {
            usable.add(new Vector());
        }
        for (Integer i : this.remainingRows) {
            Vector<Integer> u = new Vector<Integer>();
            for (Integer j : this.CU) {
                int a = this.table[i][j];
                if (2 > a || a > 6 || a == 5) continue;
                u.add(j);
            }
            int a = this.table[i][this.c - 1];
            if (2 <= a && a <= 6 && a != 5) {
                u.add(this.c - 1);
            }
            usable.set(i, u);
        }
        return usable;
    }

    public String toString() {
        String s = "";
        s = s + "Option Table:\n";
        s = s + "Remaining rows: " + this.remainingRows.toString() + "\n";
        s = s + "Conditionally unblocked columns: " + this.CU.toString() + "\n";
        s = s + "Usable columns:\n" + this.usableColumns.toString() + "\n";
        s = s + "Code table:\n";
        for (int i = 0; i < this.m; ++i) {
            s = s + Integer.toString(i) + "  [";
            for (int j = 0; j < this.c; ++j) {
                s = s + " " + Integer.toString(this.table[i][j]);
            }
            s = s + " ]\n";
        }
        return s;
    }
}

