/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class PivotRow {
    private LogManager logger;
    private final int rowNum;
    private final List<UsableColumn> usable;
    private int reqPtr = 0;
    private PivotRow nextRow = null;

    public PivotRow(int i, LogManager lm) {
        this.logger = lm;
        this.rowNum = i;
        this.usable = new Vector<UsableColumn>();
    }

    private void reset() {
        this.reqPtr = 0;
    }

    public void setNextRow(PivotRow n) {
        this.nextRow = n;
    }

    public boolean makeNextRequest() {
        boolean nextRowMadeRequest;
        if (this.nextRow != null && !(nextRowMadeRequest = this.nextRow.makeNextRequest())) {
            this.nextRow.reset();
            this.nextRow.makeNextRequest();
            ++this.reqPtr;
        }
        boolean result = false;
        if (this.usable != null && this.reqPtr < this.usable.size()) {
            UsableColumn u = this.usable.get(this.reqPtr);
            u.makeRequest(this.rowNum);
            this.logger.log(Level.ALL, new Object[]{"Making request, integer", this.rowNum});
            this.logger.log(Level.ALL, new Object[]{"of column", u});
            this.logger.log(Level.ALL, new Object[]{"Row", this.rowNum, "attempting to use column", u.getColNum()});
            result = true;
            if (this.nextRow == null) {
                ++this.reqPtr;
            }
        }
        return result;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void addUsableColumn(UsableColumn u) {
        this.usable.add(u);
    }

    public boolean hasSoleOption() {
        int numOpts = this.usable.size();
        return numOpts == 1;
    }

    public boolean makeSoleRequest() {
        if (this.hasSoleOption()) {
            UsableColumn u = this.usable.get(0);
            u.makeRequest(this.rowNum);
            this.logger.log(Level.ALL, new Object[]{"Row", this.rowNum, "attempting to use column", u.getColNum()});
            return true;
        }
        return false;
    }
}

