/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class PivotRow2
implements Comparable<PivotRow2> {
    private LogManager logger;
    private final int rowNum;
    private final LinkedList<UsableColumn> usable;
    private boolean augColOption = false;
    private int height = -1;

    public PivotRow2(int i, LogManager lm) {
        this.logger = lm;
        this.rowNum = i;
        this.usable = new LinkedList();
    }

    @Override
    public int compareTo(PivotRow2 other) {
        return other.rowNum - this.rowNum;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    boolean discoverHeight(int h) {
        boolean discovered = false;
        for (UsableColumn u : this.usable) {
            int g = u.getHeight();
            if (g < 0) continue;
            this.height = h;
            discovered = true;
            break;
        }
        return discovered;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getHeight() {
        return this.height;
    }

    public void addFreeColumn(UsableColumn u) {
        this.usable.addLast(u);
        Collections.sort(this.usable);
    }

    public void addAugColumn(UsableColumn u) {
        this.augColOption = true;
        this.usable.addFirst(u);
    }

    public int getTotalOptionCount() {
        return this.usable.size();
    }

    public int getFreeColOptionCount() {
        int n = this.usable.size();
        if (this.hasAugColOption()) {
            --n;
        }
        return n;
    }

    public boolean hasAugColOption() {
        return this.augColOption;
    }

    public UsableColumn getGeneralOption(int i) {
        UsableColumn opt = null;
        if (i < this.usable.size()) {
            opt = this.usable.get(i);
        }
        return opt;
    }

    public UsableColumn getFreeOption(int i) {
        if (!this.hasAugColOption()) {
            return this.getGeneralOption(i);
        }
        UsableColumn opt = null;
        if (i < this.usable.size() - 1) {
            opt = this.usable.get(i + 1);
        }
        return opt;
    }

    public boolean makeSoleRequest() {
        if (this.getTotalOptionCount() == 1) {
            UsableColumn u = this.getGeneralOption(0);
            u.makeRequest(this.rowNum);
            this.logger.log(Level.ALL, new Object[]{"Row", this.rowNum, "attempting to use column", u.getColNum()});
            return true;
        }
        return false;
    }
}

