/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.BadAssumptionsException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixBalancer;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixSolvingFailedException;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.AugmentationColumn;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.OptionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.OptionTable;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRow;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class PivotRowHandler {
    private final LogManager logger;
    private final Matrix mat;
    private final int m;
    private final int n;
    private final int augStart;
    private final Vector<Integer> remainingRows;
    private final Vector<Integer> pivotRows;
    private final int[][] codes;
    private List<Integer> AU;
    private List<Integer> CU;
    private OptionManager opman;

    public PivotRowHandler(Matrix mx, LogManager lm) {
        this.logger = lm;
        this.mat = mx;
        this.m = mx.getRowNum();
        this.n = mx.getColNum();
        this.augStart = this.n - mx.getNumAugCols();
        this.remainingRows = new Vector(this.m);
        for (int i = 0; i < this.m; ++i) {
            if (!this.mat.isPivotRow(i)) continue;
            this.remainingRows.add(new Integer(i));
        }
        this.pivotRows = new Vector<Integer>(this.remainingRows);
        this.codes = this.buildCodes();
        this.computeUnblockedColumns();
    }

    public int[] intListToArray(List<Integer> list) {
        int k = list.size();
        int[] a = new int[k];
        for (int l = 0; l < k; ++l) {
            a[l] = list.get(l);
        }
        return a;
    }

    private void computeUnblockedColumns() {
        Vector<Integer> auv = new Vector<Integer>();
        Vector<Integer> cuv = new Vector<Integer>();
        for (int j = 0; j < this.augStart; ++j) {
            boolean absolute = true;
            boolean conditional = true;
            for (int i = 0; i < this.m; ++i) {
                if (this.codes[i][j] == 1) {
                    absolute = false;
                    conditional = false;
                    break;
                }
                if (this.codes[i][j] != 2) continue;
                absolute = false;
            }
            if (absolute) {
                auv.add(new Integer(j));
                continue;
            }
            if (!conditional) continue;
            cuv.add(new Integer(j));
        }
        this.AU = auv;
        this.CU = cuv;
    }

    private int[][] buildCodes() {
        int[][] codes = new int[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                RationalFunction f = this.mat.getEntry(i, j);
                codes[i][j] = !f.isConstant() ? 2 : (f.isZero() ? 0 : (f.isPositive() ? 1 : 3));
            }
        }
        return codes;
    }

    public Set<AssumptionSet> handlePivotRows() throws MatrixSolvingFailedException {
        Set<AssumptionSet> asetset;
        AssumptionSet base = new AssumptionSet();
        base.addAll(this.firstPass());
        if (this.remainingRows.size() > 0) {
            Set<AssumptionSet> secondPassOptions = this.secondPass();
            for (AssumptionSet option : secondPassOptions) {
                option.addAll(base);
            }
            asetset = secondPassOptions;
        } else {
            asetset = new HashSet<AssumptionSet>();
            asetset.add(base);
        }
        return asetset;
    }

    private void discardRows(List<Integer> d) {
        this.remainingRows.removeAll(d);
    }

    private boolean FAar01(Integer r) {
        boolean ans = true;
        for (int j = this.augStart; j < this.n; ++j) {
            if (this.codes[r][j] < 2) continue;
            ans = false;
            break;
        }
        return ans;
    }

    private boolean EXpr3AU(Integer r) {
        boolean ans = false;
        for (int j = 0; j < this.augStart; ++j) {
            if (this.codes[r][j] != 3 || !this.AU.contains(j)) continue;
            ans = true;
            break;
        }
        return ans;
    }

    private boolean EXar3(Integer r) {
        boolean ans = false;
        for (int j = this.augStart; j < this.n; ++j) {
            if (this.codes[r][j] != 3) continue;
            ans = true;
            break;
        }
        return ans;
    }

    private boolean FApr01(Integer r) {
        boolean ans = true;
        for (int j = 0; j < this.augStart; ++j) {
            if (this.codes[r][j] < 2) continue;
            ans = false;
            break;
        }
        return ans;
    }

    private boolean FApr03(Integer r) {
        boolean ans = true;
        for (int j = 0; j < this.augStart; ++j) {
            if (this.codes[r][j] != 1 && this.codes[r][j] != 2) continue;
            ans = false;
            break;
        }
        return ans;
    }

    private AssumptionSet firstPass() throws MatrixSolvingFailedException {
        AssumptionSet aset = new AssumptionSet();
        Vector<Integer> discard = new Vector<Integer>();
        this.logger.log(Level.ALL, new Object[]{"Processing pivot rows:\n", this.remainingRows});
        for (Integer r : this.remainingRows) {
            if (this.FAar01(r)) {
                this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": all augmentation entries nonnegative constants."});
                discard.add(r);
                continue;
            }
            if (this.EXpr3AU(r)) {
                this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": contains a negative constant in an absolutely unblocked column."});
                discard.add(r);
                continue;
            }
            if (!this.FApr01(r)) continue;
            if (this.EXar3(r)) {
                this.logger.log(Level.ALL, new Object[]{"Matrix unsolvable! Row", r, "has a negative constant augmentation entry, but all post-pivot entries nonnegative constants."});
                throw new MatrixSolvingFailedException(MatrixSolvingFailedException.Reason.BadNonzeroAssumptions);
            }
            AssumptionSet nonneg = this.ar2nonneg(r);
            aset.addAll(nonneg);
            discard.add(r);
            this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ", and adding assumptions:", "all post-pivot entries are nonnegative constants, but no augmentation entries are negative", "constants. Therefore we add assumptions that all variable augmentation entries in row", r, "be nonnegative. Assumptions added:", "\n" + nonneg.toString()});
        }
        this.discardRows(discard);
        return aset;
    }

    public void firstPass(AssumptionManager amgr) throws BadAssumptionsException {
        Vector<Integer> discard = new Vector<Integer>();
        this.logger.log(Level.ALL, new Object[]{"Processing pivot rows:\n", this.remainingRows, "\nfor matrix:", "\n" + this.mat.toString()});
        for (Integer r : this.remainingRows) {
            if (this.FAar01(r) && this.FApr03(r)) {
                this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": all augmentation entries nonnegative constants,", "and all postpivots are nonpositive constants."});
                discard.add(r);
                continue;
            }
            if (this.EXpr3AU(r)) {
                this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": contains a negative constant in an absolutely unblocked column."});
                discard.add(r);
                continue;
            }
            if (!this.FApr01(r) || !this.EXar3(r)) continue;
            this.logger.log(Level.ALL, new Object[]{"Matrix unsolvable! Row", r, "has a negative constant augmentation entry, but all post-pivot entries nonnegative constants."});
            throw new BadAssumptionsException();
        }
        this.discardRows(discard);
        if (this.remainingRows.size() > 0) {
            this.logger.log(Level.ALL, new Object[]{"The rows still remaining to be processed are:\n", this.remainingRows});
        }
    }

    AssumptionSet ar2nonneg(Integer r) {
        AssumptionSet aset = new AssumptionSet();
        for (int j = this.augStart; j < this.n; ++j) {
            if (this.codes[r][j] != 2) continue;
            aset.add(new Assumption(this.mat.getEntry(r, j), Assumption.AssumptionType.NONNEGATIVE));
        }
        return aset;
    }

    private Set<AssumptionSet> secondPass() {
        this.logger.log(Level.ALL, new Object[]{"Second pass: processing remaining rows:", this.remainingRows});
        HashSet<AssumptionSet> asetset = new HashSet<AssumptionSet>();
        OptionTable optionTable = this.buildOptionTable();
        this.logger.log(Level.ALL, new Object[]{"Built option table:", "\n" + optionTable.toString()});
        AssumptionSet soleOpAset = optionTable.takeSoleOptions();
        if (optionTable.getRemainingRows().size() > 0) {
            this.logger.log(Level.FINEST, new Object[]{"Not all rows satisfied on second pass! Unsatisfied rows:", this.remainingRows});
        }
        asetset.add(soleOpAset);
        return asetset;
    }

    public void secondPass(AssumptionManager amgr) throws BadAssumptionsException {
        this.buildOptionManager();
        AssumptionSet aset = this.opman.getSoleOptionRowsAssumptions();
        if (aset.size() > 0) {
            this.logger.log(Level.ALL, new Object[]{"Some of the remaining rows have just a single option.", "Taking those options yields the new assumptions:\n", aset});
            amgr.addNecessaryAssumptions(aset);
        } else {
            this.logger.log(Level.ALL, new Object[]{"There were no remaining pivot rows having just a single option."});
        }
    }

    public void thirdPass(AssumptionManager amgr, MatrixBalancer balancer) throws BadAssumptionsException {
        if (this.opman == null || this.opman.numRemainingRows() == 0) {
            return;
        }
        boolean successful = false;
        AssumptionSet aset = this.opman.nextTry();
        while (aset != null) {
            this.logger.log(Level.ALL, new Object[]{"Trying to satisfy remaining pivot rows with set:\n", aset});
            AssumptionSet curr = new AssumptionSet(amgr.getCurrentAssumptionSet());
            this.logger.log(Level.ALL, new Object[]{"Current set is:\n", curr});
            boolean consistent = curr.addAll(aset);
            this.logger.log(Level.ALL, new Object[]{"Combined set is:\n", curr});
            if (!consistent) {
                this.logger.log(Level.ALL, new Object[]{"This set was inconsistent."});
            } else {
                this.logger.log(Level.ALL, new Object[]{"The set is at least not immediately contradictory.", "We ask Redlog if it is satisfiable."});
                HashMap<String, Rational> map = balancer.tryAssumptionSet(curr);
                if (map != null || balancer.redlogSaidTrue()) {
                    this.logger.log(Level.ALL, new Object[]{"The set is satisfiable!"});
                    successful = true;
                    amgr.setCurrentAssumptionSet(curr);
                    amgr.zeroSubsCurrent(aset);
                    break;
                }
            }
            aset = this.opman.nextTry();
        }
        if (!successful) {
            this.logger.log(Level.ALL, new Object[]{"There was no way to satisfy the remaining rows."});
            throw new BadAssumptionsException();
        }
    }

    private void buildOptionManager() {
        this.opman = new OptionManager(this.logger);
        for (Integer c : this.CU) {
            UsableColumn u = new UsableColumn(this.mat, c, this.logger);
            this.opman.addUsableColumn(u, c);
        }
        AugmentationColumn ac = new AugmentationColumn();
        for (Integer r : this.remainingRows) {
            if (this.EXar3(r)) continue;
            AssumptionSet aco = this.ar2nonneg(r);
            ac.addSet(r, aco);
        }
        this.opman.addUsableColumn(ac, -1);
        for (Integer r : this.remainingRows) {
            PivotRow pr = new PivotRow(r, this.logger);
            this.opman.addPivotRow(pr);
            for (Integer c : this.CU) {
                int a = this.codes[r][c];
                if (2 > a || a > 3) continue;
                UsableColumn u = this.opman.getUsableColumn(c);
                pr.addUsableColumn(u);
            }
            if (!ac.rowHasAugColOption(r)) continue;
            pr.addUsableColumn(ac);
        }
    }

    private OptionTable buildOptionTable() {
        int[][] table = new int[this.m][this.augStart + 1];
        for (Integer i : this.remainingRows) {
            for (Integer j : this.CU) {
                table[i.intValue()][j.intValue()] = this.codes[i][j];
            }
            table[i.intValue()][this.augStart] = this.EXar3(i) ? 5 : 4;
        }
        return new OptionTable(this, this.mat, table, this.remainingRows, this.CU, this.logger);
    }

    public String printCodes() {
        String s = "";
        for (int i = 0; i < this.m; ++i) {
            s = s + "[ ";
            for (int j = 0; j < this.n; ++j) {
                if (j > 0) {
                    s = s + " ";
                }
                if (j == this.augStart) {
                    s = s + "| ";
                }
                s = s + Integer.toString(this.codes[i][j]);
            }
            s = s + " ]\n";
        }
        return s;
    }

    public String printIntArray(int[] a) {
        String s = "";
        for (int k = 0; k < a.length; ++k) {
            s = s + " " + Integer.toString(a[k]);
        }
        return s;
    }

    public String toString() {
        String s = "";
        s = s + "Codes:\n" + this.printCodes();
        s = s + "Remaining rows:\n" + this.remainingRows.toString() + "\n";
        s = s + "Absolutely unblocked columns:\n" + this.AU.toString() + "\n";
        s = s + "Conditionally unblocked columns:\n" + this.CU.toString() + "\n";
        return s;
    }
}

