/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.BadAssumptionsException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixBalancer;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.AugmentationColumn;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.ColumnChoiceFrame;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.OptionManager2;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRow2;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.UsableColumn;

public class PivotRowHandler2 {
    private final MatrixBalancer mBalancer;
    private final AssumptionManager amgr;
    private final LogManager logger;
    private final Matrix mat;
    private final int m;
    private final int n;
    private final int augStart;
    private final Vector<Integer> remainingRows;
    private Vector<Integer> augChallengedRows;
    private final Vector<Integer> pivotRows;
    private final Vector<Integer> availableCols;
    private int[][] codes;
    private List<Integer> AU;
    private OptionManager2 opman;

    public PivotRowHandler2(Matrix mx, AssumptionManager am, MatrixBalancer mb, LogManager lm) {
        this.mBalancer = mb;
        this.amgr = am;
        this.logger = lm;
        this.mat = mx;
        this.m = mx.getRowNum();
        this.n = mx.getColNum();
        this.augStart = this.n - mx.getNumAugCols();
        this.remainingRows = new Vector(this.m);
        for (int i = 0; i < this.m; ++i) {
            if (!this.mat.isPivotRow(i)) continue;
            this.remainingRows.add(new Integer(i));
        }
        this.pivotRows = new Vector<Integer>(this.remainingRows);
        this.availableCols = new Vector(this.augStart);
        for (int j = 0; j < this.augStart; ++j) {
            this.availableCols.add(new Integer(j));
        }
        this.writeCodes();
        this.computeUnblockedColumns();
    }

    private void writeCodes() {
        this.codes = new int[this.m][this.n];
        AssumptionSet aset = this.amgr.getCurrentAssumptionSet();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                int c;
                RationalFunction f = this.mat.getEntry(i, j);
                if (f.isConstant()) {
                    if (f.isZero()) {
                        this.codes[i][j] = 0;
                        continue;
                    }
                    if (f.isPositive()) {
                        this.codes[i][j] = 1;
                        continue;
                    }
                    this.codes[i][j] = 3;
                    continue;
                }
                Assumption.AssumptionType at = aset.query(f);
                int[] lookUp = new int[]{2, 0, 1, 10, 3, 30, 31, 2};
                int b = at.getCode();
                this.codes[i][j] = c = lookUp[b];
            }
        }
        this.logger.log(Level.ALL, new Object[]{"Wrote code table:", "\n" + this.printCodes()});
    }

    private void computeUnblockedColumns() {
        Vector<Integer> auv = new Vector<Integer>();
        for (int j = 0; j < this.augStart; ++j) {
            boolean absolute = true;
            for (int i = 0; i < this.m; ++i) {
                int c = this.codes[i][j];
                if (c == 0 || c == 3 || c == 30) continue;
                absolute = false;
                break;
            }
            if (!absolute) continue;
            auv.add(new Integer(j));
        }
        this.AU = auv;
    }

    private void discardRows(List<Integer> d) {
        this.remainingRows.removeAll(d);
    }

    private void discardCols(List<Integer> c) {
        this.availableCols.removeAll(c);
    }

    public void firstPass() throws BadAssumptionsException {
        Vector<Integer> rowDiscard = new Vector<Integer>();
        Vector<Integer> colDiscard = new Vector<Integer>();
        this.logger.log(Level.ALL, new Object[]{"Processing pivot rows:\n", this.remainingRows, "\nfor matrix:", "\n" + this.mat.toString()});
        for (Integer r : this.remainingRows) {
            if (this.FAar0110(r) && this.FApr0330(r)) {
                this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": all augmentation entries nonnegative,", "and all postpivots nonpositive."});
                rowDiscard.add(r);
                continue;
            }
            if (this.EXpr3AU(r)) {
                this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": contains a negative constant in an absolutely unblocked column."});
                rowDiscard.add(r);
                continue;
            }
            if (!this.FApr0110(r)) continue;
            if (this.EXar3(r)) {
                this.logger.log(Level.ALL, new Object[]{"Matrix unsolvable! Row", r, "has a negative augmentation entry, but all post-pivot entries nonnegative."});
                throw new BadAssumptionsException();
            }
            AssumptionSet nonneg = this.arnonneg(r);
            Set<Integer> poscols = this.prposcols(r);
            rowDiscard.add(r);
            colDiscard.addAll(poscols);
            this.logger.log(Level.ALL, new Object[]{"Discarding row", r, ": all post-pivots are nonnegative.", "We assume all augmentation entries are nonnegative:\n", nonneg});
            if (poscols.size() > 0) {
                this.logger.log(Level.ALL, new Object[]{"We also discard all postpivot columns having positive entry in this row:\n", poscols});
            }
            this.amgr.addNecessaryAssumptions(nonneg);
            this.writeCodes();
        }
        this.discardRows(rowDiscard);
        this.discardCols(colDiscard);
        if (this.remainingRows.size() > 0) {
            this.logger.log(Level.ALL, new Object[]{"The rows still remaining to be processed are:\n", this.remainingRows});
            this.augChallengedRows = new Vector();
            for (Integer i : this.remainingRows) {
                if (this.FAar0110(i)) continue;
                this.augChallengedRows.add(i);
            }
        } else {
            this.augChallengedRows = new Vector();
        }
    }

    private boolean FAar0110(Integer r) {
        boolean ans = true;
        for (int j = this.augStart; j < this.n; ++j) {
            int c = this.codes[r][j];
            if (c < 2 || c == 10) continue;
            ans = false;
            break;
        }
        return ans;
    }

    private boolean FApr0330(Integer r) {
        boolean ans = true;
        boolean postpivot = false;
        for (int j = 0; j < this.augStart; ++j) {
            int c = this.codes[r][j];
            if (!postpivot && c == 1) {
                postpivot = true;
                continue;
            }
            if (!postpivot || c == 0 || c == 3 || c == 30) continue;
            ans = false;
            break;
        }
        return ans;
    }

    private boolean EXpr3AU(Integer r) {
        boolean ans = false;
        for (int j = 0; j < this.augStart; ++j) {
            if (this.codes[r][j] != 3 || !this.AU.contains(j)) continue;
            ans = true;
            break;
        }
        return ans;
    }

    private boolean EXar3(Integer r) {
        boolean ans = false;
        for (int j = this.augStart; j < this.n; ++j) {
            if (this.codes[r][j] != 3) continue;
            ans = true;
            break;
        }
        return ans;
    }

    private boolean FApr0110(Integer r) {
        boolean ans = true;
        for (int j = 0; j < this.augStart; ++j) {
            int c = this.codes[r][j];
            if (c < 2 || c == 10) continue;
            ans = false;
            break;
        }
        return ans;
    }

    Set<Integer> prposcols(Integer r) {
        HashSet<Integer> pc = new HashSet<Integer>();
        boolean postpivot = false;
        for (int j = 0; j < this.augStart; ++j) {
            int c = this.codes[r][j];
            if (c != 1) continue;
            if (postpivot) {
                pc.add(j);
                continue;
            }
            postpivot = true;
        }
        return pc;
    }

    AssumptionSet arnonneg(Integer r) {
        AssumptionSet aset = new AssumptionSet();
        for (int j = this.augStart; j < this.n; ++j) {
            int c = this.codes[r][j];
            RationalFunction f = this.mat.getEntry(r, j);
            if (c == 2) {
                aset.add(new Assumption(f, Assumption.AssumptionType.NONNEGATIVE));
                continue;
            }
            if (c == 30) {
                aset.add(new Assumption(f, Assumption.AssumptionType.ZERO));
                continue;
            }
            if (c != 31) continue;
            aset.add(new Assumption(f, Assumption.AssumptionType.POSITIVE));
        }
        return aset;
    }

    public void secondPass() throws BadAssumptionsException {
        AssumptionSet curr;
        AssumptionSet aset;
        if (this.augChallengedRows == null || this.augChallengedRows.size() == 0) {
            return;
        }
        this.buildOptionManager();
        this.opman.assignHeights();
        List<PivotRow2> noheight = this.opman.getRowsLackingHeights();
        if (noheight.size() > 0) {
            throw new BadAssumptionsException();
        }
        ColumnChoiceFrame ccf0 = this.opman.buildChoiceFrame(this.augChallengedRows, ColumnChoiceFrame.ChallengeType.AUGCOLUMN);
        Stack<ColumnChoiceFrame> cstack = new Stack<ColumnChoiceFrame>();
        cstack.push(ccf0);
        boolean successful = false;
        while (true) {
            if (cstack.empty()) {
                throw new BadAssumptionsException();
            }
            ColumnChoiceFrame ccf = (ColumnChoiceFrame)cstack.peek();
            if (!ccf.isComplete()) {
                if (ccf.hasNext()) {
                    ColumnChoiceFrame ccf1 = ccf.next();
                    cstack.push(ccf1);
                    continue;
                }
                cstack.pop();
                continue;
            }
            aset = ccf.getAssumptionSet();
            curr = new AssumptionSet(this.amgr.getCurrentAssumptionSet());
            boolean consistent = curr.addAll(aset);
            if (!consistent) {
                cstack.pop();
                continue;
            }
            HashMap<String, Rational> map = this.mBalancer.tryAssumptionSet(curr);
            if (map != null || this.mBalancer.redlogSaidTrue()) break;
        }
        this.logger.log(Level.ALL, new Object[]{"The set is satisfiable!"});
        successful = true;
        this.amgr.setCurrentAssumptionSet(curr);
        this.amgr.zeroSubsCurrent(aset);
        if (!successful) {
            this.logger.log(Level.ALL, new Object[]{"There was no way to satisfy the remaining rows."});
            throw new BadAssumptionsException();
        }
    }

    private void buildOptionManager() {
        this.opman = new OptionManager2(this, this.logger);
        for (Integer c : this.availableCols) {
            UsableColumn u = new UsableColumn(this.mat, c, this.logger);
            this.opman.addUsableColumn(u, c);
        }
        AugmentationColumn ac = new AugmentationColumn();
        for (Integer r : this.remainingRows) {
            if (this.EXar3(r)) continue;
            AssumptionSet aco = this.arnonneg(r);
            ac.addSet(r, aco);
        }
        this.opman.addUsableColumn(ac, -1);
        for (Integer r : this.remainingRows) {
            PivotRow2 pr = new PivotRow2(r, this.logger);
            this.opman.addPivotRow(pr);
            for (Integer c : this.availableCols) {
                int a = this.codes[r][c];
                if (2 > a || a == 10) continue;
                UsableColumn u = this.opman.getUsableColumn(c);
                pr.addFreeColumn(u);
            }
            if (!ac.rowHasAugColOption(r)) continue;
            pr.addAugColumn(ac);
        }
    }

    public List<Integer> getRowsWith1sInCol(int col) {
        Vector<Integer> ones = new Vector<Integer>();
        for (int i = 0; i < this.m; ++i) {
            if (this.codes[i][col] != 1) continue;
            ones.add(i);
        }
        return ones;
    }

    public String printCodes() {
        String s = "";
        for (int i = 0; i < this.m; ++i) {
            s = s + "[ ";
            for (int j = 0; j < this.n; ++j) {
                String t;
                if (j > 0) {
                    s = s + " ";
                }
                if (j == this.augStart) {
                    s = s + "| ";
                }
                if ((t = Integer.toString(this.codes[i][j])).length() == 1) {
                    s = s + " ";
                }
                s = s + t;
            }
            s = s + " ]\n";
        }
        return s;
    }

    public String toString() {
        String s = "";
        s = s + "Codes:\n" + this.printCodes();
        s = s + "Remaining rows:\n" + this.remainingRows.toString() + "\n";
        s = s + "Available columns:\n" + this.availableCols.toString() + "\n";
        s = s + "Absolutely unblocked columns:\n" + this.AU.toString() + "\n";
        return s;
    }
}

