/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh12;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.prh12.PivotRow2;

public class UsableColumn
implements Comparable<UsableColumn> {
    private LogManager logger;
    private int colNum;
    private List<RationalFunction> entries;
    private Set<Integer> requests;
    private int height = -1;
    private List<PivotRow2> rowsWith1s;

    public UsableColumn() {
    }

    public UsableColumn(Matrix mat, Integer j, LogManager lm) {
        this.logger = lm;
        int m = mat.getRowNum();
        this.entries = new Vector<RationalFunction>(m);
        for (int i = 0; i < m; ++i) {
            this.entries.add(mat.getEntry(i, j));
        }
        this.colNum = j;
        this.requests = new HashSet<Integer>();
        this.logger.log(Level.ALL, new Object[]{"Constructed UsableColumn with entries:\n", this.entries});
    }

    @Override
    public int compareTo(UsableColumn other) {
        return this.height - other.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getHeight() {
        return this.height;
    }

    public List<PivotRow2> getRowsWith1s() {
        return this.rowsWith1s;
    }

    boolean isAugCol() {
        return false;
    }

    public void setRowsWith1s(List<PivotRow2> rows) {
        this.rowsWith1s = rows;
        if (rows.size() == 0) {
            this.height = 0;
        }
    }

    boolean discoverHeight(int h) {
        boolean discovered = true;
        for (PivotRow2 pr : this.rowsWith1s) {
            int g = pr.getHeight();
            if (g >= 0) continue;
            discovered = false;
            break;
        }
        if (discovered) {
            this.height = h;
        }
        return discovered;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void clearRequests() {
        this.requests = new HashSet<Integer>();
    }

    public void makeRequest(Integer r) {
        this.requests.add(r);
    }

    void makeRequest(PivotRow2 pr) {
        this.requests.add(pr.getRowNum());
    }

    List<PivotRow2> query() {
        return this.rowsWith1s;
    }

    public AssumptionSet getRequestedAssumptions() {
        AssumptionSet aset = new AssumptionSet();
        if (this.requests.size() == 0) {
            return aset;
        }
        this.logger.log(Level.ALL, new Object[]{"Column", this.colNum, "forming assumptions as requested by rows:", this.requests, "."});
        for (int i = 0; i < this.entries.size(); ++i) {
            RationalFunction f = this.entries.get(i);
            if (f.isConstant()) continue;
            Assumption a = this.requests.contains(i) ? new Assumption(f, Assumption.AssumptionType.NEGATIVE) : new Assumption(f, Assumption.AssumptionType.NONPOSITIVE);
            this.logger.log(Level.ALL, new Object[]{"For variable entry", f, "added assumption", a, "."});
            aset.add(a);
        }
        return aset;
    }
}

