/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.balancer.prh3;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.Assumption;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionManager;
import org.sosy_lab.cpachecker.util.invariants.balancer.AssumptionSet;
import org.sosy_lab.cpachecker.util.invariants.balancer.BadAssumptionsException;
import org.sosy_lab.cpachecker.util.invariants.balancer.Matrix;
import org.sosy_lab.cpachecker.util.invariants.balancer.MatrixBalancer;
import org.sosy_lab.cpachecker.util.invariants.balancer.RationalFunction;
import org.sosy_lab.cpachecker.util.invariants.balancer.SubstitutionManager;

public class PivotRowHandler {
    private final MatrixBalancer mBalancer;
    private final AssumptionManager amgr;
    private final LogManager logger;
    private final Matrix matx;
    private int rowNum;
    private int colNum;
    private int augStart;

    public PivotRowHandler(Matrix m, AssumptionManager am, MatrixBalancer mb, LogManager lm) {
        this.mBalancer = mb;
        this.amgr = am;
        this.logger = lm;
        this.matx = m;
    }

    public void solve() throws BadAssumptionsException {
        this.logger.log(Level.ALL, new Object[]{"Solving pivot rows for matrix:", "\n" + this.matx.toString()});
        StackFrame F = this.buildInitialFrame();
        this.logger.log(Level.ALL, new Object[]{"Building initial frame."});
        if (F.hasAnImpossibleRow()) {
            this.logger.log(Level.ALL, new Object[]{"Frame has an impossible row. Aborting."});
            throw new BadAssumptionsException();
        }
        Stack<StackFrame> stack = new Stack<StackFrame>();
        this.logger.log(Level.ALL, new Object[]{"Pushing initial frame onto stack."});
        stack.push(F);
        block0: while (true) {
            if (stack.empty()) {
                this.logger.log(Level.ALL, new Object[]{"Stack empty. Aborting."});
                throw new BadAssumptionsException();
            }
            F = (StackFrame)stack.peek();
            this.logger.log(Level.ALL, new Object[]{"Considering top stack frame:\n", F});
            if (!F.hasChallenges()) {
                this.logger.log(Level.ALL, new Object[]{"Frame has no challenges left."});
                if (!F.aset.equals(this.amgr.getCurrentAssumptionSet())) {
                    if (F.aset.size() >= 2 && !this.mBalancer.isSatisfiable(F.aset)) {
                        this.logger.log(Level.ALL, new Object[]{"The assumption set was unsatisfiable.", "We pop the current frame off the stack."});
                        stack.pop();
                        continue;
                    }
                    this.logger.log(Level.ALL, new Object[]{"Matrix solvable."});
                    this.amgr.setCurrentAssumptionSet(F.aset);
                    this.amgr.zeroSubsCurrent(F.aset);
                    break;
                }
                this.logger.log(Level.ALL, new Object[]{"Matrix solvable."});
                this.logger.log(Level.ALL, new Object[]{"Assumption set is unchanged."});
                break;
            }
            this.logger.log(Level.ALL, new Object[]{"Frame has one or more challenges to meet."});
            while (true) {
                if (F.nextmv.empty()) {
                    this.logger.log(Level.ALL, new Object[]{"Frame has no moves left. Popping it off stack."});
                    stack.pop();
                    continue block0;
                }
                StackFrame E = F.buildNextFrame();
                if (E != null) {
                    this.logger.log(Level.ALL, new Object[]{"Frame construction succeeded. Pushing frame onto stack."});
                    stack.push(E);
                    continue block0;
                }
                this.logger.log(Level.ALL, new Object[]{"Frame construction failed."});
            }
            break;
        }
    }

    public String printCodes(int[][] codes) {
        String s = "";
        for (int i = 0; i < codes.length; ++i) {
            s = s + "[ ";
            for (int j = 0; j < codes[0].length; ++j) {
                String t;
                if (j > 0) {
                    s = s + " ";
                }
                if (j == this.augStart) {
                    s = s + "| ";
                }
                if ((t = Integer.toString(codes[i][j])).length() == 1) {
                    s = s + " ";
                }
                s = s + t;
            }
            s = s + " ]\n";
        }
        return s;
    }

    public String printRationalFunctions(RationalFunction[][] rfs) {
        Matrix m = new Matrix(rfs);
        m.setAugStart(this.augStart);
        return m.toString();
    }

    private StackFrame buildInitialFrame() {
        StackFrame F = new StackFrame();
        F.aset = new AssumptionSet(this.amgr.getCurrentAssumptionSet());
        F.entries = this.extractEntries();
        F.codes = this.computeCodes(F.entries, F.aset);
        List<Integer> immune = this.findImmuneRows(F.codes);
        F.deleteRows(immune);
        F.active = this.initialActivation(F.codes);
        F.depgr = new DependencyGraph();
        Map<Integer, List<Integer>> freeCols = this.findFreeCols(F.codes);
        if (freeCols.keySet().size() > 0) {
            F.active.addAll(freeCols.keySet());
            for (Integer c : freeCols.keySet()) {
                List<Integer> rows = freeCols.get(c);
                for (Integer r : rows) {
                    F.depgr.addForwardEdge(r, c);
                }
            }
        }
        F.computeChallenges();
        F.computeNextMoves();
        return F;
    }

    Map<Integer, List<Integer>> findFreeCols(int[][] codes) {
        HashMap<Integer, List<Integer>> fc = new HashMap<Integer, List<Integer>>();
        for (int j = 0; j < this.augStart; ++j) {
            Vector<Integer> threes = new Vector<Integer>();
            boolean all0330 = true;
            for (int i = 0; i < this.rowNum; ++i) {
                int c = codes[i][j];
                if (c == 3) {
                    threes.add(i);
                }
                if (c == 0 || c == 3 || c == 30) continue;
                all0330 = false;
                break;
            }
            if (!all0330) continue;
            fc.put(j, threes);
        }
        return fc;
    }

    private RationalFunction[][] extractEntries() {
        RationalFunction[][] given = this.matx.getEntries();
        int n = this.matx.getColNum();
        int a = n - this.matx.getNumAugCols();
        int p = this.matx.getNumPivotRows();
        RationalFunction[][] entries = new RationalFunction[p][n - p];
        for (int i = 0; i < p; ++i) {
            for (int j = p; j < n; ++j) {
                entries[i][j - p] = j < a ? given[i][j] : RationalFunction.makeNegative(given[i][j]);
            }
        }
        this.rowNum = p;
        this.colNum = n - p;
        this.augStart = a - p;
        return entries;
    }

    private int[][] computeCodes(RationalFunction[][] entries, AssumptionSet aset) {
        int m = entries.length;
        if (m == 0) {
            return new int[0][0];
        }
        int n = entries[0].length;
        if (n == 0) {
            return new int[0][0];
        }
        int[][] codes = new int[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int c;
                RationalFunction f = entries[i][j];
                if (f.isConstant()) {
                    if (f.isZero()) {
                        codes[i][j] = 0;
                        continue;
                    }
                    if (f.isPositive()) {
                        codes[i][j] = 1;
                        continue;
                    }
                    codes[i][j] = 3;
                    continue;
                }
                Assumption.AssumptionType at = aset.query(f);
                int[] lookUp = new int[]{2, 0, 1, 10, 3, 30, 31, 2};
                int b = at.getCode();
                codes[i][j] = c = lookUp[b];
            }
        }
        return codes;
    }

    private List<Integer> findImmuneRows(int[][] codes) {
        Vector<Integer> immune = new Vector<Integer>();
        for (int i = 0; i < codes.length; ++i) {
            boolean imm = true;
            for (int j = 0; j < codes[i].length; ++j) {
                int c = codes[i][j];
                if (c == 0 || c == 3 || c == 30) continue;
                imm = false;
                break;
            }
            if (!imm) continue;
            immune.add(i);
        }
        return immune;
    }

    private List<Integer> initialActivation(int[][] codes) {
        Vector<Integer> active = new Vector<Integer>();
        for (int j = this.augStart; j < this.colNum; ++j) {
            active.add(j);
        }
        return active;
    }

    private class DependencyGraph {
        private Map<Integer, Integer> forward = new HashMap<Integer, Integer>();
        private Map<Integer, Map<Integer, Assumption>> back = new HashMap<Integer, Map<Integer, Assumption>>();

        DependencyGraph() {
        }

        public String toString() {
            String s = "";
            s = s + "Forward (rows to columns):\n";
            s = s + "--------------------------\n";
            for (Integer r : this.forward.keySet()) {
                Integer c = this.forward.get(r);
                s = s + "r" + r.toString() + " --> c" + c.toString() + "\n";
            }
            if (this.forward.size() == 0) {
                s = s + "none";
            }
            s = s + "\n";
            s = s + "Back (columns to rows):\n";
            s = s + "-----------------------\n";
            for (Integer c : this.back.keySet()) {
                Map<Integer, Assumption> edges = this.back.get(c);
                for (Integer r : edges.keySet()) {
                    s = s + "c" + c.toString() + " --> r" + r.toString() + ", ";
                    Assumption a = edges.get(r);
                    if (a == null) {
                        s = s + "unbreakable\n";
                        continue;
                    }
                    s = s + "broken by " + a.toString() + "\n";
                }
                s = s + "\n";
            }
            if (this.back.size() == 0) {
                s = s + "none";
            }
            return s;
        }

        boolean hasForwardEdge(Integer r) {
            return this.forward.containsKey(r);
        }

        Map<Integer, Integer> getForwardEdges() {
            return this.forward;
        }

        void addForwardEdge(Integer row, Integer col) {
            this.forward.put(row, col);
        }

        void addBackEdge(Integer col, Integer row, Assumption breaker) {
            Map<Object, Object> edges;
            if (!this.back.containsKey(col)) {
                edges = new HashMap();
                this.back.put(col, edges);
            } else {
                edges = this.back.get(col);
            }
            edges.put(row, breaker);
        }

        List<Assumption> findRowtoRowLoop(Integer i) {
            return this.findRowtoRowPath(i, i);
        }

        List<Assumption> findRowtoRowPath(Integer i, Integer k) {
            if (!this.forward.containsKey(i)) {
                return null;
            }
            int col = this.forward.get(i);
            Map<Integer, Assumption> backedges = this.back.get(col);
            if (backedges == null) {
                return null;
            }
            Vector<Assumption> ri2rk = null;
            if (backedges.containsKey(k)) {
                ri2rk = new Vector<Assumption>();
                Assumption a = backedges.get(k);
                if (a != null) {
                    ri2rk.add(a);
                }
            } else {
                List<Assumption> rj2rk = null;
                for (Integer j : backedges.keySet()) {
                    rj2rk = this.findRowtoRowPath(j, k);
                    if (rj2rk == null) continue;
                    Assumption a = backedges.get(j);
                    if (a == null) break;
                    rj2rk.add(a);
                    break;
                }
                ri2rk = rj2rk;
            }
            return ri2rk;
        }
    }

    private class ForwardEdge {
        int row;
        int col;

        ForwardEdge(int r, int c) {
            this.row = r;
            this.col = c;
        }
    }

    private class Move {
        AssumptionSet newaset;
        Integer newcol;
        ForwardEdge newedge;

        private Move() {
        }

        public String toString() {
            String s = "";
            s = s + "(";
            s = this.newaset == null ? s + "--" : s + this.newaset.toString();
            s = s + ", ";
            s = this.newcol == null ? s + "--" : s + this.newcol.toString();
            s = s + ", ";
            s = this.newedge == null ? s + "--" : s + "r" + Integer.toString(this.newedge.row) + " --> c" + Integer.toString(this.newedge.col);
            s = s + ")\n";
            return s;
        }
    }

    private class StackFrame {
        AssumptionSet aset;
        RationalFunction[][] entries;
        int[][] codes;
        List<Integer> active;
        DependencyGraph depgr;
        List<Integer> pchal;
        List<Integer> qchal;
        Stack<Move> nextmv;

        private StackFrame() {
        }

        String writeActiveStars(List<Integer> act) {
            String s = "";
            for (int j = 0; j < PivotRowHandler.this.colNum; ++j) {
                if (j == 0) {
                    s = s + " ";
                }
                if (j == PivotRowHandler.this.augStart) {
                    s = s + "  ";
                }
                s = s + "  ";
                s = act.contains(j) ? s + "*" : s + " ";
            }
            return s;
        }

        public String toString() {
            String s = "";
            s = s + "Frame\n";
            s = s + "=======\n";
            s = s + "Assumption Set: " + this.aset.toString() + "\n\n";
            s = s + "Entries:\n" + PivotRowHandler.this.printRationalFunctions(this.entries) + "\n\n";
            s = s + "Codes and active columns:\n" + PivotRowHandler.this.printCodes(this.codes);
            s = s + this.writeActiveStars(this.active) + "\n\n";
            s = s + "Dependency graph:\n";
            s = s + this.depgr.toString() + "\n\n";
            s = s + "P-challenges: " + this.pchal.toString() + "\n";
            s = s + "Q-challenges: " + this.qchal.toString() + "\n";
            s = s + "Next Moves:\n";
            s = s + this.nextmv.toString();
            return s;
        }

        void deleteRows(List<Integer> rows) {
        }

        boolean hasAnImpossibleRow() {
            boolean ans = false;
            for (int i = 0; i < this.codes.length; ++i) {
                boolean all0110 = true;
                boolean hasActive1 = false;
                for (int j = 0; j < this.codes[i].length; ++j) {
                    int c = this.codes[i][j];
                    if (c == 1 && this.active.contains(j)) {
                        hasActive1 = true;
                    }
                    if (c == 0 || c == 1 || c == 10) continue;
                    all0110 = false;
                    break;
                }
                if (!all0110 || !hasActive1) continue;
                ans = true;
                break;
            }
            return ans;
        }

        boolean hasChallenges() {
            return this.pchal.size() > 0 || this.qchal.size() > 0;
        }

        void computeChallenges() {
            this.pchal = new Vector<Integer>();
            this.qchal = new Vector<Integer>();
            block0: for (int r = 0; r < this.codes.length; ++r) {
                if (this.depgr.hasForwardEdge(r)) continue;
                for (Integer c : this.active) {
                    int code = this.codes[r][c];
                    if (code == 1) {
                        this.pchal.add(r);
                        continue block0;
                    }
                    if (code != 10 && code != 2 && code != 31) continue;
                    this.qchal.add(r);
                    continue block0;
                }
            }
        }

        void computeNextMoves() {
            Assumption a;
            Assumption.AssumptionType atype;
            RationalFunction f;
            this.nextmv = new Stack();
            Vector<Integer> PUQ = new Vector<Integer>(this.pchal);
            PUQ.addAll(this.qchal);
            for (Integer r : PUQ) {
                for (int j = 0; j < PivotRowHandler.this.augStart; ++j) {
                    int code = this.codes[r][j];
                    if (code != 3 && code != 2 && code != 30 && code != 31) continue;
                    Move move = new Move();
                    if (code == 3) {
                        move.newaset = null;
                    } else {
                        f = this.entries[r][j];
                        atype = Assumption.AssumptionType.NEGATIVE;
                        a = new Assumption(f, atype);
                        move.newaset = new AssumptionSet();
                        move.newaset.add(a);
                    }
                    move.newcol = !this.active.contains(j) ? Integer.valueOf(j) : null;
                    move.newedge = new ForwardEdge(r, j);
                    this.nextmv.push(move);
                }
            }
            for (Integer r : this.qchal) {
                Move move = new Move();
                move.newaset = new AssumptionSet();
                for (int j = 0; j < PivotRowHandler.this.colNum; ++j) {
                    int code;
                    if (!this.active.contains(j) || (code = this.codes[r][j]) != 2 && code != 10 && code != 31) continue;
                    f = this.entries[r][j];
                    atype = null;
                    switch (code) {
                        case 2: {
                            atype = Assumption.AssumptionType.NONPOSITIVE;
                            break;
                        }
                        case 10: {
                            atype = Assumption.AssumptionType.ZERO;
                            break;
                        }
                        case 31: {
                            atype = Assumption.AssumptionType.NEGATIVE;
                        }
                    }
                    a = new Assumption(f, atype);
                    move.newaset.add(a);
                }
                this.nextmv.push(move);
            }
        }

        StackFrame buildNextFrame() {
            if (this.nextmv.empty()) {
                return null;
            }
            Move M = this.nextmv.pop();
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Attempting to build the next frame, using move:\n", M});
            StackFrame E = new StackFrame();
            E.aset = new AssumptionSet(this.aset);
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Copied last frame's assumption set", this.aset});
            if (M.newaset != null) {
                boolean consistent = E.aset.addAll(M.newaset);
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Added new assumptions", M.newaset});
                if (!consistent) {
                    PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"New assumption set is immediately contadictory. Abort."});
                    return null;
                }
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"New assumption set:", E.aset});
            }
            SubstitutionManager subman = new SubstitutionManager(E.aset, PivotRowHandler.this.logger);
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Copying rational function entries, and applying any substitutions."});
            E.entries = subman.applyAll(this.entries);
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"New entries:", "\n" + PivotRowHandler.this.printRationalFunctions(E.entries)});
            E.active = new Vector<Integer>(this.active);
            if (M.newcol != null) {
                E.active.add(M.newcol);
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Activating column", M.newcol});
            }
            E.codes = PivotRowHandler.this.computeCodes(E.entries, E.aset);
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"New codes and active columns:", "\n" + PivotRowHandler.this.printCodes(E.codes) + "\n" + this.writeActiveStars(E.active)});
            if (E.hasAnImpossibleRow()) {
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"The new frame has an impossible row. Aborting."});
                return null;
            }
            E.depgr = new DependencyGraph();
            for (Integer c : E.active) {
                if (c >= PivotRowHandler.this.augStart) continue;
                for (int i = 0; i < PivotRowHandler.this.rowNum; ++i) {
                    Assumption a;
                    int code = E.codes[i][c];
                    if (code != 1 && code != 10 && code != 2 && code != 31) continue;
                    if (code == 1) {
                        a = null;
                    } else {
                        RationalFunction f = E.entries[i][c];
                        Assumption.AssumptionType atype = null;
                        switch (code) {
                            case 10: {
                                atype = Assumption.AssumptionType.ZERO;
                                break;
                            }
                            case 2: {
                                atype = Assumption.AssumptionType.NONPOSITIVE;
                                break;
                            }
                            case 31: {
                                atype = Assumption.AssumptionType.NEGATIVE;
                            }
                        }
                        a = new Assumption(f, atype);
                    }
                    E.depgr.addBackEdge(c, i, a);
                }
            }
            Map<Integer, Integer> forward = this.depgr.getForwardEdges();
            for (Integer r : forward.keySet()) {
                E.depgr.addForwardEdge(r, forward.get(r));
            }
            if (M.newedge != null) {
                int r = M.newedge.row;
                int c = M.newedge.col;
                E.depgr.addForwardEdge(r, c);
            }
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Computed new dependency graph:\n", E.depgr});
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Checking for cycles in new dependency graph."});
            for (int i = 0; i < PivotRowHandler.this.rowNum; ++i) {
                List<Assumption> breakers = E.depgr.findRowtoRowLoop(i);
                if (breakers == null) continue;
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Found cycle based at row", i});
                if (breakers.size() == 0) {
                    PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Cycle is unbreakable. Aborting frame construction."});
                    return null;
                }
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Loop can be broken by assumptions:", breakers});
                for (Assumption a : breakers) {
                    Assumption.AssumptionRelation rel = E.aset.matchAgainst(a);
                    if (rel == Assumption.AssumptionRelation.CONTRADICTS) continue;
                    PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Assumption", a, "appears consistent with new frame's assumption set.", "We add the assumption to the move, push the move back on the stack, and abort.", "Next construction attempt will use the augmented move."});
                    M.newaset.add(a);
                    this.nextmv.push(M);
                    return null;
                }
                PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"None of these assumptions is consistent with the new frame's assumption set.", "Aborting frame construction."});
                return null;
            }
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"No cycles found."});
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"Computing challenges and next moves for new frame."});
            E.computeChallenges();
            E.computeNextMoves();
            PivotRowHandler.this.logger.log(Level.ALL, new Object[]{"New frame computation successful."});
            return E;
        }
    }
}

