/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.choosers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.balancer.Template;
import org.sosy_lab.cpachecker.util.invariants.choosers.TemplateChooser;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateDisjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNegation;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSumList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TermForm;

public class SingleLoopTemplateChooser
implements TemplateChooser {
    private final LogManager logger;
    private final TemplateFormula entryFormula;
    private final TemplateFormula loopFormula;
    private final TemplateFormula loopFormulaHead;
    private final TemplateFormula loopFormulaTail;
    private final TemplateFormula exitFormula;
    private final TemplateFormula exitFormulaHead;
    private final TemplateFormula exitFormulaTail;
    private final TemplateChooserStrategy strategy;

    public SingleLoopTemplateChooser(LogManager logger, TemplateFormula entryFormula, TemplateFormula loopFormula, TemplateFormula loopFormulaHead, TemplateFormula loopFormulaTail, TemplateFormula exitFormula, TemplateFormula exitFormulaHead, TemplateFormula exitFormulaTail) {
        this.logger = logger;
        this.entryFormula = entryFormula;
        this.loopFormula = loopFormula;
        this.loopFormulaHead = loopFormulaHead;
        this.loopFormulaTail = loopFormulaTail;
        this.exitFormula = exitFormula;
        this.exitFormulaHead = exitFormulaHead;
        this.exitFormulaTail = exitFormulaTail;
        this.strategy = new TemplateChooserStrategy();
    }

    @Override
    public Template chooseNextTemplate() {
        Template choice = null;
        boolean another = this.strategy.advance();
        if (!another) {
            return null;
        }
        TemplateChooserMethod method = this.strategy.getMethod();
        InfixReln relation = this.strategy.getRelation();
        this.logger.log(Level.ALL, new Object[]{"Template choice method:", method, "Template infix relation:", relation});
        switch (method) {
            case TOPLEVELTERMFORMS: {
                choice = this.topLevelTermFormsMethod(relation);
                break;
            }
            case EXITHEADNEGATION: {
                choice = this.exitHeadNegationMethod(relation);
                break;
            }
            case EXITTAILCOMB: {
                choice = this.exitTailIndexOneFreeCombMethod(relation);
                break;
            }
            case LOOPVARSFREECOMB: {
                choice = this.loopVarsFreeCombMethod(relation);
                break;
            }
            case LOOPVARSFREECOMBANDLOOPHEADFREECOMB: {
                choice = this.loopVarsAndHeadFreeCombMethod(relation);
            }
        }
        return choice;
    }

    private Template loopVarsAndHeadFreeCombMethod(InfixReln relation) {
        Template choice = null;
        Set<TemplateTerm> headVars = this.getUnindexedVarsAsTerms(this.loopFormulaHead);
        Set<TemplateTerm> tailVars = this.getUnindexedVarsAsTerms(this.loopFormulaTail);
        Vector<TemplateTerm> headTerms = new Vector<TemplateTerm>();
        Vector<TemplateTerm> tailTerms = new Vector<TemplateTerm>();
        headTerms.addAll(headVars);
        tailTerms.addAll(tailVars);
        TemplateSum headLHS = TemplateSum.freshParamLinComb(headTerms);
        TemplateSum tailLHS = TemplateSum.freshParamLinComb(tailTerms);
        TemplateVariable param = TemplateTerm.getNextFreshParameter();
        TemplateTerm headRHS = new TemplateTerm();
        headRHS.setParameter(param);
        param = TemplateTerm.getNextFreshParameter();
        TemplateTerm tailRHS = new TemplateTerm();
        tailRHS.setParameter(param);
        TemplateConstraint headFormula = new TemplateConstraint(headLHS, InfixReln.LEQ, headRHS);
        TemplateConstraint tailFormula = new TemplateConstraint(tailLHS, InfixReln.EQUAL, tailRHS);
        TemplateBoolean formula = TemplateConjunction.conjoin(headFormula, tailFormula);
        Set<TemplateVariable> topLevelLHSparams = headLHS.getTopLevelParameters();
        topLevelLHSparams.addAll(tailLHS.getTopLevelParameters());
        TemplateFormula nzpc = this.makeBasicParamClause(topLevelLHSparams);
        choice = new Template(formula, nzpc);
        return choice;
    }

    private Template loopVarsFreeCombMethod(InfixReln relation) {
        Template choice = null;
        Set<TemplateTerm> loopVars = this.getUnindexedVarsAsTerms(this.loopFormula);
        Map<String, Integer> uifNA = this.getTopLevelUIFnamesAndArities(this.loopFormula);
        Vector<TemplateTerm> templateTerms = new Vector<TemplateTerm>();
        for (String name : uifNA.keySet()) {
            int arity = uifNA.get(name);
            TemplateSum[] args = new TemplateSum[arity];
            for (int i = 0; i < arity; ++i) {
                args[i] = TemplateSum.freshParamLinComb(loopVars);
            }
            TemplateUIF uif = new TemplateUIF(name, new TemplateSumList(args));
            templateTerms.add(new TemplateTerm(uif));
        }
        templateTerms.addAll(loopVars);
        TemplateSum LHS = TemplateSum.freshParamLinComb(templateTerms);
        TemplateVariable param = TemplateTerm.getNextFreshParameter();
        TemplateTerm RHS = new TemplateTerm();
        RHS.setParameter(param);
        TemplateConstraint formula = new TemplateConstraint(LHS, relation, RHS);
        Set<TemplateVariable> topLevelLHSparams = LHS.getTopLevelParameters();
        TemplateFormula nzpc = this.makeBasicParamClause(topLevelLHSparams);
        choice = new Template(formula, nzpc);
        return choice;
    }

    private Set<TemplateTerm> getUnindexedVarsAsTerms(TemplateFormula f) {
        Set<TemplateVariable> vars = f.getAllVariables();
        HashSet<String> varNames = new HashSet<String>();
        for (TemplateVariable v : vars) {
            varNames.add(v.getName());
        }
        HashSet<TemplateTerm> terms = new HashSet<TemplateTerm>();
        for (String name : varNames) {
            TemplateTerm t = new TemplateTerm();
            t.setVariable(new TemplateVariable(name));
            terms.add(t);
        }
        return terms;
    }

    private Map<String, Integer> getTopLevelUIFnamesAndArities(TemplateFormula f) {
        Set<TemplateUIF> topLevelUIFs = f.getAllTopLevelUIFs();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (TemplateUIF u : topLevelUIFs) {
            String name = u.getName();
            Integer arity = new Integer(u.getArity());
            map.put(name, arity);
        }
        return map;
    }

    private Template topLevelTermFormsMethod(InfixReln relation) {
        Template choice = null;
        Set<TermForm> forms = this.entryFormula.getTopLevelTermForms();
        forms.addAll(this.loopFormula.getTopLevelTermForms());
        forms.addAll(this.exitFormula.getTopLevelTermForms());
        Vector<TemplateTerm> terms = new Vector<TemplateTerm>();
        for (TermForm f : forms) {
            terms.add(f.getTemplate());
        }
        TemplateSum LHS = new TemplateSum(terms);
        TemplateTerm RHS = this.makeRHSParameter();
        TemplateConstraint formula = new TemplateConstraint(LHS, relation, RHS);
        Set<TemplateVariable> topLevelLHSparams = LHS.getTopLevelParameters();
        TemplateFormula nzpc = this.makeBasicParamClause(topLevelLHSparams);
        choice = new Template(formula, nzpc);
        return choice;
    }

    private TemplateTerm makeRHSParameter() {
        TemplateVariable param = TemplateTerm.getNextFreshParameter();
        TemplateTerm RHS = new TemplateTerm();
        RHS.setParameter(param);
        return RHS;
    }

    private Template exitHeadNegationMethod(InfixReln relation) {
        TemplateBoolean head = (TemplateBoolean)this.exitFormulaHead;
        head = head.logicNegate();
        TemplateDisjunction headD = (TemplateDisjunction)head.makeSDNF();
        Vector<TemplateBoolean> disjuncts = headD.getDisjuncts();
        TemplateBoolean temp = (TemplateBoolean)disjuncts.get(0);
        Set<TemplateVariable> tllhsp = temp.getTopLevelLHSParameters();
        TemplateFormula nzpc = this.makeBasicParamClause(tllhsp);
        Template t = new Template(temp, nzpc);
        return t;
    }

    private Template exitTailIndexOneFreeCombMethod(InfixReln relation) {
        Set<TemplateTerm> terms = this.exitFormulaTail.getTopLevelTerms();
        HashSet<TemplateTerm> indexone = new HashSet<TemplateTerm>();
        for (TemplateTerm t : terms) {
            int n = t.getMaxIndex();
            if (n != 1) continue;
            indexone.add(t);
        }
        TemplateSum LHS = TemplateSum.freshParamLinComb(indexone);
        TemplateTerm RHS = this.makeRHSParameter();
        TemplateConstraint formula = new TemplateConstraint(LHS, relation, RHS);
        ((TemplateFormula)formula).unindex();
        Set<TemplateVariable> topLevelLHSparams = LHS.getTopLevelParameters();
        TemplateFormula nzpc = this.makeBasicParamClause(topLevelLHSparams);
        Template choice = new Template(formula, nzpc);
        return choice;
    }

    private TemplateFormula makeBasicParamClause(Set<TemplateVariable> params) {
        Vector<TemplateBoolean> conjuncts = new Vector<TemplateBoolean>();
        for (TemplateVariable p : params) {
            TemplateConstraint c = new TemplateConstraint(p, InfixReln.EQUAL);
            conjuncts.add(c);
        }
        TemplateConjunction conj = new TemplateConjunction(conjuncts);
        TemplateBoolean neg = TemplateNegation.negate(conj);
        return neg;
    }

    private class TemplateChooserStrategy {
        private TemplateChooserMethod[] methods = new TemplateChooserMethod[]{TemplateChooserMethod.EXITTAILCOMB, TemplateChooserMethod.EXITHEADNEGATION, TemplateChooserMethod.LOOPVARSFREECOMB, TemplateChooserMethod.TOPLEVELTERMFORMS};
        private InfixReln[] relns = new InfixReln[]{InfixReln.EQUAL, InfixReln.LT, InfixReln.LEQ};
        private int methodIndex = 0;
        private int relnIndex = -1;

        private TemplateChooserStrategy() {
        }

        public boolean advance() {
            if (this.relnIndex >= this.relns.length - 1) {
                this.relnIndex = 0;
                ++this.methodIndex;
            } else {
                ++this.relnIndex;
            }
            return this.methodIndex < this.methods.length;
        }

        public TemplateChooserMethod getMethod() {
            TemplateChooserMethod m = this.methods[0];
            if (this.methodIndex < this.methods.length) {
                m = this.methods[this.methodIndex];
            }
            return m;
        }

        public InfixReln getRelation() {
            InfixReln r = this.relns[0];
            if (this.relnIndex < this.relns.length) {
                r = this.relns[this.relnIndex];
            }
            return r;
        }
    }

    private static enum TemplateChooserMethod {
        TOPLEVELTERMFORMS,
        LOOPVARSFREECOMB,
        LOOPVARSFREECOMBANDLOOPHEADFREECOMB,
        EXITHEADNEGATION,
        EXITTAILCOMB;

    }
}

