/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.redlog;

import java.util.HashSet;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.redlog.Substitution;
import org.sosy_lab.cpachecker.util.invariants.redlog.TreeReader;

public class ParameterAssignment {
    private String parameter = null;
    private PAType patype = null;
    private Rational value = null;
    private HashSet<String> vars = null;

    public ParameterAssignment(String p) {
        this.parameter = p;
        this.patype = PAType.NONE;
        try {
            this.value = new Rational(0, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ParameterAssignment(String p, IASTExpression RHS) {
        Rational R;
        this.parameter = p;
        this.patype = PAType.CONST;
        Substitution S = new Substitution();
        this.value = R = TreeReader.evaluate(RHS, S);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getParameter() {
        return this.parameter;
    }

    public Rational getValue() {
        return this.value;
    }

    public PAType getType() {
        return this.patype;
    }

    public HashSet<String> getVars() {
        return this.vars;
    }

    public static enum PAType {
        NONE,
        CONST,
        VAR;

    }
}

