/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.redlog;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cfa.ast.IASTExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.redlog.EAPair;
import org.sosy_lab.cpachecker.util.invariants.redlog.Equation;
import org.sosy_lab.cpachecker.util.invariants.redlog.ParameterAssignment;

public class ParameterManager {
    private final EAPair EAP;
    private String[] params = new String[0];
    private HashMap<String, ParameterAssignment> PAmap = null;

    public ParameterManager(EAPair EAP) {
        this.EAP = EAP;
        this.PAmap = new HashMap();
    }

    public ParameterManager(EAPair EAP, String[] params) {
        this.EAP = EAP;
        this.PAmap = new HashMap();
        this.params = params;
        this.makePAs();
    }

    public ParameterManager(EAPair EAP, Collection<String> pParams) {
        this.EAP = EAP;
        this.PAmap = new HashMap();
        this.params = new String[pParams.size()];
        int i = 0;
        Iterator<String> i$ = pParams.iterator();
        while (i$.hasNext()) {
            String s;
            this.params[i] = s = i$.next();
            ++i;
        }
        this.makePAs();
    }

    public void setParameters(String[] params) {
        this.params = params;
    }

    public ParameterAssignment getParameterAssignment(String param) {
        return this.PAmap.get(param);
    }

    public HashMap<String, Rational> getRationalValueMap() {
        HashMap<String, Rational> map = new HashMap<String, Rational>();
        if (this.PAmap != null) {
            for (int i = 0; i < this.params.length; ++i) {
                String a = this.params[i];
                Rational R = this.PAmap.get(a).getValue();
                map.put(a, R);
            }
        }
        return map;
    }

    public HashSet<String> getAllVars() {
        HashSet<String> vars = new HashSet<String>();
        for (ParameterAssignment PA : this.PAmap.values()) {
            HashSet<String> pavars = PA.getVars();
            vars.addAll(pavars);
        }
        return vars;
    }

    public boolean allAreConstant() {
        ParameterAssignment PA;
        boolean ans = true;
        if (this.PAmap == null) {
            ans = false;
        }
        int n = this.params.length;
        for (int i = 0; ans && i < n; ans &= PA.hasValue(), ++i) {
            String a = this.params[i];
            PA = this.PAmap.get(a);
        }
        return ans;
    }

    public void makePAs() {
        HashSet<String> waitlist = new HashSet<String>();
        for (int i = 0; i < this.params.length; ++i) {
            waitlist.add(this.params[i]);
        }
        Iterator<Equation> eqnit = this.EAP.equationIterator();
        while (eqnit.hasNext()) {
            Equation eqn = eqnit.next();
            IASTExpression LHS = eqn.getLeftHandSide();
            IASTIdExpression ID = (IASTIdExpression)LHS;
            String a = ID.getName().toString();
            if (!waitlist.contains(a)) continue;
            IASTExpression RHS = eqn.getRightHandSide();
            ParameterAssignment PA = new ParameterAssignment(a, RHS);
            this.PAmap.put(a, PA);
            waitlist.remove(a);
        }
        for (String p : waitlist) {
            ParameterAssignment dummyPA = new ParameterAssignment(p);
            this.PAmap.put(p, dummyPA);
        }
    }
}

