/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.redlog;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.LogManager;
import org.sosy_lab.common.ProcessExecutor;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.util.invariants.redlog.Condition;
import org.sosy_lab.cpachecker.util.invariants.redlog.EAPair;
import org.sosy_lab.cpachecker.util.invariants.redlog.EliminationAnswer;
import org.sosy_lab.cpachecker.util.invariants.redlog.Equation;
import org.sosy_lab.cpachecker.util.invariants.redlog.Solution;

public class RedlogInterface {
    private final CParser parser;
    private final LogManager logger;

    public RedlogInterface(LogManager pLogger) {
        this.logger = pLogger;
        this.parser = CParser.Factory.getParser(this.logger, CParser.Factory.getDefaultOptions());
    }

    public EliminationAnswer rlqea(String phi) {
        List output = null;
        String wrapper_path = "src/org/sosy_lab/cpachecker/util/invariants/redlog/rlwrapper.py";
        try {
            ProcessExecutor redlog = new ProcessExecutor(this.logger, RuntimeException.class, new String[]{wrapper_path});
            redlog.println(phi);
            redlog.sendEOF();
            redlog.join();
            output = redlog.getOutput();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        this.logger.log(Level.ALL, new Object[]{"Redlog output:\n", output});
        EliminationAnswer EA = null;
        if (output.size() > 0 && !((String)output.get(0)).equals("segfault")) {
            EA = this.build(output);
        }
        return EA;
    }

    public EliminationAnswer build(List<String> lines) {
        Iterator<String> L = lines.iterator();
        String line = null;
        EliminationAnswer EA = null;
        EAPair EAP = null;
        Condition C = null;
        Solution S = null;
        Equation E = null;
        String formula = "";
        while (L.hasNext()) {
            line = L.next();
            if (line.equals("~begin-list")) {
                EA = new EliminationAnswer();
                continue;
            }
            if (line.equals("~begin-pair")) {
                EAP = new EAPair();
                continue;
            }
            if (line.equals("~begin-cond")) {
                C = new Condition();
                continue;
            }
            if (line.equals("~end-cond")) {
                if (formula.equals("false")) {
                    EA = new EliminationAnswer(false);
                    break;
                }
                if (formula.equals("true")) {
                    EA.setTruthValue(true);
                }
                C.setFormula(formula);
                formula = "";
                EAP.setCondition(C);
                continue;
            }
            if (line.equals("~begin-soln")) {
                S = new Solution();
                continue;
            }
            if (line.equals("~begin-eq")) {
                E = new Equation();
                continue;
            }
            if (line.equals("~end-eq")) {
                E.setFormula(formula);
                IASTNode tree = this.parse(formula);
                E.setTree(tree);
                formula = "";
                S.addEquation(E);
                continue;
            }
            if (line.equals("~end-soln")) {
                EAP.setSolution(S);
                continue;
            }
            if (line.equals("~end-pair")) {
                EA.addPair(EAP);
                continue;
            }
            if (line.equals("~end-list")) break;
            formula = formula + line;
        }
        return EA;
    }

    private IASTNode parse(String f) {
        IASTNode root = null;
        try {
            f = "void foo() { " + f + " }";
            root = this.parser.parseSingleStatement(f);
        }
        catch (Exception e) {
            this.logger.log(Level.FINEST, new Object[]{"Parser failed to parse Redlog output formula.", e.getMessage()});
        }
        return root;
    }

    public IASTNode parseFormula(String f) {
        return this.parse(f);
    }
}

