/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.redlog;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.IASTBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.IASTNode;
import org.sosy_lab.cpachecker.cfa.ast.IASTUnaryExpression;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.redlog.Substitution;

public class TreeReader {
    public static Rational evaluate(IASTNode N, Substitution S) {
        Rational r = null;
        String cn = N.getClass().getName();
        if (cn.endsWith("BinaryExpression")) {
            IASTBinaryExpression BE = (IASTBinaryExpression)N;
            String op = BE.getOperator().getOperator();
            Rational a = TreeReader.evaluate(BE.getOperand1(), S);
            Rational b = TreeReader.evaluate(BE.getOperand2(), S);
            try {
                r = a.operate(op, b);
            }
            catch (Exception e) {}
        } else if (cn.endsWith("UnaryExpression")) {
            IASTUnaryExpression U = (IASTUnaryExpression)N;
            Rational a = TreeReader.evaluate(U.getOperand(), S);
            try {
                r = a.times(new Rational(-1, 1));
            }
            catch (Exception e) {}
        } else if (cn.endsWith("IntegerLiteralExpression")) {
            IASTIntegerLiteralExpression I = (IASTIntegerLiteralExpression)N;
            BigInteger n = I.getValue();
            int m = n.intValue();
            try {
                r = new Rational(m, 1);
            }
            catch (Exception e) {}
        } else if (cn.endsWith("IdExpression")) {
            IASTIdExpression ID = (IASTIdExpression)N;
            String v = ID.getName().toString();
            r = S.get(v);
        } else {
            System.err.println("Unrecognized node type.");
        }
        return r;
    }
}

