/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;

public class Purification {
    private final String prefix;
    private AtomicInteger nextUsableIndex = new AtomicInteger(0);
    private HashMap<String, TemplateTerm> defs = new HashMap();
    private HashMap<Integer, TemplateUIF> UIFByIndex = new HashMap();
    private HashMap<String, TemplateUIF> UIFByVarString = new HashMap();
    private HashMap<String, TemplateTerm> TTByVarString = new HashMap();
    private HashMap<String, Set<String>> varsByFunctionName = new HashMap();

    public Purification() {
        this.prefix = "u";
    }

    public Purification(String prefix) {
        this.prefix = prefix;
    }

    public int size() {
        return this.defs.size();
    }

    public Collection<TemplateTerm> getAllFreshVariables() {
        return this.defs.values();
    }

    public Collection<String> getFunctionNames() {
        return this.varsByFunctionName.keySet();
    }

    public Set<String> getVarsForFunction(String func_name) {
        Set<String> vars = new HashSet<String>();
        if (this.varsByFunctionName.containsKey(func_name)) {
            vars = this.varsByFunctionName.get(func_name);
        }
        return vars;
    }

    public TemplateUIF getUIFByIndex(int n) {
        Integer N = new Integer(n);
        TemplateUIF F = null;
        if (this.UIFByIndex.containsKey(N)) {
            F = this.UIFByIndex.get(N);
        }
        return F;
    }

    public TemplateUIF getUIFByVarString(String ui) {
        TemplateUIF F = null;
        if (this.UIFByVarString.containsKey(ui)) {
            F = this.UIFByVarString.get(ui);
        }
        return F;
    }

    public TemplateTerm getTTByVarString(String ui) {
        TemplateTerm T = null;
        if (this.TTByVarString.containsKey(ui)) {
            T = this.TTByVarString.get(ui);
        }
        return T;
    }

    public void purify(TemplateUIF F) {
        String signature = F.toString(VariableWriteMode.PLAIN);
        TemplateTerm A = this.getPurename(signature);
        F.setPurifiedName(A);
        Integer I = A.getVariableIndex();
        this.UIFByIndex.put(I, F);
        String ui = A.toString(VariableWriteMode.PLAIN);
        this.partitionByName(ui, F);
        this.UIFByVarString.put(ui, F);
        this.TTByVarString.put(ui, A);
    }

    private void partitionByName(String ui, TemplateUIF F) {
        String name = F.getName();
        if (this.varsByFunctionName.containsKey(name)) {
            this.varsByFunctionName.get(name).add(ui);
        } else {
            HashSet<String> S = new HashSet<String>();
            S.add(ui);
            this.varsByFunctionName.put(name, S);
        }
    }

    private TemplateTerm getPurename(String signature) {
        TemplateTerm T = null;
        if (this.defs.containsKey(signature)) {
            T = this.defs.get(signature);
        } else {
            T = this.nextAlias();
            this.defs.put(signature, T);
        }
        return T;
    }

    private TemplateTerm nextAlias() {
        int n = this.nextUsableIndex.incrementAndGet();
        TemplateVariable V = new TemplateVariable(this.prefix, n);
        TemplateTerm T = new TemplateTerm();
        T.setVariable(V);
        return T;
    }

    public String toString() {
        String s = "";
        Set<String> signatures = this.defs.keySet();
        for (String sig : signatures) {
            String t = this.defs.get(sig).toString();
            s = s + t + " = " + sig + "\n";
        }
        return s;
    }
}

