/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.interfaces.Template;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateDisjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFalse;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNegation;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSumList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTrue;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TermForm;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateConjunction
extends TemplateBoolean
implements Template {
    private Vector<TemplateBoolean> conjuncts = new Vector();

    public TemplateConjunction() {
    }

    public TemplateConjunction(Vector<TemplateBoolean> c) {
        this.conjuncts = c;
    }

    public TemplateConjunction(TemplateBoolean b1, TemplateBoolean b2) {
        this.conjuncts = new Vector();
        this.conjuncts.add(b1);
        this.conjuncts.add(b2);
        this.flatten();
    }

    public static TemplateBoolean conjoin(TemplateBoolean b1, TemplateBoolean b2) {
        TemplateBoolean tb = b1.isTrue() ? b2 : (b2.isTrue() ? b1 : (b1.isFalse() || b2.isFalse() ? new TemplateFalse() : new TemplateConjunction(b1, b2)));
        return tb;
    }

    public TemplateConjunction(TemplateSumList L1, TemplateSumList L2) {
        Iterator<TemplateSum> I1 = L1.iterator();
        Iterator<TemplateSum> I2 = L2.iterator();
        while (I1.hasNext() && I2.hasNext()) {
            TemplateSum S1 = I1.next();
            TemplateSum S2 = I2.next();
            TemplateConstraint C = new TemplateConstraint(S1, InfixReln.EQUAL, S2);
            this.conjuncts.add(C);
        }
    }

    public static TemplateDisjunction distribute(Collection<TemplateDisjunction> tds) {
        Vector<TemplateDisjunction> tdlist = new Vector<TemplateDisjunction>(tds);
        TemplateDisjunction disj = null;
        int N = tdlist.size();
        if (N == 1) {
            disj = tdlist.get(0);
        } else if (N == 2) {
            TemplateDisjunction a = tdlist.get(0);
            TemplateDisjunction b = tdlist.get(1);
            Vector<TemplateBoolean> disjuncts = new Vector<TemplateBoolean>();
            Vector<TemplateBoolean> aC = a.getDisjuncts();
            Vector<TemplateBoolean> bC = b.getDisjuncts();
            for (TemplateBoolean ac : aC) {
                for (TemplateBoolean bc : bC) {
                    Vector<TemplateBoolean> p = new Vector<TemplateBoolean>(2);
                    p.add(ac);
                    p.add(bc);
                    TemplateConjunction d = new TemplateConjunction(p);
                    disjuncts.add(d);
                }
            }
            disj = new TemplateDisjunction(disjuncts);
        } else if (N >= 3) {
            Vector<TemplateDisjunction> tail = new Vector<TemplateDisjunction>(N - 1);
            for (int i = 1; i < N; ++i) {
                tail.add(tdlist.get(i));
            }
            TemplateDisjunction b = TemplateConjunction.distribute(tail);
            TemplateDisjunction a = tdlist.get(0);
            Vector<TemplateDisjunction> pair = new Vector<TemplateDisjunction>(2);
            pair.add(a);
            pair.add(b);
            disj = TemplateConjunction.distribute(pair);
        }
        return disj;
    }

    @Override
    public TemplateBoolean makeCNF() {
        TemplateBoolean tb;
        this.flatten();
        Vector<TemplateBoolean> newconjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            tb = this.getConjunct(i);
            tb = tb.makeCNF();
            newconjuncts.add(tb);
        }
        tb = new TemplateConjunction(newconjuncts);
        tb.flatten();
        return tb;
    }

    @Override
    public TemplateBoolean makeDNF() {
        TemplateDisjunction td;
        this.flatten();
        Vector<TemplateBoolean> literals = new Vector<TemplateBoolean>();
        ArrayDeque<TemplateDisjunction> disjunctions = new ArrayDeque<TemplateDisjunction>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tb = this.getConjunct(i);
            if (tb instanceof TemplateDisjunction) {
                td = (TemplateDisjunction)tb.makeDNF();
                disjunctions.add(td);
                continue;
            }
            if (tb instanceof TemplateNegation) {
                if ((tb = tb.makeDNF()) instanceof TemplateDisjunction) {
                    td = (TemplateDisjunction)tb;
                    disjunctions.add(td);
                    continue;
                }
                literals.add(tb);
                continue;
            }
            literals.add(tb);
        }
        if (literals.size() > 0) {
            TemplateConjunction cj = new TemplateConjunction(literals);
            Vector<TemplateBoolean> justCj = new Vector<TemplateBoolean>();
            justCj.add(cj);
            TemplateDisjunction k0 = new TemplateDisjunction(justCj);
            disjunctions.addFirst(k0);
        }
        td = TemplateConjunction.distribute(disjunctions);
        td.flatten();
        return td;
    }

    @Override
    public TemplateBoolean logicNegate() {
        Vector<TemplateBoolean> disjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tb = this.getConjunct(i);
            tb = TemplateNegation.negate(tb);
            disjuncts.add(tb);
        }
        return new TemplateDisjunction(disjuncts);
    }

    @Override
    public TemplateBoolean absorbNegations() {
        Vector<TemplateBoolean> conjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tb = this.getConjunct(i).absorbNegations();
            conjuncts.add(tb);
        }
        return new TemplateConjunction(conjuncts);
    }

    @Override
    public void flatten() {
        Vector<TemplateBoolean> newconjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tb = this.getConjunct(i);
            tb.flatten();
            if (this.getClass().isInstance(tb)) {
                TemplateConjunction tc = (TemplateConjunction)tb;
                Vector<TemplateBoolean> subconjuncts = tc.getConjuncts();
                newconjuncts.addAll(subconjuncts);
                continue;
            }
            newconjuncts.add(tb);
        }
        this.conjuncts = newconjuncts;
    }

    @Override
    public TemplateConjunction copy() {
        Vector<TemplateBoolean> v = new Vector<TemplateBoolean>();
        for (TemplateBoolean c : this.conjuncts) {
            v.add(c.copy());
        }
        TemplateConjunction c = new TemplateConjunction(v);
        return c;
    }

    @Override
    public void alias(AliasingMap amap) {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.alias(amap);
        }
    }

    @Override
    public void unalias() {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.unalias();
        }
    }

    @Override
    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            ans &= tc.evaluate(map);
        }
        return ans;
    }

    @Override
    public void unevaluate() {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.unevaluate();
        }
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.postindex(indices);
        }
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.preindex(indices);
        }
    }

    @Override
    public void unindex() {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.unindex();
        }
    }

    @Override
    public Purification purify(Purification pur) {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            pur = tc.purify(pur);
        }
        return pur;
    }

    @Override
    public void unpurify() {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tc.unpurify();
        }
    }

    @Override
    public Vector<TemplateConstraint> getConstraints() {
        Vector<TemplateConstraint> v = new Vector<TemplateConstraint>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tb = this.getConjunct(i);
            v.addAll(tb.getConstraints());
        }
        return v;
    }

    @Override
    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            vars.addAll(tc.getAllVariables(vwm));
        }
        return vars;
    }

    @Override
    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            params.addAll(tc.getAllParameters());
        }
        return params;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            map = tc.getMaxIndices(map);
        }
        return map;
    }

    @Override
    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager tvm = new TemplateVariableManager();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            tvm.merge(tc.getVariableManager());
        }
        return tvm;
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        int N = this.getNumConjuncts();
        if (N == 0) {
            form = fmgr.makeTrue();
        } else {
            assert (N >= 1);
            form = this.getConjunct(0).translate(fmgr);
            for (int i = 1; i < N; ++i) {
                Formula augend = this.getConjunct(i).translate(fmgr);
                form = fmgr.makeAnd(form, augend);
            }
        }
        return form;
    }

    @Override
    public List<TemplateFormula> extractAtoms(boolean sAE, boolean cO) {
        Vector<TemplateFormula> atoms = new Vector<TemplateFormula>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            if (cO) {
                atoms.add(tc);
                continue;
            }
            atoms.addAll(tc.extractAtoms(sAE, cO));
        }
        return atoms;
    }

    @Override
    public Set<TermForm> getTopLevelTermForms() {
        HashSet<TermForm> forms = new HashSet<TermForm>();
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean tc = this.getConjunct(i);
            forms.addAll(tc.getTopLevelTermForms());
        }
        return forms;
    }

    public Vector<TemplateBoolean> getConjuncts() {
        return this.conjuncts;
    }

    public int getNumConjuncts() {
        return this.conjuncts.size();
    }

    public TemplateBoolean getConjunct(int i) {
        return this.conjuncts.get(i);
    }

    @Override
    public Set<TemplateTerm> getRHSTerms() {
        HashSet<TemplateTerm> s = new HashSet<TemplateTerm>();
        for (TemplateBoolean c : this.conjuncts) {
            s.addAll(c.getRHSTerms());
        }
        return s;
    }

    @Override
    public void prefixVariables(String prefix) {
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean C = this.getConjunct(i);
            C.prefixVariables(prefix);
        }
    }

    @Override
    public boolean isTrue() {
        boolean ans = true;
        for (TemplateBoolean TB : this.conjuncts) {
            ans &= TB.isTrue();
        }
        return ans;
    }

    public static boolean isInstance(Object obj) {
        TemplateConjunction c = new TemplateConjunction();
        return c.getClass().isInstance(obj);
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = "";
        for (int i = 0; i < this.getNumConjuncts(); ++i) {
            TemplateBoolean C = this.getConjunct(i);
            if (TemplateTrue.isInstance(C)) continue;
            if (TemplateFalse.isInstance(C)) {
                s = "false";
                return s;
            }
            s = s + " and " + C.toString(vwm);
        }
        if (s.length() > 0) {
            s = s.substring(5);
        }
        return s;
    }
}

