/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Coeff;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.interfaces.Constraint;
import org.sosy_lab.cpachecker.util.invariants.interfaces.VariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateDisjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TermForm;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateConstraint
extends TemplateBoolean
implements Constraint {
    private TemplateSum LHS = null;
    private InfixReln reln = null;
    private TemplateSum RHS = null;

    public TemplateConstraint() {
        this.LHS = new TemplateSum();
        this.RHS = new TemplateSum();
    }

    public TemplateConstraint(TemplateSum s1, InfixReln R, TemplateSum s2) {
        this.construct(s1, R, s2);
    }

    public TemplateConstraint(TemplateVariable v, InfixReln R) {
        TemplateTerm t = new TemplateTerm();
        t.setParameter(v);
        TemplateTerm z = TemplateTerm.makeZero();
        this.LHS = t;
        this.reln = R;
        this.RHS = z;
    }

    private void construct(TemplateSum s1, InfixReln R, TemplateSum s2) {
        this.reln = R;
        TemplateSum C1 = s1.getConstantPart();
        TemplateSum V1 = s1.getNonConstantPart();
        TemplateSum C2 = s2.getConstantPart();
        TemplateSum V2 = s2.getNonConstantPart();
        this.LHS = TemplateSum.subtract(V1, V2);
        this.RHS = TemplateSum.subtract(C2, C1);
    }

    @Override
    public TemplateConstraint copy() {
        TemplateConstraint c = new TemplateConstraint(this.LHS.copy(), this.reln, this.RHS.copy());
        return c;
    }

    @Override
    public void flatten() {
    }

    @Override
    public TemplateBoolean makeCNF() {
        Vector<TemplateBoolean> v = new Vector<TemplateBoolean>(1);
        v.add(this);
        return new TemplateConjunction(v);
    }

    @Override
    public TemplateBoolean makeDNF() {
        Vector<TemplateBoolean> v = new Vector<TemplateBoolean>(1);
        v.add(this);
        return new TemplateDisjunction(v);
    }

    @Override
    public TemplateBoolean logicNegate() {
        TemplateBoolean tb = null;
        switch (this.reln) {
            case LEQ: {
                tb = new TemplateConstraint(this.RHS.copy(), InfixReln.LT, this.LHS.copy());
                break;
            }
            case LT: {
                tb = new TemplateConstraint(this.RHS.copy(), InfixReln.LEQ, this.LHS.copy());
                break;
            }
            case EQUAL: {
                Vector<TemplateBoolean> v = new Vector<TemplateBoolean>(2);
                TemplateConstraint tc1 = new TemplateConstraint(this.LHS.copy(), InfixReln.LT, this.RHS.copy());
                TemplateConstraint tc2 = new TemplateConstraint(this.RHS.copy(), InfixReln.LT, this.LHS.copy());
                v.add(tc1);
                v.add(tc2);
                tb = new TemplateDisjunction(v);
            }
        }
        return tb;
    }

    @Override
    public TemplateBoolean absorbNegations() {
        return this;
    }

    @Override
    public void alias(AliasingMap amap) {
        this.LHS.alias(amap);
        this.RHS.alias(amap);
    }

    @Override
    public void unalias() {
        this.LHS.unalias();
        this.RHS.unalias();
    }

    @Override
    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        ans &= this.LHS.evaluate(map);
        return ans &= this.RHS.evaluate(map);
    }

    @Override
    public void unevaluate() {
        this.LHS.unevaluate();
        this.RHS.unevaluate();
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        this.LHS.postindex(indices);
        this.RHS.postindex(indices);
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        this.LHS.preindex(indices);
        this.RHS.preindex(indices);
    }

    @Override
    public void unindex() {
        this.LHS.unindex();
        this.RHS.unindex();
    }

    @Override
    public Purification purify(Purification pur) {
        pur = this.LHS.purify(pur);
        pur = this.RHS.purify(pur);
        return pur;
    }

    @Override
    public void unpurify() {
        this.LHS.unpurify();
        this.RHS.unpurify();
    }

    @Override
    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.LHS.getAllVariables(vwm));
        vars.addAll(this.RHS.getAllVariables(vwm));
        return vars;
    }

    @Override
    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        params.addAll(this.LHS.getAllParameters());
        params.addAll(this.RHS.getAllParameters());
        return params;
    }

    public Set<TemplateVariable> getTopLevelParameters() {
        HashSet<TemplateVariable> tlp = new HashSet<TemplateVariable>();
        tlp.addAll(this.LHS.getTopLevelParameters());
        tlp.addAll(this.RHS.getTopLevelParameters());
        return tlp;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        map = this.LHS.getMaxIndices(map);
        map = this.RHS.getMaxIndices(map);
        return map;
    }

    @Override
    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager tvm = new TemplateVariableManager();
        tvm.merge(this.LHS.getVariableManager());
        tvm.merge(this.RHS.getVariableManager());
        return tvm;
    }

    @Override
    public void prefixVariables(String prefix) {
        this.LHS.prefixVariables(prefix);
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        Formula lhs = this.LHS.translate(fmgr);
        Formula rhs = this.RHS.translate(fmgr);
        switch (this.reln) {
            case EQUAL: {
                form = fmgr.makeEqual(lhs, rhs);
                break;
            }
            case LEQ: {
                form = fmgr.makeLeq(lhs, rhs);
                break;
            }
            case LT: {
                form = fmgr.makeLt(lhs, rhs);
            }
        }
        return form;
    }

    @Override
    public List<TemplateFormula> extractAtoms(boolean sAE, boolean cO) {
        Vector<TemplateFormula> atoms = new Vector<TemplateFormula>();
        if (!sAE) {
            atoms.add(this);
        } else {
            TemplateConstraint tc1 = new TemplateConstraint(this.LHS, InfixReln.LEQ, this.RHS);
            TemplateConstraint tc2 = new TemplateConstraint(this.RHS, InfixReln.LEQ, this.LHS);
            atoms.add(tc1);
            atoms.add(tc2);
        }
        return atoms;
    }

    @Override
    public Set<TemplateUIF> getAllTopLevelUIFs() {
        return this.LHS.getAllTopLevelUIFs();
    }

    @Override
    public Set<TemplateVariable> getTopLevelLHSParameters() {
        return this.LHS.getTopLevelParameters();
    }

    @Override
    public Set<TemplateTerm> getTopLevelTerms() {
        Vector<TemplateTerm> terms = this.LHS.getTerms();
        terms.addAll(this.RHS.getTerms());
        HashSet<TemplateTerm> set = new HashSet<TemplateTerm>(terms);
        return set;
    }

    @Override
    public Set<TemplateVariable> getAllPurificationVariables() {
        Set<TemplateVariable> pvs = this.LHS.getAllPurificationVariables();
        pvs.addAll(this.RHS.getAllPurificationVariables());
        return pvs;
    }

    @Override
    public Set<TermForm> getTopLevelTermForms() {
        TemplateSum copy = this.LHS.copy();
        copy.purify(new Purification());
        copy.unpurify();
        Vector<TemplateTerm> terms = copy.getTerms();
        HashSet<TermForm> forms = new HashSet<TermForm>();
        for (TemplateTerm t : terms) {
            forms.add(new TermForm(t));
        }
        return forms;
    }

    @Override
    public Vector<TemplateConstraint> getConstraints() {
        Vector<TemplateConstraint> v = new Vector<TemplateConstraint>();
        v.add(this);
        return v;
    }

    @Override
    public Set<TemplateTerm> getRHSTerms() {
        HashSet<TemplateTerm> s = new HashSet<TemplateTerm>(this.RHS.getTerms());
        return s;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public List<Coeff> getNormalFormCoeffs(VariableManager vmgr, VariableWriteMode vwm) {
        return this.LHS.getCoeffsWithParams(vwm, vmgr);
    }

    @Override
    public Coeff getNormalFormConstant(VariableWriteMode vwm) {
        return new Coeff(this.RHS, vwm);
    }

    @Override
    public Coeff getNormalFormConstantMinusOne(VariableWriteMode vwm) {
        return new Coeff(this.RHS.minusOne(), vwm);
    }

    @Override
    public InfixReln getInfixReln() {
        return this.reln;
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = "";
        if (this.LHS != null && this.reln != null && this.RHS != null) {
            s = this.LHS.toString(vwm);
            s = s + " " + this.reln.toString() + " ";
            s = s + this.RHS.toString(vwm);
        }
        return s;
    }
}

