/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.Rational;
import org.sosy_lab.cpachecker.util.invariants.templates.AliasingMap;
import org.sosy_lab.cpachecker.util.invariants.templates.Purification;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFalse;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNegation;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTrue;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariableManager;
import org.sosy_lab.cpachecker.util.invariants.templates.TermForm;
import org.sosy_lab.cpachecker.util.invariants.templates.VariableWriteMode;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateDisjunction
extends TemplateBoolean {
    private Vector<TemplateBoolean> disjuncts = new Vector();

    public TemplateDisjunction() {
    }

    public TemplateDisjunction(Vector<TemplateBoolean> c) {
        this.disjuncts = c;
    }

    public TemplateDisjunction(TemplateBoolean b1, TemplateBoolean b2) {
        this.disjuncts = new Vector();
        this.disjuncts.add(b1);
        this.disjuncts.add(b2);
        this.flatten();
    }

    public static TemplateBoolean disjoin(TemplateBoolean b1, TemplateBoolean b2) {
        TemplateBoolean tb = b1.isFalse() ? b2 : (b2.isFalse() ? b1 : (b1.isTrue() || b2.isTrue() ? new TemplateTrue() : new TemplateDisjunction(b1, b2)));
        return tb;
    }

    public static TemplateConjunction distribute(Collection<TemplateConjunction> tcs) {
        Vector<TemplateConjunction> tclist = new Vector<TemplateConjunction>(tcs);
        TemplateConjunction conj = null;
        int N = tclist.size();
        if (N == 1) {
            conj = tclist.get(0);
        } else if (N == 2) {
            TemplateConjunction a = tclist.get(0);
            TemplateConjunction b = tclist.get(1);
            Vector<TemplateBoolean> conjuncts = new Vector<TemplateBoolean>();
            Vector<TemplateBoolean> aC = a.getConjuncts();
            Vector<TemplateBoolean> bC = b.getConjuncts();
            for (TemplateBoolean ac : aC) {
                for (TemplateBoolean bc : bC) {
                    Vector<TemplateBoolean> p = new Vector<TemplateBoolean>(2);
                    p.add(ac);
                    p.add(bc);
                    TemplateDisjunction d = new TemplateDisjunction(p);
                    conjuncts.add(d);
                }
            }
            conj = new TemplateConjunction(conjuncts);
        } else if (N >= 3) {
            Vector<TemplateConjunction> tail = new Vector<TemplateConjunction>(N - 1);
            for (int i = 1; i < N; ++i) {
                tail.add(tclist.get(i));
            }
            TemplateConjunction b = TemplateDisjunction.distribute(tail);
            TemplateConjunction a = tclist.get(0);
            Vector<TemplateConjunction> pair = new Vector<TemplateConjunction>(2);
            pair.add(a);
            pair.add(b);
            conj = TemplateDisjunction.distribute(pair);
        }
        return conj;
    }

    @Override
    public TemplateBoolean makeCNF() {
        TemplateConjunction tc;
        this.flatten();
        Vector<TemplateBoolean> literals = new Vector<TemplateBoolean>();
        ArrayDeque<TemplateConjunction> conjunctions = new ArrayDeque<TemplateConjunction>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            if (tb instanceof TemplateConjunction) {
                tc = (TemplateConjunction)tb.makeCNF();
                conjunctions.add(tc);
                continue;
            }
            if (tb instanceof TemplateNegation) {
                if ((tb = tb.makeCNF()) instanceof TemplateConjunction) {
                    tc = (TemplateConjunction)tb;
                    conjunctions.add(tc);
                    continue;
                }
                literals.add(tb);
                continue;
            }
            literals.add(tb);
        }
        if (literals.size() > 0) {
            TemplateDisjunction dj = new TemplateDisjunction(literals);
            Vector<TemplateBoolean> justDj = new Vector<TemplateBoolean>();
            justDj.add(dj);
            TemplateConjunction k0 = new TemplateConjunction(justDj);
            conjunctions.addFirst(k0);
        }
        tc = TemplateDisjunction.distribute(conjunctions);
        tc.flatten();
        return tc;
    }

    @Override
    public TemplateBoolean makeDNF() {
        TemplateBoolean tb;
        this.flatten();
        Vector<TemplateBoolean> newdisjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            tb = this.getDisjunct(i);
            tb = tb.makeDNF();
            newdisjuncts.add(tb);
        }
        tb = new TemplateDisjunction(newdisjuncts);
        tb.flatten();
        return tb;
    }

    @Override
    public TemplateBoolean logicNegate() {
        Vector<TemplateBoolean> conjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb = TemplateNegation.negate(tb);
            conjuncts.add(tb);
        }
        return new TemplateConjunction(conjuncts);
    }

    @Override
    public TemplateBoolean absorbNegations() {
        Vector<TemplateBoolean> disjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i).absorbNegations();
            disjuncts.add(tb);
        }
        return new TemplateDisjunction(disjuncts);
    }

    @Override
    public void flatten() {
        Vector<TemplateBoolean> newdisjuncts = new Vector<TemplateBoolean>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.flatten();
            if (this.getClass().isInstance(tb)) {
                TemplateDisjunction td = (TemplateDisjunction)tb;
                Vector<TemplateBoolean> subdisjuncts = td.getDisjuncts();
                newdisjuncts.addAll(subdisjuncts);
                continue;
            }
            newdisjuncts.add(tb);
        }
        this.disjuncts = newdisjuncts;
    }

    @Override
    public TemplateDisjunction copy() {
        Vector<TemplateBoolean> v = new Vector<TemplateBoolean>();
        for (TemplateBoolean c : this.disjuncts) {
            v.add(c.copy());
        }
        TemplateDisjunction c = new TemplateDisjunction(v);
        return c;
    }

    @Override
    public void alias(AliasingMap amap) {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.alias(amap);
        }
    }

    @Override
    public void unalias() {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.unalias();
        }
    }

    @Override
    public boolean evaluate(Map<String, Rational> map) {
        boolean ans = true;
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            ans &= tb.evaluate(map);
        }
        return ans;
    }

    @Override
    public void unevaluate() {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.unevaluate();
        }
    }

    @Override
    public void postindex(Map<String, Integer> indices) {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.postindex(indices);
        }
    }

    @Override
    public void preindex(Map<String, Integer> indices) {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.preindex(indices);
        }
    }

    @Override
    public void unindex() {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.unindex();
        }
    }

    @Override
    public Purification purify(Purification pur) {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            pur = tb.purify(pur);
        }
        return pur;
    }

    @Override
    public void unpurify() {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            tb.unpurify();
        }
    }

    @Override
    public Vector<TemplateConstraint> getConstraints() {
        Vector<TemplateConstraint> v = new Vector<TemplateConstraint>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tb = this.getDisjunct(i);
            v.addAll(tb.getConstraints());
        }
        return v;
    }

    @Override
    public Set<String> getAllVariables(VariableWriteMode vwm) {
        HashSet<String> vars = new HashSet<String>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tc = this.getDisjunct(i);
            vars.addAll(tc.getAllVariables(vwm));
        }
        return vars;
    }

    @Override
    public Set<TemplateVariable> getAllParameters() {
        HashSet<TemplateVariable> params = new HashSet<TemplateVariable>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tc = this.getDisjunct(i);
            params.addAll(tc.getAllParameters());
        }
        return params;
    }

    @Override
    public HashMap<String, Integer> getMaxIndices(HashMap<String, Integer> map) {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tc = this.getDisjunct(i);
            map = tc.getMaxIndices(map);
        }
        return map;
    }

    @Override
    public TemplateVariableManager getVariableManager() {
        TemplateVariableManager tvm = new TemplateVariableManager();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tc = this.getDisjunct(i);
            tvm.merge(tc.getVariableManager());
        }
        return tvm;
    }

    @Override
    public Formula translate(FormulaManager fmgr) {
        Formula form = null;
        int N = this.getNumDisjuncts();
        if (N == 0) {
            form = fmgr.makeFalse();
        } else {
            assert (N >= 1);
            form = this.getDisjunct(0).translate(fmgr);
            for (int i = 1; i < N; ++i) {
                Formula augend = this.getDisjunct(i).translate(fmgr);
                form = fmgr.makeOr(form, augend);
            }
        }
        return form;
    }

    @Override
    public List<TemplateFormula> extractAtoms(boolean sAE, boolean cO) {
        Vector<TemplateFormula> atoms = new Vector<TemplateFormula>();
        if (cO) {
            atoms.add(this);
        } else {
            for (int i = 0; i < this.getNumDisjuncts(); ++i) {
                TemplateBoolean tc = this.getDisjunct(i);
                atoms.addAll(tc.extractAtoms(sAE, cO));
            }
        }
        return atoms;
    }

    @Override
    public Set<TermForm> getTopLevelTermForms() {
        HashSet<TermForm> forms = new HashSet<TermForm>();
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean tc = this.getDisjunct(i);
            forms.addAll(tc.getTopLevelTermForms());
        }
        return forms;
    }

    public Vector<TemplateBoolean> getDisjuncts() {
        return this.disjuncts;
    }

    public int getNumDisjuncts() {
        return this.disjuncts.size();
    }

    public TemplateBoolean getDisjunct(int i) {
        return this.disjuncts.get(i);
    }

    @Override
    public Set<TemplateTerm> getRHSTerms() {
        HashSet<TemplateTerm> s = new HashSet<TemplateTerm>();
        for (TemplateBoolean c : this.disjuncts) {
            s.addAll(c.getRHSTerms());
        }
        return s;
    }

    @Override
    public void prefixVariables(String prefix) {
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean C = this.getDisjunct(i);
            C.prefixVariables(prefix);
        }
    }

    @Override
    public boolean isTrue() {
        boolean ans = false;
        for (TemplateBoolean TB : this.disjuncts) {
            ans |= TB.isTrue();
        }
        return ans;
    }

    @Override
    public String toString() {
        return this.toString(VariableWriteMode.PLAIN);
    }

    @Override
    public String toString(VariableWriteMode vwm) {
        String s = "";
        for (int i = 0; i < this.getNumDisjuncts(); ++i) {
            TemplateBoolean C = this.getDisjunct(i);
            if (TemplateFalse.isInstance(C)) continue;
            if (TemplateTrue.isInstance(C)) {
                s = "true";
                break;
            }
            s = s + " OR " + C.toString(vwm);
        }
        if (s.length() > 0) {
            s = s.substring(4);
        }
        s = "( " + s + " )";
        return s;
    }
}

