/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.invariants.templates;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.sosy_lab.cpachecker.util.invariants.InfixReln;
import org.sosy_lab.cpachecker.util.invariants.templates.NonTemplate;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateBoolean;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateConstraint;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateDisjunction;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFalse;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormula;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateFormulaList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNegation;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateNumber;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSum;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateSumList;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTerm;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateTrue;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateUIF;
import org.sosy_lab.cpachecker.util.invariants.templates.TemplateVariable;
import org.sosy_lab.cpachecker.util.predicates.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaList;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

public class TemplateFormulaManager
implements FormulaManager {
    private final TemplateParseMode tpMode;

    public TemplateFormulaManager() {
        this.tpMode = TemplateParseMode.PATHFORMULA;
    }

    public TemplateFormulaManager(TemplateParseMode tpm) {
        this.tpMode = tpm;
    }

    @Override
    public boolean isBoolean(Formula pF) {
        return pF instanceof TemplateBoolean;
    }

    @Override
    public Formula makeTrue() {
        return new TemplateTrue();
    }

    @Override
    public Formula makeFalse() {
        return new TemplateFalse();
    }

    @Override
    public Formula makeNot(Formula f) {
        TemplateFormula F = null;
        try {
            TemplateBoolean b = (TemplateBoolean)f;
            F = TemplateNegation.negate(b);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeAnd(Formula f1, Formula f2) {
        TemplateFormula F = null;
        try {
            TemplateBoolean b1 = (TemplateBoolean)f1;
            TemplateBoolean b2 = (TemplateBoolean)f2;
            F = TemplateConjunction.conjoin(b1, b2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeOr(Formula f1, Formula f2) {
        TemplateFormula F = null;
        try {
            TemplateBoolean b1 = (TemplateBoolean)f1;
            TemplateBoolean b2 = (TemplateBoolean)f2;
            F = TemplateDisjunction.disjoin(b1, b2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeEquivalence(Formula f1, Formula f2) {
        TemplateFormula F = null;
        try {
            TemplateBoolean b1 = (TemplateBoolean)f1;
            TemplateBoolean b2 = (TemplateBoolean)f2;
            TemplateBoolean nb1 = TemplateNegation.negate(b1);
            TemplateBoolean nb2 = TemplateNegation.negate(b2);
            TemplateBoolean both = TemplateConjunction.conjoin(b1, b2);
            TemplateBoolean neither = TemplateConjunction.conjoin(nb1, nb2);
            F = TemplateDisjunction.disjoin(both, neither);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeIfThenElse(Formula cond, Formula f1, Formula f2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeNumber(int pI) {
        TemplateNumber N = new TemplateNumber(pI);
        TemplateTerm T = new TemplateTerm();
        T.setCoefficient(N);
        return T;
    }

    @Override
    public Formula makeNumber(String pI) {
        TemplateNumber N = new TemplateNumber(pI);
        TemplateTerm T = new TemplateTerm();
        T.setCoefficient(N);
        return T;
    }

    @Override
    public Formula makeNegate(Formula pF) {
        TemplateFormula tf = null;
        try {
            tf = (TemplateFormula)pF;
            tf.negate();
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
        }
        return tf;
    }

    @Override
    public Formula makePlus(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateSum(s1, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeMinus(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = TemplateSum.subtract(s1, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeDivide(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = TemplateSum.divide(s1, s2);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeModulo(Formula pF1, Formula pF2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeMultiply(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = TemplateSum.multiply(s1, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeEqual(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateConstraint(s1, InfixReln.EQUAL, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeGt(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateConstraint(s2, InfixReln.LT, s1);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeGeq(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateConstraint(s2, InfixReln.LEQ, s1);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeLt(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateConstraint(s1, InfixReln.LT, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeLeq(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateConstraint(s1, InfixReln.LEQ, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeBitwiseNot(Formula pF) {
        return new NonTemplate();
    }

    @Override
    public Formula makeBitwiseAnd(Formula pF1, Formula pF2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeBitwiseOr(Formula pF1, Formula pF2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeBitwiseXor(Formula pF1, Formula pF2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeShiftLeft(Formula pF1, Formula pF2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeShiftRight(Formula pF1, Formula pF2) {
        return new NonTemplate();
    }

    @Override
    public Formula makeUIF(String pName, FormulaList pArgs) {
        TemplateFormula F = null;
        try {
            TemplateFormulaList FL = (TemplateFormulaList)pArgs;
            TemplateSumList SL = new TemplateSumList(FL);
            TemplateUIF U = new TemplateUIF(pName, SL);
            TemplateTerm T = new TemplateTerm();
            T.setUIF(U);
            F = T;
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeUIF(String pName, FormulaList pArgs, int pIdx) {
        TemplateFormula F = null;
        try {
            TemplateFormulaList FL = (TemplateFormulaList)pArgs;
            TemplateSumList SL = new TemplateSumList(FL);
            TemplateUIF U = new TemplateUIF(pName, SL, pIdx);
            TemplateTerm T = new TemplateTerm();
            T.setUIF(U);
            F = T;
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public Formula makeString(int pI) {
        return new NonTemplate();
    }

    @Override
    public Formula makeVariable(String pVar, int pIdx) {
        Integer i = new Integer(pIdx);
        return this.makeVariable(pVar, i);
    }

    @Override
    public Formula makeVariable(String pVar) {
        return this.makeVariable(pVar, null);
    }

    private Formula makeVariable(String pVar, Integer pIdx) {
        TemplateTerm T = new TemplateTerm();
        if (this.tpMode == TemplateParseMode.TEMPLATE) {
            if (pVar != null && pVar.length() > 0 && pVar.startsWith("v")) {
                pVar = pVar.substring(1);
                TemplateVariable V = new TemplateVariable(pVar, pIdx);
                T.setVariable(V);
            } else {
                TemplateVariable V = new TemplateVariable(pVar, pIdx);
                T.setParameter(V);
            }
        } else {
            TemplateVariable V = new TemplateVariable(pVar, pIdx);
            T.setVariable(V);
        }
        return T;
    }

    @Override
    public Formula makePredicateVariable(String pVar, int pIdx) {
        return new NonTemplate();
    }

    @Override
    public Formula makeAssignment(Formula pF1, Formula pF2) {
        TemplateFormula F = null;
        try {
            TemplateSum s1 = (TemplateSum)pF1;
            TemplateSum s2 = (TemplateSum)pF2;
            F = new TemplateConstraint(s1, InfixReln.EQUAL, s2);
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            F = new NonTemplate();
        }
        return F;
    }

    @Override
    public FormulaList makeList(Formula pF) {
        Formula[] fs = new Formula[]{pF};
        return new TemplateFormulaList(fs);
    }

    @Override
    public FormulaList makeList(Formula pF1, Formula pF2) {
        Formula[] fs = new Formula[]{pF1, pF2};
        return new TemplateFormulaList(fs);
    }

    @Override
    public FormulaList makeList(List<Formula> pFs) {
        return new TemplateFormulaList(pFs);
    }

    public FormulaList makeList(Formula ... pF) {
        return new TemplateFormulaList(pF);
    }

    @Override
    public Formula parseInfix(String s) throws IllegalArgumentException {
        return null;
    }

    @Override
    public Formula parse(String s) throws IllegalArgumentException {
        return null;
    }

    @Override
    public Formula instantiate(Formula f, SSAMap ssa) {
        return null;
    }

    @Override
    @Deprecated
    public Formula uninstantiate(Formula pF) {
        return null;
    }

    @Override
    public Collection<Formula> extractAtoms(Formula f, boolean splitArithEqualities, boolean conjunctionsOnly) {
        TemplateFormula tf = null;
        try {
            tf = (TemplateFormula)f;
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (tf == null) {
            return null;
        }
        List<TemplateFormula> tfAtoms = tf.extractAtoms(splitArithEqualities, conjunctionsOnly);
        Vector<Formula> atoms = new Vector<Formula>(tfAtoms);
        return atoms;
    }

    @Override
    public String dumpFormula(Formula pT) {
        return null;
    }

    @Override
    public Formula getBitwiseAxioms(Formula f) {
        return null;
    }

    @Override
    public Formula createPredicateVariable(Formula pAtom) {
        return null;
    }

    @Override
    public Set<String> extractVariables(Formula f) {
        return null;
    }

    @Override
    public boolean checkSyntacticEntails(Formula pLeftFormula, Formula pRightFormula) {
        return false;
    }

    @Override
    public Formula[] getArguments(Formula pF) {
        return null;
    }

    @Override
    public Formula makeUIP(String pName, FormulaList pArgs) {
        return null;
    }

    @Override
    public void declareUIP(String pName, int pArgCount) {
    }

    @Override
    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    public static enum TemplateParseMode {
        TEMPLATE,
        PATHFORMULA;

    }
}

